/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.cookie.PublicSuffixFilter;

@Immutable
public class PublicSuffixListParser {
    private static final int MAX_LINE_LEN = 256;
    private final PublicSuffixFilter filter;

    PublicSuffixListParser(PublicSuffixFilter filter2) {
        this.filter = filter2;
    }

    public void parse(Reader list2) throws IOException {
        ArrayList<String> rules = new ArrayList<String>();
        ArrayList<String> exceptions2 = new ArrayList<String>();
        BufferedReader r = new BufferedReader(list2);
        StringBuilder sb = new StringBuilder(256);
        boolean more = true;
        while (more) {
            boolean isException;
            more = this.readLine(r, sb);
            String line2 = sb.toString();
            if (line2.length() == 0 || line2.startsWith("//")) continue;
            if (line2.startsWith(".")) {
                line2 = line2.substring(1);
            }
            if (isException = line2.startsWith("!")) {
                line2 = line2.substring(1);
            }
            if (isException) {
                exceptions2.add(line2);
                continue;
            }
            rules.add(line2);
        }
        this.filter.setPublicSuffixes(rules);
        this.filter.setExceptions(exceptions2);
    }

    private boolean readLine(Reader r, StringBuilder sb) throws IOException {
        char c;
        int b;
        sb.setLength(0);
        boolean hitWhitespace = false;
        while ((b = r.read()) != -1 && (c = (char)b) != '\n') {
            if (Character.isWhitespace(c)) {
                hitWhitespace = true;
            }
            if (!hitWhitespace) {
                sb.append(c);
            }
            if (sb.length() <= 256) continue;
            throw new IOException("Line too long");
        }
        return b != -1;
    }
}

