/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;

@Immutable
public class RFC2109DomainHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie2, String value2) throws MalformedCookieException {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (value2 == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (value2.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        cookie2.setDomain(value2);
    }

    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String host2 = origin.getHost();
        String domain2 = cookie2.getDomain();
        if (domain2 == null) {
            throw new CookieRestrictionViolationException("Cookie domain may not be null");
        }
        if (!domain2.equals(host2)) {
            int dotIndex = domain2.indexOf(46);
            if (dotIndex == -1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" does not match the host \"" + host2 + "\"");
            }
            if (!domain2.startsWith(".")) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates RFC 2109: domain must start with a dot");
            }
            dotIndex = domain2.indexOf(46, 1);
            if (dotIndex < 0 || dotIndex == domain2.length() - 1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates RFC 2109: domain must contain an embedded dot");
            }
            if (!(host2 = host2.toLowerCase(Locale.ENGLISH)).endsWith(domain2)) {
                throw new CookieRestrictionViolationException("Illegal domain attribute \"" + domain2 + "\". Domain of origin: \"" + host2 + "\"");
            }
            String hostWithoutDomain = host2.substring(0, host2.length() - domain2.length());
            if (hostWithoutDomain.indexOf(46) != -1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates RFC 2109: host minus domain may not contain any dots");
            }
        }
    }

    public boolean match(Cookie cookie2, CookieOrigin origin) {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String host2 = origin.getHost();
        String domain2 = cookie2.getDomain();
        if (domain2 == null) {
            return false;
        }
        return host2.equals(domain2) || domain2.startsWith(".") && host2.endsWith(domain2);
    }
}

