/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePathComparator;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.apache.http.impl.cookie.RFC2109VersionHandler;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class RFC2109Spec
extends CookieSpecBase {
    private static final CookiePathComparator PATH_COMPARATOR = new CookiePathComparator();
    private static final String[] DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private final String[] datepatterns;
    private final boolean oneHeader;

    public RFC2109Spec(String[] datepatterns, boolean oneHeader) {
        this.datepatterns = datepatterns != null ? (String[])datepatterns.clone() : DATE_PATTERNS;
        this.oneHeader = oneHeader;
        this.registerAttribHandler("version", new RFC2109VersionHandler());
        this.registerAttribHandler("path", new BasicPathHandler());
        this.registerAttribHandler("domain", new RFC2109DomainHandler());
        this.registerAttribHandler("max-age", new BasicMaxAgeHandler());
        this.registerAttribHandler("secure", new BasicSecureHandler());
        this.registerAttribHandler("comment", new BasicCommentHandler());
        this.registerAttribHandler("expires", new BasicExpiresHandler(this.datepatterns));
    }

    public RFC2109Spec() {
        this(null, false);
    }

    @Override
    public List<Cookie> parse(Header header2, CookieOrigin origin) throws MalformedCookieException {
        if (header2 == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        if (!header2.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header2.toString() + "'");
        }
        HeaderElement[] elems = header2.getElements();
        return this.parse(elems, origin);
    }

    @Override
    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        String name2 = cookie2.getName();
        if (name2.indexOf(32) != -1) {
            throw new CookieRestrictionViolationException("Cookie name may not contain blanks");
        }
        if (name2.startsWith("$")) {
            throw new CookieRestrictionViolationException("Cookie name may not start with $");
        }
        super.validate(cookie2, origin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies2) {
        if (cookies2 == null) {
            throw new IllegalArgumentException("List of cookies may not be null");
        }
        if (cookies2.isEmpty()) {
            throw new IllegalArgumentException("List of cookies may not be empty");
        }
        if (cookies2.size() > 1) {
            cookies2 = new ArrayList<Cookie>(cookies2);
            Collections.sort(cookies2, PATH_COMPARATOR);
        }
        if (this.oneHeader) {
            return this.doFormatOneHeader(cookies2);
        }
        return this.doFormatManyHeaders(cookies2);
    }

    private List<Header> doFormatOneHeader(List<Cookie> cookies2) {
        int version2 = Integer.MAX_VALUE;
        for (Cookie cookie2 : cookies2) {
            if (cookie2.getVersion() >= version2) continue;
            version2 = cookie2.getVersion();
        }
        CharArrayBuffer buffer2 = new CharArrayBuffer(40 * cookies2.size());
        buffer2.append("Cookie");
        buffer2.append(": ");
        buffer2.append("$Version=");
        buffer2.append(Integer.toString(version2));
        for (Cookie cooky : cookies2) {
            buffer2.append("; ");
            Cookie cookie3 = cooky;
            this.formatCookieAsVer(buffer2, cookie3, version2);
        }
        ArrayList<Header> headers2 = new ArrayList<Header>(1);
        headers2.add(new BufferedHeader(buffer2));
        return headers2;
    }

    private List<Header> doFormatManyHeaders(List<Cookie> cookies2) {
        ArrayList<Header> headers2 = new ArrayList<Header>(cookies2.size());
        for (Cookie cookie2 : cookies2) {
            int version2 = cookie2.getVersion();
            CharArrayBuffer buffer2 = new CharArrayBuffer(40);
            buffer2.append("Cookie: ");
            buffer2.append("$Version=");
            buffer2.append(Integer.toString(version2));
            buffer2.append("; ");
            this.formatCookieAsVer(buffer2, cookie2, version2);
            headers2.add(new BufferedHeader(buffer2));
        }
        return headers2;
    }

    protected void formatParamAsVer(CharArrayBuffer buffer2, String name2, String value2, int version2) {
        buffer2.append(name2);
        buffer2.append("=");
        if (value2 != null) {
            if (version2 > 0) {
                buffer2.append('\"');
                buffer2.append(value2);
                buffer2.append('\"');
            } else {
                buffer2.append(value2);
            }
        }
    }

    protected void formatCookieAsVer(CharArrayBuffer buffer2, Cookie cookie2, int version2) {
        this.formatParamAsVer(buffer2, cookie2.getName(), cookie2.getValue(), version2);
        if (cookie2.getPath() != null && cookie2 instanceof ClientCookie && ((ClientCookie)cookie2).containsAttribute("path")) {
            buffer2.append("; ");
            this.formatParamAsVer(buffer2, "$Path", cookie2.getPath(), version2);
        }
        if (cookie2.getDomain() != null && cookie2 instanceof ClientCookie && ((ClientCookie)cookie2).containsAttribute("domain")) {
            buffer2.append("; ");
            this.formatParamAsVer(buffer2, "$Domain", cookie2.getDomain(), version2);
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "rfc2109";
    }
}

