/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;

@Immutable
public class RFC2965DomainAttributeHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie2, String domain2) throws MalformedCookieException {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (domain2 == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (domain2.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        if (!(domain2 = domain2.toLowerCase(Locale.ENGLISH)).startsWith(".")) {
            domain2 = '.' + domain2;
        }
        cookie2.setDomain(domain2);
    }

    public boolean domainMatch(String host2, String domain2) {
        boolean match = host2.equals(domain2) || domain2.startsWith(".") && host2.endsWith(domain2);
        return match;
    }

    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String host2 = origin.getHost().toLowerCase(Locale.ENGLISH);
        if (cookie2.getDomain() == null) {
            throw new CookieRestrictionViolationException("Invalid cookie state: domain not specified");
        }
        String cookieDomain = cookie2.getDomain().toLowerCase(Locale.ENGLISH);
        if (cookie2 instanceof ClientCookie && ((ClientCookie)cookie2).containsAttribute("domain")) {
            if (!cookieDomain.startsWith(".")) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie2.getDomain() + "\" violates RFC 2109: domain must start with a dot");
            }
            int dotIndex = cookieDomain.indexOf(46, 1);
            if (!(dotIndex >= 0 && dotIndex != cookieDomain.length() - 1 || cookieDomain.equals(".local"))) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie2.getDomain() + "\" violates RFC 2965: the value contains no embedded dots " + "and the value is not .local");
            }
            if (!this.domainMatch(host2, cookieDomain)) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie2.getDomain() + "\" violates RFC 2965: effective host name does not " + "domain-match domain attribute.");
            }
            String effectiveHostWithoutDomain = host2.substring(0, host2.length() - cookieDomain.length());
            if (effectiveHostWithoutDomain.indexOf(46) != -1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie2.getDomain() + "\" violates RFC 2965: " + "effective host minus domain may not contain any dots");
            }
        } else if (!cookie2.getDomain().equals(host2)) {
            throw new CookieRestrictionViolationException("Illegal domain attribute: \"" + cookie2.getDomain() + "\"." + "Domain of origin: \"" + host2 + "\"");
        }
    }

    public boolean match(Cookie cookie2, CookieOrigin origin) {
        String cookieDomain;
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String host2 = origin.getHost().toLowerCase(Locale.ENGLISH);
        if (!this.domainMatch(host2, cookieDomain = cookie2.getDomain())) {
            return false;
        }
        String effectiveHostWithoutDomain = host2.substring(0, host2.length() - cookieDomain.length());
        return effectiveHostWithoutDomain.indexOf(46) == -1;
    }
}

