/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.StringTokenizer;
import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.cookie.SetCookie2;

@Immutable
public class RFC2965PortAttributeHandler
implements CookieAttributeHandler {
    private static int[] parsePortAttribute(String portValue) throws MalformedCookieException {
        StringTokenizer st = new StringTokenizer(portValue, ",");
        int[] ports = new int[st.countTokens()];
        try {
            int i = 0;
            while (st.hasMoreTokens()) {
                ports[i] = Integer.parseInt(st.nextToken().trim());
                if (ports[i] < 0) {
                    throw new MalformedCookieException("Invalid Port attribute.");
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid Port attribute: " + e.getMessage());
        }
        return ports;
    }

    private static boolean portMatch(int port, int[] ports) {
        boolean portInList = false;
        int len2 = ports.length;
        for (int i = 0; i < len2; ++i) {
            if (port != ports[i]) continue;
            portInList = true;
            break;
        }
        return portInList;
    }

    public void parse(SetCookie cookie2, String portValue) throws MalformedCookieException {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookie2 instanceof SetCookie2) {
            SetCookie2 cookie22 = (SetCookie2)cookie2;
            if (portValue != null && portValue.trim().length() > 0) {
                int[] ports = RFC2965PortAttributeHandler.parsePortAttribute(portValue);
                cookie22.setPorts(ports);
            }
        }
    }

    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        int port = origin.getPort();
        if (cookie2 instanceof ClientCookie && ((ClientCookie)cookie2).containsAttribute("port") && !RFC2965PortAttributeHandler.portMatch(port, cookie2.getPorts())) {
            throw new CookieRestrictionViolationException("Port attribute violates RFC 2965: Request port not found in cookie's port list.");
        }
    }

    public boolean match(Cookie cookie2, CookieOrigin origin) {
        if (cookie2 == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        int port = origin.getPort();
        if (cookie2 instanceof ClientCookie && ((ClientCookie)cookie2).containsAttribute("port")) {
            if (cookie2.getPorts() == null) {
                return false;
            }
            if (!RFC2965PortAttributeHandler.portMatch(port, cookie2.getPorts())) {
                return false;
            }
        }
        return true;
    }
}

