/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.entity.ContentLengthStrategy;

public class StrictContentLengthStrategy
implements ContentLengthStrategy {
    public long determineLength(HttpMessage message) throws HttpException {
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (transferEncodingHeader != null) {
            String s2 = transferEncodingHeader.getValue();
            if ("chunked".equalsIgnoreCase(s2)) {
                if (message.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + message.getProtocolVersion());
                }
                return -2L;
            }
            if ("identity".equalsIgnoreCase(s2)) {
                return -1L;
            }
            throw new ProtocolException("Unsupported transfer encoding: " + s2);
        }
        if (contentLengthHeader != null) {
            String s3 = contentLengthHeader.getValue();
            try {
                long len2 = Long.parseLong(s3);
                if (len2 < 0L) {
                    throw new ProtocolException("Negative content length: " + s3);
                }
                return len2;
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid content length: " + s3);
            }
        }
        return -1L;
    }
}

