/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public abstract class AbstractMessageParser
implements HttpMessageParser {
    private static final int HEAD_LINE = 0;
    private static final int HEADERS = 1;
    private final SessionInputBuffer sessionBuffer;
    private final int maxHeaderCount;
    private final int maxLineLen;
    private final List headerLines;
    protected final LineParser lineParser;
    private int state;
    private HttpMessage message;

    public AbstractMessageParser(SessionInputBuffer buffer2, LineParser parser, HttpParams params2) {
        if (buffer2 == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sessionBuffer = buffer2;
        this.maxHeaderCount = params2.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLen = params2.getIntParameter("http.connection.max-line-length", -1);
        this.lineParser = parser != null ? parser : BasicLineParser.DEFAULT;
        this.headerLines = new ArrayList();
        this.state = 0;
    }

    public static Header[] parseHeaders(SessionInputBuffer inbuffer, int maxHeaderCount, int maxLineLen, LineParser parser) throws HttpException, IOException {
        if (parser == null) {
            parser = BasicLineParser.DEFAULT;
        }
        ArrayList headerLines = new ArrayList();
        return AbstractMessageParser.parseHeaders(inbuffer, maxHeaderCount, maxLineLen, parser, headerLines);
    }

    public static Header[] parseHeaders(SessionInputBuffer inbuffer, int maxHeaderCount, int maxLineLen, LineParser parser, List headerLines) throws HttpException, IOException {
        int i;
        block12: {
            if (inbuffer == null) {
                throw new IllegalArgumentException("Session input buffer may not be null");
            }
            if (parser == null) {
                throw new IllegalArgumentException("Line parser may not be null");
            }
            if (headerLines == null) {
                throw new IllegalArgumentException("Header line list may not be null");
            }
            CharArrayBuffer current2 = null;
            CharArrayBuffer previous = null;
            do {
                if (current2 == null) {
                    current2 = new CharArrayBuffer(64);
                } else {
                    current2.clear();
                }
                int l = inbuffer.readLine(current2);
                if (l == -1 || current2.length() < 1) break block12;
                if ((current2.charAt(0) == ' ' || current2.charAt(0) == '\t') && previous != null) {
                    char ch;
                    for (i = 0; i < current2.length() && ((ch = current2.charAt(i)) == ' ' || ch == '\t'); ++i) {
                    }
                    if (maxLineLen > 0 && previous.length() + 1 + current2.length() - i > maxLineLen) {
                        throw new IOException("Maximum line length limit exceeded");
                    }
                    previous.append(' ');
                    previous.append(current2, i, current2.length() - i);
                    continue;
                }
                headerLines.add(current2);
                previous = current2;
                current2 = null;
            } while (maxHeaderCount <= 0 || headerLines.size() < maxHeaderCount);
            throw new IOException("Maximum header count exceeded");
        }
        Header[] headers2 = new Header[headerLines.size()];
        for (i = 0; i < headerLines.size(); ++i) {
            CharArrayBuffer buffer2 = (CharArrayBuffer)headerLines.get(i);
            try {
                headers2[i] = parser.parseHeader(buffer2);
                continue;
            }
            catch (ParseException ex) {
                throw new ProtocolException(ex.getMessage());
            }
        }
        return headers2;
    }

    protected abstract HttpMessage parseHead(SessionInputBuffer var1) throws IOException, HttpException, ParseException;

    public HttpMessage parse() throws IOException, HttpException {
        int st = this.state;
        switch (st) {
            case 0: {
                try {
                    this.message = this.parseHead(this.sessionBuffer);
                }
                catch (ParseException px) {
                    throw new ProtocolException(px.getMessage(), px);
                }
                this.state = 1;
            }
            case 1: {
                Header[] headers2 = AbstractMessageParser.parseHeaders(this.sessionBuffer, this.maxHeaderCount, this.maxLineLen, this.lineParser, this.headerLines);
                this.message.setHeaders(headers2);
                HttpMessage result2 = this.message;
                this.message = null;
                this.headerLines.clear();
                this.state = 0;
                return result2;
            }
        }
        throw new IllegalStateException("Inconsistent parser state");
    }
}

