/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

public abstract class AbstractSessionOutputBuffer
implements SessionOutputBuffer,
BufferInfo {
    private static final byte[] CRLF = new byte[]{13, 10};
    private OutputStream outstream;
    private ByteArrayBuffer buffer;
    private String charset = "US-ASCII";
    private boolean ascii = true;
    private int minChunkLimit = 512;
    private HttpTransportMetricsImpl metrics;

    protected void init(OutputStream outstream, int buffersize, HttpParams params2) {
        if (outstream == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (buffersize <= 0) {
            throw new IllegalArgumentException("Buffer size may not be negative or zero");
        }
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.outstream = outstream;
        this.buffer = new ByteArrayBuffer(buffersize);
        this.charset = HttpProtocolParams.getHttpElementCharset(params2);
        this.ascii = this.charset.equalsIgnoreCase("US-ASCII") || this.charset.equalsIgnoreCase("ASCII");
        this.minChunkLimit = params2.getIntParameter("http.connection.min-chunk-limit", 512);
        this.metrics = this.createTransportMetrics();
    }

    protected HttpTransportMetricsImpl createTransportMetrics() {
        return new HttpTransportMetricsImpl();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int length() {
        return this.buffer.length();
    }

    public int available() {
        return this.capacity() - this.length();
    }

    protected void flushBuffer() throws IOException {
        int len2 = this.buffer.length();
        if (len2 > 0) {
            this.outstream.write(this.buffer.buffer(), 0, len2);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred(len2);
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.outstream.flush();
    }

    public void write(byte[] b, int off, int len2) throws IOException {
        if (b == null) {
            return;
        }
        if (len2 > this.minChunkLimit || len2 > this.buffer.capacity()) {
            this.flushBuffer();
            this.outstream.write(b, off, len2);
            this.metrics.incrementBytesTransferred(len2);
        } else {
            int freecapacity = this.buffer.capacity() - this.buffer.length();
            if (len2 > freecapacity) {
                this.flushBuffer();
            }
            this.buffer.append(b, off, len2);
        }
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        if (this.buffer.isFull()) {
            this.flushBuffer();
        }
        this.buffer.append(b);
    }

    public void writeLine(String s2) throws IOException {
        if (s2 == null) {
            return;
        }
        if (s2.length() > 0) {
            this.write(s2.getBytes(this.charset));
        }
        this.write(CRLF);
    }

    public void writeLine(CharArrayBuffer s2) throws IOException {
        if (s2 == null) {
            return;
        }
        if (this.ascii) {
            int chunk;
            int off = 0;
            for (int remaining = s2.length(); remaining > 0; remaining -= chunk) {
                chunk = this.buffer.capacity() - this.buffer.length();
                if ((chunk = Math.min(chunk, remaining)) > 0) {
                    this.buffer.append(s2, off, chunk);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                off += chunk;
            }
        } else {
            byte[] tmp = s2.toString().getBytes(this.charset);
            this.write(tmp);
        }
        this.write(CRLF);
    }

    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

