/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpMessage;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public abstract class AbstractHttpMessage
implements HttpMessage {
    protected HeaderGroup headergroup = new HeaderGroup();
    protected HttpParams params;

    protected AbstractHttpMessage(HttpParams params2) {
        this.params = params2;
    }

    protected AbstractHttpMessage() {
        this(null);
    }

    public boolean containsHeader(String name2) {
        return this.headergroup.containsHeader(name2);
    }

    public Header[] getHeaders(String name2) {
        return this.headergroup.getHeaders(name2);
    }

    public Header getFirstHeader(String name2) {
        return this.headergroup.getFirstHeader(name2);
    }

    public Header getLastHeader(String name2) {
        return this.headergroup.getLastHeader(name2);
    }

    public Header[] getAllHeaders() {
        return this.headergroup.getAllHeaders();
    }

    public void addHeader(Header header2) {
        this.headergroup.addHeader(header2);
    }

    public void addHeader(String name2, String value2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Header name may not be null");
        }
        this.headergroup.addHeader(new BasicHeader(name2, value2));
    }

    public void setHeader(Header header2) {
        this.headergroup.updateHeader(header2);
    }

    public void setHeader(String name2, String value2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Header name may not be null");
        }
        this.headergroup.updateHeader(new BasicHeader(name2, value2));
    }

    public void setHeaders(Header[] headers2) {
        this.headergroup.setHeaders(headers2);
    }

    public void removeHeader(Header header2) {
        this.headergroup.removeHeader(header2);
    }

    public void removeHeaders(String name2) {
        if (name2 == null) {
            return;
        }
        HeaderIterator i = this.headergroup.iterator();
        while (i.hasNext()) {
            Header header2 = (Header)i.next();
            if (!name2.equalsIgnoreCase(header2.getName())) continue;
            i.remove();
        }
    }

    public HeaderIterator headerIterator() {
        return this.headergroup.iterator();
    }

    public HeaderIterator headerIterator(String name2) {
        return this.headergroup.iterator(name2);
    }

    public HttpParams getParams() {
        if (this.params == null) {
            this.params = new BasicHttpParams();
        }
        return this.params;
    }

    public void setParams(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.params = params2;
    }
}

