/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.HeaderValueFormatter;
import org.apache.http.util.CharArrayBuffer;

public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();
    public static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    public static final String UNSAFE_CHARS = "\"\\";

    public static final String formatElements(HeaderElement[] elems, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatElements(null, elems, quote).toString();
    }

    public CharArrayBuffer formatElements(CharArrayBuffer buffer2, HeaderElement[] elems, boolean quote) {
        if (elems == null) {
            throw new IllegalArgumentException("Header element array must not be null.");
        }
        int len2 = this.estimateElementsLen(elems);
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len2);
        } else {
            buffer2.ensureCapacity(len2);
        }
        for (int i = 0; i < elems.length; ++i) {
            if (i > 0) {
                buffer2.append(", ");
            }
            this.formatHeaderElement(buffer2, elems[i], quote);
        }
        return buffer2;
    }

    protected int estimateElementsLen(HeaderElement[] elems) {
        if (elems == null || elems.length < 1) {
            return 0;
        }
        int result2 = (elems.length - 1) * 2;
        for (int i = 0; i < elems.length; ++i) {
            result2 += this.estimateHeaderElementLen(elems[i]);
        }
        return result2;
    }

    public static final String formatHeaderElement(HeaderElement elem2, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatHeaderElement(null, elem2, quote).toString();
    }

    public CharArrayBuffer formatHeaderElement(CharArrayBuffer buffer2, HeaderElement elem2, boolean quote) {
        int parcnt;
        if (elem2 == null) {
            throw new IllegalArgumentException("Header element must not be null.");
        }
        int len2 = this.estimateHeaderElementLen(elem2);
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len2);
        } else {
            buffer2.ensureCapacity(len2);
        }
        buffer2.append(elem2.getName());
        String value2 = elem2.getValue();
        if (value2 != null) {
            buffer2.append('=');
            this.doFormatValue(buffer2, value2, quote);
        }
        if ((parcnt = elem2.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                buffer2.append("; ");
                this.formatNameValuePair(buffer2, elem2.getParameter(i), quote);
            }
        }
        return buffer2;
    }

    protected int estimateHeaderElementLen(HeaderElement elem2) {
        int parcnt;
        if (elem2 == null) {
            return 0;
        }
        int result2 = elem2.getName().length();
        String value2 = elem2.getValue();
        if (value2 != null) {
            result2 += 3 + value2.length();
        }
        if ((parcnt = elem2.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                result2 += 2 + this.estimateNameValuePairLen(elem2.getParameter(i));
            }
        }
        return result2;
    }

    public static final String formatParameters(NameValuePair[] nvps, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatParameters(null, nvps, quote).toString();
    }

    public CharArrayBuffer formatParameters(CharArrayBuffer buffer2, NameValuePair[] nvps, boolean quote) {
        if (nvps == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        int len2 = this.estimateParametersLen(nvps);
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len2);
        } else {
            buffer2.ensureCapacity(len2);
        }
        for (int i = 0; i < nvps.length; ++i) {
            if (i > 0) {
                buffer2.append("; ");
            }
            this.formatNameValuePair(buffer2, nvps[i], quote);
        }
        return buffer2;
    }

    protected int estimateParametersLen(NameValuePair[] nvps) {
        if (nvps == null || nvps.length < 1) {
            return 0;
        }
        int result2 = (nvps.length - 1) * 2;
        for (int i = 0; i < nvps.length; ++i) {
            result2 += this.estimateNameValuePairLen(nvps[i]);
        }
        return result2;
    }

    public static final String formatNameValuePair(NameValuePair nvp, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatNameValuePair(null, nvp, quote).toString();
    }

    public CharArrayBuffer formatNameValuePair(CharArrayBuffer buffer2, NameValuePair nvp, boolean quote) {
        if (nvp == null) {
            throw new IllegalArgumentException("NameValuePair must not be null.");
        }
        int len2 = this.estimateNameValuePairLen(nvp);
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len2);
        } else {
            buffer2.ensureCapacity(len2);
        }
        buffer2.append(nvp.getName());
        String value2 = nvp.getValue();
        if (value2 != null) {
            buffer2.append('=');
            this.doFormatValue(buffer2, value2, quote);
        }
        return buffer2;
    }

    protected int estimateNameValuePairLen(NameValuePair nvp) {
        if (nvp == null) {
            return 0;
        }
        int result2 = nvp.getName().length();
        String value2 = nvp.getValue();
        if (value2 != null) {
            result2 += 3 + value2.length();
        }
        return result2;
    }

    protected void doFormatValue(CharArrayBuffer buffer2, String value2, boolean quote) {
        int i;
        if (!quote) {
            for (i = 0; i < value2.length() && !quote; ++i) {
                quote = this.isSeparator(value2.charAt(i));
            }
        }
        if (quote) {
            buffer2.append('\"');
        }
        for (i = 0; i < value2.length(); ++i) {
            char ch = value2.charAt(i);
            if (this.isUnsafe(ch)) {
                buffer2.append('\\');
            }
            buffer2.append(ch);
        }
        if (quote) {
            buffer2.append('\"');
        }
    }

    protected boolean isSeparator(char ch) {
        return SEPARATORS.indexOf(ch) >= 0;
    }

    protected boolean isUnsafe(char ch) {
        return UNSAFE_CHARS.indexOf(ch) >= 0;
    }
}

