/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.HeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

public class BasicHeaderValueParser
implements HeaderValueParser {
    public static final BasicHeaderValueParser DEFAULT = new BasicHeaderValueParser();
    private static final char PARAM_DELIMITER = ';';
    private static final char ELEM_DELIMITER = ',';
    private static final char[] ALL_DELIMITERS = new char[]{';', ','};

    public static final HeaderElement[] parseElements(String value2, HeaderValueParser parser) throws ParseException {
        if (value2 == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer2 = new CharArrayBuffer(value2.length());
        buffer2.append(value2);
        ParserCursor cursor = new ParserCursor(0, value2.length());
        return parser.parseElements(buffer2, cursor);
    }

    public HeaderElement[] parseElements(CharArrayBuffer buffer2, ParserCursor cursor) {
        if (buffer2 == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        ArrayList<HeaderElement> elements = new ArrayList<HeaderElement>();
        while (!cursor.atEnd()) {
            HeaderElement element = this.parseHeaderElement(buffer2, cursor);
            if (element.getName().length() == 0 && element.getValue() == null) continue;
            elements.add(element);
        }
        return elements.toArray(new HeaderElement[elements.size()]);
    }

    public static final HeaderElement parseHeaderElement(String value2, HeaderValueParser parser) throws ParseException {
        if (value2 == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer2 = new CharArrayBuffer(value2.length());
        buffer2.append(value2);
        ParserCursor cursor = new ParserCursor(0, value2.length());
        return parser.parseHeaderElement(buffer2, cursor);
    }

    public HeaderElement parseHeaderElement(CharArrayBuffer buffer2, ParserCursor cursor) {
        char ch;
        if (buffer2 == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        NameValuePair nvp = this.parseNameValuePair(buffer2, cursor);
        NameValuePair[] params2 = null;
        if (!cursor.atEnd() && (ch = buffer2.charAt(cursor.getPos() - 1)) != ',') {
            params2 = this.parseParameters(buffer2, cursor);
        }
        return this.createHeaderElement(nvp.getName(), nvp.getValue(), params2);
    }

    protected HeaderElement createHeaderElement(String name2, String value2, NameValuePair[] params2) {
        return new BasicHeaderElement(name2, value2, params2);
    }

    public static final NameValuePair[] parseParameters(String value2, HeaderValueParser parser) throws ParseException {
        if (value2 == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer2 = new CharArrayBuffer(value2.length());
        buffer2.append(value2);
        ParserCursor cursor = new ParserCursor(0, value2.length());
        return parser.parseParameters(buffer2, cursor);
    }

    public NameValuePair[] parseParameters(CharArrayBuffer buffer2, ParserCursor cursor) {
        char ch;
        int pos;
        if (buffer2 == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        int indexTo = cursor.getUpperBound();
        for (pos = cursor.getPos(); pos < indexTo && HTTP.isWhitespace(ch = buffer2.charAt(pos)); ++pos) {
        }
        cursor.updatePos(pos);
        if (cursor.atEnd()) {
            return new NameValuePair[0];
        }
        ArrayList<NameValuePair> params2 = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair param2 = this.parseNameValuePair(buffer2, cursor);
            params2.add(param2);
            char ch2 = buffer2.charAt(cursor.getPos() - 1);
            if (ch2 != ',') continue;
            break;
        }
        return params2.toArray(new NameValuePair[params2.size()]);
    }

    public static final NameValuePair parseNameValuePair(String value2, HeaderValueParser parser) throws ParseException {
        if (value2 == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (parser == null) {
            parser = DEFAULT;
        }
        CharArrayBuffer buffer2 = new CharArrayBuffer(value2.length());
        buffer2.append(value2);
        ParserCursor cursor = new ParserCursor(0, value2.length());
        return parser.parseNameValuePair(buffer2, cursor);
    }

    public NameValuePair parseNameValuePair(CharArrayBuffer buffer2, ParserCursor cursor) {
        return this.parseNameValuePair(buffer2, cursor, ALL_DELIMITERS);
    }

    private static boolean isOneOf(char ch, char[] chs) {
        if (chs != null) {
            for (int i = 0; i < chs.length; ++i) {
                if (ch != chs[i]) continue;
                return true;
            }
        }
        return false;
    }

    public NameValuePair parseNameValuePair(CharArrayBuffer buffer2, ParserCursor cursor, char[] delimiters) {
        char ch;
        int pos;
        if (buffer2 == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        boolean terminated = false;
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        String name2 = null;
        for (pos = cursor.getPos(); pos < indexTo && (ch = buffer2.charAt(pos)) != '='; ++pos) {
            if (!BasicHeaderValueParser.isOneOf(ch, delimiters)) continue;
            terminated = true;
            break;
        }
        if (pos == indexTo) {
            terminated = true;
            name2 = buffer2.substringTrimmed(indexFrom, indexTo);
        } else {
            name2 = buffer2.substringTrimmed(indexFrom, pos);
            ++pos;
        }
        if (terminated) {
            cursor.updatePos(pos);
            return this.createNameValuePair(name2, null);
        }
        String value2 = null;
        int i1 = pos;
        boolean qouted = false;
        boolean escaped2 = false;
        while (pos < indexTo) {
            char ch2 = buffer2.charAt(pos);
            if (ch2 == '\"' && !escaped2) {
                boolean bl = qouted = !qouted;
            }
            if (!qouted && !escaped2 && BasicHeaderValueParser.isOneOf(ch2, delimiters)) {
                terminated = true;
                break;
            }
            escaped2 = escaped2 ? false : qouted && ch2 == '\\';
            ++pos;
        }
        int i2 = pos;
        while (i1 < i2 && HTTP.isWhitespace(buffer2.charAt(i1))) {
            ++i1;
        }
        while (i2 > i1 && HTTP.isWhitespace(buffer2.charAt(i2 - 1))) {
            --i2;
        }
        if (i2 - i1 >= 2 && buffer2.charAt(i1) == '\"' && buffer2.charAt(i2 - 1) == '\"') {
            ++i1;
            --i2;
        }
        value2 = buffer2.substring(i1, i2);
        if (terminated) {
            ++pos;
        }
        cursor.updatePos(pos);
        return this.createNameValuePair(name2, value2);
    }

    protected NameValuePair createNameValuePair(String name2, String value2) {
        return new BasicNameValuePair(name2, value2);
    }
}

