/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;

public class BasicListHeaderIterator
implements HeaderIterator {
    protected final List allHeaders;
    protected int currentIndex;
    protected int lastIndex;
    protected String headerName;

    public BasicListHeaderIterator(List headers2, String name2) {
        if (headers2 == null) {
            throw new IllegalArgumentException("Header list must not be null.");
        }
        this.allHeaders = headers2;
        this.headerName = name2;
        this.currentIndex = this.findNext(-1);
        this.lastIndex = -1;
    }

    protected int findNext(int from2) {
        if (from2 < -1) {
            return -1;
        }
        int to2 = this.allHeaders.size() - 1;
        boolean found = false;
        while (!found && from2 < to2) {
            found = this.filterHeader(++from2);
        }
        return found ? from2 : -1;
    }

    protected boolean filterHeader(int index2) {
        if (this.headerName == null) {
            return true;
        }
        String name2 = ((Header)this.allHeaders.get(index2)).getName();
        return this.headerName.equalsIgnoreCase(name2);
    }

    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    public Header nextHeader() throws NoSuchElementException {
        int current2 = this.currentIndex;
        if (current2 < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.lastIndex = current2;
        this.currentIndex = this.findNext(current2);
        return (Header)this.allHeaders.get(current2);
    }

    public final Object next() throws NoSuchElementException {
        return this.nextHeader();
    }

    public void remove() throws UnsupportedOperationException {
        if (this.lastIndex < 0) {
            throw new IllegalStateException("No header to remove.");
        }
        this.allHeaders.remove(this.lastIndex);
        this.lastIndex = -1;
        --this.currentIndex;
    }
}

