/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.params.CoreProtocolPNames;
import org.apache.http.params.HttpParams;

public final class HttpProtocolParams
implements CoreProtocolPNames {
    private HttpProtocolParams() {
    }

    public static String getHttpElementCharset(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        String charset2 = (String)params2.getParameter("http.protocol.element-charset");
        if (charset2 == null) {
            charset2 = "US-ASCII";
        }
        return charset2;
    }

    public static void setHttpElementCharset(HttpParams params2, String charset2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setParameter("http.protocol.element-charset", charset2);
    }

    public static String getContentCharset(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        String charset2 = (String)params2.getParameter("http.protocol.content-charset");
        if (charset2 == null) {
            charset2 = "ISO-8859-1";
        }
        return charset2;
    }

    public static void setContentCharset(HttpParams params2, String charset2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setParameter("http.protocol.content-charset", charset2);
    }

    public static ProtocolVersion getVersion(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        Object param2 = params2.getParameter("http.protocol.version");
        if (param2 == null) {
            return HttpVersion.HTTP_1_1;
        }
        return (ProtocolVersion)param2;
    }

    public static void setVersion(HttpParams params2, ProtocolVersion version2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setParameter("http.protocol.version", version2);
    }

    public static String getUserAgent(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return (String)params2.getParameter("http.useragent");
    }

    public static void setUserAgent(HttpParams params2, String useragent) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setParameter("http.useragent", useragent);
    }

    public static boolean useExpectContinue(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params2.getBooleanParameter("http.protocol.expect-continue", false);
    }

    public static void setUseExpectContinue(HttpParams params2, boolean b) {
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params2.setBooleanParameter("http.protocol.expect-continue", b);
    }
}

