/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.UnsupportedEncodingException;

public final class EncodingUtils {
    public static String getString(byte[] data, int offset, int length, String charset2) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (charset2 == null || charset2.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return new String(data, offset, length, charset2);
        }
        catch (UnsupportedEncodingException e) {
            return new String(data, offset, length);
        }
    }

    public static String getString(byte[] data, String charset2) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return EncodingUtils.getString(data, 0, data.length, charset2);
    }

    public static byte[] getBytes(String data, String charset2) {
        if (data == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (charset2 == null || charset2.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return data.getBytes(charset2);
        }
        catch (UnsupportedEncodingException e) {
            return data.getBytes();
        }
    }

    public static byte[] getAsciiBytes(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return data.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data, int offset, int length) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(data, offset, length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return EncodingUtils.getAsciiString(data, 0, data.length);
    }

    private EncodingUtils() {
    }
}

