/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private WorkingTreeIterator workingTreeIterator;
    private boolean update = false;

    public AddCommand(Repository repo) {
        super(repo);
    }

    public AddCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public AddCommand setWorkingTreeIterator(WorkingTreeIterator f2) {
        this.workingTreeIterator = f2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirCache call() throws GitAPIException, NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        boolean addAll = false;
        if (this.filepatterns.contains(".")) {
            addAll = true;
        }
        ObjectInserter inserter = this.repo.newObjectInserter();
        try {
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            TreeWalk tw = new TreeWalk(this.repo);
            tw.addTree(new DirCacheBuildIterator(builder));
            if (this.workingTreeIterator == null) {
                this.workingTreeIterator = new FileTreeIterator(this.repo);
            }
            tw.addTree(this.workingTreeIterator);
            tw.setRecursive(true);
            if (!addAll) {
                tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            }
            String lastAddedFile = null;
            while (tw.next()) {
                String path2 = tw.getPathString();
                WorkingTreeIterator f2 = tw.getTree(1, WorkingTreeIterator.class);
                if (tw.getTree(0, DirCacheIterator.class) == null && f2 != null && f2.isEntryIgnored() || path2.equals(lastAddedFile) || this.update && tw.getTree(0, DirCacheIterator.class) == null) continue;
                DirCacheIterator c = tw.getTree(0, DirCacheIterator.class);
                if (f2 != null) {
                    long sz = f2.getEntryLength();
                    DirCacheEntry entry = new DirCacheEntry(path2);
                    if (c == null || c.getDirCacheEntry() == null || !c.getDirCacheEntry().isAssumeValid()) {
                        FileMode mode = f2.getIndexFileMode(c);
                        entry.setFileMode(mode);
                        if (FileMode.GITLINK != mode) {
                            entry.setLength(sz);
                            entry.setLastModified(f2.getEntryLastModified());
                            long contentSize = f2.getEntryContentLength();
                            InputStream in = f2.openEntryStream();
                            try {
                                entry.setObjectId(inserter.insert(3, contentSize, in));
                            }
                            finally {
                                in.close();
                            }
                        } else {
                            entry.setObjectId(f2.getEntryObjectId());
                        }
                        builder.add(entry);
                        lastAddedFile = path2;
                        continue;
                    }
                    builder.add(c.getDirCacheEntry());
                    continue;
                }
                if (c == null || this.update && FileMode.GITLINK != c.getEntryFileMode()) continue;
                builder.add(c.getDirCacheEntry());
            }
            inserter.flush();
            builder.commit();
            this.setCallable(false);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfAddCommand, e);
        }
        finally {
            inserter.release();
            if (dc != null) {
                dc.unlock();
            }
        }
        return dc;
    }

    public AddCommand setUpdate(boolean update2) {
        this.update = update2;
        return this;
    }

    public boolean isUpdate() {
        return this.update;
    }
}

