/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.StashApplyFailureException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StashApplyCommand
extends GitCommand<ObjectId> {
    private static final String DEFAULT_REF = "stash@{0}";
    private String stashRef;
    private boolean applyIndex = true;
    private boolean applyUntracked = true;
    private boolean ignoreRepositoryState;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;

    public StashApplyCommand(Repository repo) {
        super(repo);
    }

    public StashApplyCommand setStashRef(String stashRef) {
        this.stashRef = stashRef;
        return this;
    }

    public StashApplyCommand ignoreRepositoryState(boolean willIgnoreRepositoryState) {
        this.ignoreRepositoryState = willIgnoreRepositoryState;
        return this;
    }

    private ObjectId getStashId() throws GitAPIException {
        ObjectId stashId;
        String revision = this.stashRef != null ? this.stashRef : DEFAULT_REF;
        try {
            stashId = this.repo.resolve(revision);
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision), e);
        }
        if (stashId == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision));
        }
        return stashId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ObjectId call() throws GitAPIException, WrongRepositoryStateException, NoHeadException, StashApplyFailureException {
        this.checkCallable();
        if (!this.ignoreRepositoryState && this.repo.getRepositoryState() != RepositoryState.SAFE) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().stashApplyOnUnsafeRepository, new Object[]{this.repo.getRepositoryState()}));
        }
        ObjectReader reader = this.repo.newObjectReader();
        try {
            boolean ok;
            RevWalk revWalk = new RevWalk(reader);
            ObjectId headCommit = this.repo.resolve("HEAD");
            if (headCommit == null) {
                throw new NoHeadException(JGitText.get().stashApplyWithoutHead);
            }
            ObjectId stashId = this.getStashId();
            RevCommit stashCommit = revWalk.parseCommit(stashId);
            if (stashCommit.getParentCount() < 2 || stashCommit.getParentCount() > 3) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().stashCommitIncorrectNumberOfParents, stashId.name(), stashCommit.getParentCount()));
            }
            ObjectId headTree = this.repo.resolve("HEAD^{tree}");
            RevCommit stashIndexCommit = revWalk.parseCommit(stashCommit.getParent(1));
            RevCommit stashHeadCommit = stashCommit.getParent(0);
            RevCommit untrackedCommit = null;
            if (this.applyUntracked && stashCommit.getParentCount() == 3) {
                untrackedCommit = revWalk.parseCommit(stashCommit.getParent(2));
            }
            ResolveMerger merger = (ResolveMerger)this.strategy.newMerger(this.repo);
            merger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "stash"});
            merger.setBase(stashHeadCommit);
            merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
            if (!merger.merge(headCommit, stashCommit)) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
            DirCache dc = this.repo.lockDirCache();
            DirCacheCheckout dco = new DirCacheCheckout(this.repo, headTree, dc, merger.getResultTreeId());
            dco.setFailOnConflict(true);
            dco.checkout();
            if (this.applyIndex) {
                ResolveMerger ixMerger = (ResolveMerger)this.strategy.newMerger(this.repo, true);
                ixMerger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "stashed index"});
                ixMerger.setBase(stashHeadCommit);
                ok = ixMerger.merge(headCommit, stashIndexCommit);
                if (!ok) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                this.resetIndex(revWalk.parseTree(ixMerger.getResultTreeId()));
            }
            if (untrackedCommit != null) {
                ResolveMerger untrackedMerger = (ResolveMerger)this.strategy.newMerger(this.repo, true);
                untrackedMerger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "untracked files"});
                untrackedMerger.setBase(stashHeadCommit);
                ok = untrackedMerger.merge(headCommit, untrackedCommit);
                if (!ok) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                try {
                    RevTree untrackedTree = revWalk.parseTree(untrackedMerger.getResultTreeId());
                    this.resetUntracked(untrackedTree);
                }
                catch (CheckoutConflictException e) {
                    throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                }
            }
            ObjectId objectId = stashId;
            return objectId;
        }
        catch (JGitInternalException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashApplyFailed, e);
        }
        finally {
            reader.release();
        }
    }

    public void setApplyIndex(boolean applyIndex) {
        this.applyIndex = applyIndex;
    }

    public StashApplyCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public void setApplyUntracked(boolean applyUntracked) {
        this.applyUntracked = applyUntracked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIndex(RevTree tree) throws IOException {
        DirCache dc = this.repo.lockDirCache();
        TreeWalk walk2 = null;
        try {
            DirCacheBuilder builder = dc.builder();
            walk2 = new TreeWalk(this.repo);
            walk2.addTree(tree);
            walk2.addTree(new DirCacheIterator(dc));
            walk2.setRecursive(true);
            while (walk2.next()) {
                AbstractTreeIterator cIter = walk2.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                DirCacheEntry entry = new DirCacheEntry(walk2.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                DirCacheIterator dcIter = walk2.getTree(1, DirCacheIterator.class);
                if (dcIter != null && dcIter.idEqual(cIter)) {
                    DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
                    entry.setLastModified(indexEntry.getLastModified());
                    entry.setLength(indexEntry.getLength());
                }
                builder.add(entry);
            }
            builder.commit();
        }
        finally {
            dc.unlock();
            if (walk2 != null) {
                walk2.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUntracked(RevTree tree) throws CheckoutConflictException, IOException {
        TreeWalk walk2 = new TreeWalk(this.repo);
        try {
            walk2.addTree(tree);
            walk2.addTree(new FileTreeIterator(this.repo));
            walk2.setRecursive(true);
            ObjectReader reader = walk2.getObjectReader();
            while (walk2.next()) {
                AbstractTreeIterator cIter = walk2.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                DirCacheEntry entry = new DirCacheEntry(walk2.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                FileTreeIterator fIter = walk2.getTree(1, FileTreeIterator.class);
                if (fIter != null && fIter.isModified(entry, true, reader)) {
                    throw new CheckoutConflictException(entry.getPathString());
                }
                this.checkoutPath(entry, reader);
            }
        }
        finally {
            walk2.release();
        }
    }

    private void checkoutPath(DirCacheEntry entry, ObjectReader reader) {
        try {
            DirCacheCheckout.checkoutEntry(this.repo, entry, reader);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, entry.getPathString()), e);
        }
    }
}

