/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCommand
extends GitCommand<Status> {
    private WorkingTreeIterator workingTreeIt;
    private List<String> paths = null;
    private ProgressMonitor progressMonitor = null;
    private SubmoduleWalk.IgnoreSubmoduleMode ignoreSubmoduleMode = null;

    protected StatusCommand(Repository repo) {
        super(repo);
    }

    public StatusCommand setIgnoreSubmodules(SubmoduleWalk.IgnoreSubmoduleMode mode) {
        this.ignoreSubmoduleMode = mode;
        return this;
    }

    public StatusCommand addPath(String path2) {
        if (this.paths == null) {
            this.paths = new LinkedList<String>();
        }
        this.paths.add(path2);
        return this;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public Status call() throws GitAPIException, NoWorkTreeException {
        if (this.workingTreeIt == null) {
            this.workingTreeIt = new FileTreeIterator(this.repo);
        }
        try {
            IndexDiff diff2 = new IndexDiff(this.repo, "HEAD", this.workingTreeIt);
            if (this.ignoreSubmoduleMode != null) {
                diff2.setIgnoreSubmoduleMode(this.ignoreSubmoduleMode);
            }
            if (this.paths != null) {
                diff2.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            if (this.progressMonitor == null) {
                diff2.diff();
            } else {
                diff2.diff(this.progressMonitor, 0, 0, "");
            }
            return new Status(diff2);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public StatusCommand setWorkingTreeIt(WorkingTreeIterator workingTreeIt) {
        this.workingTreeIt = workingTreeIt;
        return this;
    }

    public StatusCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        return this;
    }
}

