/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleAddCommand
extends TransportCommand<SubmoduleAddCommand, Repository> {
    private String path;
    private String uri;
    private ProgressMonitor monitor;

    public SubmoduleAddCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleAddCommand setPath(String path2) {
        this.path = path2;
        return this;
    }

    public SubmoduleAddCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public SubmoduleAddCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    protected boolean submoduleExists() throws IOException {
        PathFilter filter2 = PathFilter.create(this.path);
        return SubmoduleWalk.forIndex(this.repo).setFilter(filter2).next();
    }

    @Override
    public Repository call() throws GitAPIException {
        String resolvedUri;
        this.checkCallable();
        if (this.path == null || this.path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
        }
        try {
            if (this.submoduleExists()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().submoduleExists, this.path));
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        try {
            resolvedUri = SubmoduleWalk.getSubmoduleRemoteUrl(this.repo, this.uri);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        File moduleDirectory = SubmoduleWalk.getSubmoduleDirectory(this.repo, this.path);
        CloneCommand clone2 = Git.cloneRepository();
        this.configure(clone2);
        clone2.setDirectory(moduleDirectory);
        clone2.setURI(resolvedUri);
        if (this.monitor != null) {
            clone2.setProgressMonitor(this.monitor);
        }
        Repository subRepo = clone2.call().getRepository();
        StoredConfig config2 = this.repo.getConfig();
        config2.setString("submodule", this.path, "url", resolvedUri);
        try {
            config2.save();
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        FileBasedConfig modulesConfig = new FileBasedConfig(new File(this.repo.getWorkTree(), ".gitmodules"), this.repo.getFS());
        try {
            modulesConfig.load();
            modulesConfig.setString("submodule", this.path, "path", this.path);
            modulesConfig.setString("submodule", this.path, "url", this.uri);
            modulesConfig.save();
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        AddCommand add2 = new AddCommand(this.repo);
        add2.addFilepattern(".gitmodules");
        add2.addFilepattern(this.path);
        try {
            add2.call();
        }
        catch (NoFilepatternException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return subRepo;
    }
}

