/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleInitCommand
extends GitCommand<Collection<String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleInitCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleInitCommand addPath(String path2) {
        this.paths.add(path2);
        return this;
    }

    @Override
    public Collection<String> call() throws GitAPIException {
        this.checkCallable();
        try {
            SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            StoredConfig config2 = this.repo.getConfig();
            ArrayList<String> initialized = new ArrayList<String>();
            while (generator.next()) {
                if (generator.getConfigUrl() != null) continue;
                String path2 = generator.getPath();
                String url = generator.getRemoteUrl();
                String update2 = generator.getModulesUpdate();
                if (url != null) {
                    config2.setString("submodule", path2, "url", url);
                }
                if (update2 != null) {
                    config2.setString("submodule", path2, "update", update2);
                }
                if (url == null && update2 == null) continue;
                initialized.add(path2);
            }
            if (!initialized.isEmpty()) {
                config2.save();
            }
            return initialized;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

