/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import java.io.IOException;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public class BlameResult {
    private final String resultPath;
    private final RevCommit[] sourceCommits;
    private final PersonIdent[] sourceAuthors;
    private final PersonIdent[] sourceCommitters;
    private final String[] sourcePaths;
    private final int[] sourceLines;
    private RawText resultContents;
    private BlameGenerator generator;
    private int lastLength;

    public static BlameResult create(BlameGenerator gen) throws IOException {
        String path2 = gen.getResultPath();
        RawText contents2 = gen.getResultContents();
        if (contents2 == null) {
            gen.release();
            return null;
        }
        return new BlameResult(gen, path2, contents2);
    }

    BlameResult(BlameGenerator bg, String path2, RawText text2) {
        this.generator = bg;
        this.resultPath = path2;
        this.resultContents = text2;
        int cnt = text2.size();
        this.sourceCommits = new RevCommit[cnt];
        this.sourceAuthors = new PersonIdent[cnt];
        this.sourceCommitters = new PersonIdent[cnt];
        this.sourceLines = new int[cnt];
        this.sourcePaths = new String[cnt];
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public RawText getResultContents() {
        return this.resultContents;
    }

    public void discardResultContents() {
        this.resultContents = null;
    }

    public boolean hasSourceData(int idx) {
        return this.sourceLines[idx] != 0;
    }

    public boolean hasSourceData(int start2, int end2) {
        while (start2 < end2) {
            if (this.sourceLines[start2] == 0) {
                return false;
            }
            ++start2;
        }
        return true;
    }

    public RevCommit getSourceCommit(int idx) {
        return this.sourceCommits[idx];
    }

    public PersonIdent getSourceAuthor(int idx) {
        return this.sourceAuthors[idx];
    }

    public PersonIdent getSourceCommitter(int idx) {
        return this.sourceCommitters[idx];
    }

    public String getSourcePath(int idx) {
        return this.sourcePaths[idx];
    }

    public int getSourceLine(int idx) {
        return this.sourceLines[idx] - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeAll() throws IOException {
        BlameGenerator gen = this.generator;
        if (gen == null) {
            return;
        }
        try {
            while (gen.next()) {
                this.loadFrom(gen);
            }
        }
        finally {
            gen.release();
            this.generator = null;
        }
    }

    public int computeNext() throws IOException {
        BlameGenerator gen = this.generator;
        if (gen == null) {
            return -1;
        }
        if (gen.next()) {
            this.loadFrom(gen);
            this.lastLength = gen.getRegionLength();
            return gen.getResultStart();
        }
        gen.release();
        this.generator = null;
        return -1;
    }

    public int lastLength() {
        return this.lastLength;
    }

    public void computeRange(int start2, int end2) throws IOException {
        BlameGenerator gen = this.generator;
        if (gen == null) {
            return;
        }
        if (start2 == 0 && end2 == this.resultContents.size()) {
            this.computeAll();
            return;
        }
        while (start2 < end2) {
            if (this.hasSourceData(start2, end2)) {
                return;
            }
            if (!gen.next()) {
                gen.release();
                this.generator = null;
                return;
            }
            this.loadFrom(gen);
            int resLine = gen.getResultStart();
            int resEnd = gen.getResultEnd();
            if (resLine <= start2 && start2 < resEnd) {
                start2 = resEnd;
            }
            if (resLine > end2 || end2 >= resEnd) continue;
            end2 = resLine;
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("BlameResult: ");
        r.append(this.getResultPath());
        return r.toString();
    }

    private void loadFrom(BlameGenerator gen) {
        RevCommit srcCommit = gen.getSourceCommit();
        PersonIdent srcAuthor = gen.getSourceAuthor();
        PersonIdent srcCommitter = gen.getSourceCommitter();
        String srcPath = gen.getSourcePath();
        int srcLine = gen.getSourceStart();
        int resEnd = gen.getResultEnd();
        for (int resLine = gen.getResultStart(); resLine < resEnd; ++resLine) {
            if (this.sourceLines[resLine] != 0) continue;
            this.sourceCommits[resLine] = srcCommit;
            this.sourceAuthors[resLine] = srcAuthor;
            this.sourceCommitters[resLine] = srcCommitter;
            this.sourcePaths[resLine] = srcPath;
            this.sourceLines[resLine] = ++srcLine;
        }
    }
}

