/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.diff.Subsequence;
import org.eclipse.jgit.diff.SubsequenceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiffAlgorithm {
    public static DiffAlgorithm getAlgorithm(SupportedAlgorithm alg) {
        switch (alg) {
            case MYERS: {
                return MyersDiff.INSTANCE;
            }
            case HISTOGRAM: {
                return new HistogramDiff();
            }
        }
        throw new IllegalArgumentException();
    }

    public <S extends Sequence> EditList diff(SequenceComparator<? super S> cmp, S a, S b) {
        Edit region = cmp.reduceCommonStartEnd(a, b, DiffAlgorithm.coverEdit(a, b));
        switch (region.getType()) {
            case INSERT: 
            case DELETE: {
                return EditList.singleton(region);
            }
            case REPLACE: {
                Subsequence<S> bs;
                if (region.getLengthA() == 1 && region.getLengthB() == 1) {
                    return EditList.singleton(region);
                }
                SubsequenceComparator<? super S> cs = new SubsequenceComparator<S>(cmp);
                Subsequence<S> as = Subsequence.a(a, region);
                EditList e = Subsequence.toBase(this.diffNonCommon(cs, as, bs = Subsequence.b(b, region)), as, bs);
                Edit last2 = (Edit)e.get(e.size() - 1);
                if (last2.getType() == Edit.Type.INSERT) {
                    while (last2.endB < b.size() && cmp.equals(b, last2.beginB, b, last2.endB)) {
                        ++last2.beginA;
                        ++last2.endA;
                        ++last2.beginB;
                        ++last2.endB;
                    }
                }
                return e;
            }
            case EMPTY: {
                return new EditList(0);
            }
        }
        throw new IllegalStateException();
    }

    private static <S extends Sequence> Edit coverEdit(S a, S b) {
        return new Edit(0, a.size(), 0, b.size());
    }

    public abstract <S extends Sequence> EditList diffNonCommon(SequenceComparator<? super S> var1, S var2, S var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedAlgorithm {
        MYERS,
        HISTOGRAM;

    }
}

