/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilterMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffEntry {
    static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId(ObjectId.zeroId());
    public static final String DEV_NULL = "/dev/null";
    protected String oldPath;
    protected String newPath;
    protected FileMode oldMode;
    protected FileMode newMode;
    protected ChangeType changeType;
    protected int score;
    protected AbbreviatedObjectId oldId;
    protected AbbreviatedObjectId newId;
    private int treeFilterMarks = 0;

    protected DiffEntry() {
    }

    public static List<DiffEntry> scan(TreeWalk walk2) throws IOException {
        return DiffEntry.scan(walk2, false);
    }

    public static List<DiffEntry> scan(TreeWalk walk2, boolean includeTrees) throws IOException {
        return DiffEntry.scan(walk2, includeTrees, null);
    }

    public static List<DiffEntry> scan(TreeWalk walk2, boolean includeTrees, TreeFilter[] markTreeFilters) throws IOException {
        if (walk2.getTreeCount() != 2) {
            throw new IllegalArgumentException(JGitText.get().treeWalkMustHaveExactlyTwoTrees);
        }
        if (includeTrees && walk2.isRecursive()) {
            throw new IllegalArgumentException(JGitText.get().cannotBeRecursiveWhenTreesAreIncluded);
        }
        TreeFilterMarker treeFilterMarker = markTreeFilters != null && markTreeFilters.length > 0 ? new TreeFilterMarker(markTreeFilters) : null;
        ArrayList<DiffEntry> r = new ArrayList<DiffEntry>();
        MutableObjectId idBuf = new MutableObjectId();
        while (walk2.next()) {
            DiffEntry entry = new DiffEntry();
            walk2.getObjectId(idBuf, 0);
            entry.oldId = AbbreviatedObjectId.fromObjectId(idBuf);
            walk2.getObjectId(idBuf, 1);
            entry.newId = AbbreviatedObjectId.fromObjectId(idBuf);
            entry.oldMode = walk2.getFileMode(0);
            entry.newMode = walk2.getFileMode(1);
            entry.newPath = entry.oldPath = walk2.getPathString();
            if (treeFilterMarker != null) {
                entry.treeFilterMarks = treeFilterMarker.getMarks(walk2);
            }
            if (entry.oldMode == FileMode.MISSING) {
                entry.oldPath = DEV_NULL;
                entry.changeType = ChangeType.ADD;
                r.add(entry);
            } else if (entry.newMode == FileMode.MISSING) {
                entry.newPath = DEV_NULL;
                entry.changeType = ChangeType.DELETE;
                r.add(entry);
            } else if (!entry.oldId.equals(entry.newId)) {
                entry.changeType = ChangeType.MODIFY;
                if (RenameDetector.sameType(entry.oldMode, entry.newMode)) {
                    r.add(entry);
                } else {
                    r.addAll(DiffEntry.breakModify(entry));
                }
            } else if (entry.oldMode != entry.newMode) {
                entry.changeType = ChangeType.MODIFY;
                r.add(entry);
            }
            if (!includeTrees || !walk2.isSubtree()) continue;
            walk2.enterSubtree();
        }
        return r;
    }

    static DiffEntry add(String path2, AnyObjectId id2) {
        DiffEntry e = new DiffEntry();
        e.oldId = A_ZERO;
        e.oldMode = FileMode.MISSING;
        e.oldPath = DEV_NULL;
        e.newId = AbbreviatedObjectId.fromObjectId(id2);
        e.newMode = FileMode.REGULAR_FILE;
        e.newPath = path2;
        e.changeType = ChangeType.ADD;
        return e;
    }

    static DiffEntry delete(String path2, AnyObjectId id2) {
        DiffEntry e = new DiffEntry();
        e.oldId = AbbreviatedObjectId.fromObjectId(id2);
        e.oldMode = FileMode.REGULAR_FILE;
        e.oldPath = path2;
        e.newId = A_ZERO;
        e.newMode = FileMode.MISSING;
        e.newPath = DEV_NULL;
        e.changeType = ChangeType.DELETE;
        return e;
    }

    static DiffEntry modify(String path2) {
        DiffEntry e = new DiffEntry();
        e.oldMode = FileMode.REGULAR_FILE;
        e.oldPath = path2;
        e.newMode = FileMode.REGULAR_FILE;
        e.newPath = path2;
        e.changeType = ChangeType.MODIFY;
        return e;
    }

    static List<DiffEntry> breakModify(DiffEntry entry) {
        DiffEntry del = new DiffEntry();
        del.oldId = entry.getOldId();
        del.oldMode = entry.getOldMode();
        del.oldPath = entry.getOldPath();
        del.newId = A_ZERO;
        del.newMode = FileMode.MISSING;
        del.newPath = DEV_NULL;
        del.changeType = ChangeType.DELETE;
        DiffEntry add2 = new DiffEntry();
        add2.oldId = A_ZERO;
        add2.oldMode = FileMode.MISSING;
        add2.oldPath = DEV_NULL;
        add2.newId = entry.getNewId();
        add2.newMode = entry.getNewMode();
        add2.newPath = entry.getNewPath();
        add2.changeType = ChangeType.ADD;
        return Arrays.asList(del, add2);
    }

    static DiffEntry pair(ChangeType changeType, DiffEntry src, DiffEntry dst, int score) {
        DiffEntry r = new DiffEntry();
        r.oldId = src.oldId;
        r.oldMode = src.oldMode;
        r.oldPath = src.oldPath;
        r.newId = dst.newId;
        r.newMode = dst.newMode;
        r.newPath = dst.newPath;
        r.changeType = changeType;
        r.score = score;
        r.treeFilterMarks = src.treeFilterMarks | dst.treeFilterMarks;
        return r;
    }

    public String getOldPath() {
        return this.oldPath;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public String getPath(Side side) {
        return side == Side.OLD ? this.getOldPath() : this.getNewPath();
    }

    public FileMode getOldMode() {
        return this.oldMode;
    }

    public FileMode getNewMode() {
        return this.newMode;
    }

    public FileMode getMode(Side side) {
        return side == Side.OLD ? this.getOldMode() : this.getNewMode();
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public int getScore() {
        return this.score;
    }

    public AbbreviatedObjectId getOldId() {
        return this.oldId;
    }

    public AbbreviatedObjectId getNewId() {
        return this.newId;
    }

    public boolean isMarked(int index2) {
        return ((long)this.treeFilterMarks & 1L << index2) != 0L;
    }

    public int getTreeFilterMarks() {
        return this.treeFilterMarks;
    }

    public AbbreviatedObjectId getId(Side side) {
        return side == Side.OLD ? this.getOldId() : this.getNewId();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DiffEntry[");
        buf.append((Object)this.changeType);
        buf.append(" ");
        switch (this.changeType) {
            case ADD: {
                buf.append(this.newPath);
                break;
            }
            case COPY: {
                buf.append(this.oldPath + "->" + this.newPath);
                break;
            }
            case DELETE: {
                buf.append(this.oldPath);
                break;
            }
            case MODIFY: {
                buf.append(this.oldPath);
                break;
            }
            case RENAME: {
                buf.append(this.oldPath + "->" + this.newPath);
            }
        }
        buf.append("]");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        ADD,
        MODIFY,
        DELETE,
        RENAME,
        COPY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        OLD,
        NEW;

    }
}

