/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousObjectException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final AbbreviatedObjectId missing;
    private final Collection<ObjectId> candidates;

    public AmbiguousObjectException(AbbreviatedObjectId id2, Collection<ObjectId> candidates) {
        super(MessageFormat.format(JGitText.get().ambiguousObjectAbbreviation, id2.name()));
        this.missing = id2;
        this.candidates = candidates;
    }

    public AbbreviatedObjectId getAbbreviatedObjectId() {
        return this.missing;
    }

    public Collection<ObjectId> getCandidates() {
        return this.candidates;
    }
}

