/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoCommand
extends GitCommand<RevCommit> {
    private String path;
    private String uri;
    private String groups;
    private String branch;
    private PersonIdent author;
    private RemoteReader callback;
    private InputStream inputStream;
    private IncludedFileReader includedReader;
    private List<Project> bareProjects;
    private Git git;
    private ProgressMonitor monitor;

    public RepoCommand(Repository repo) {
        super(repo);
    }

    public RepoCommand setPath(String path2) {
        this.path = path2;
        return this;
    }

    public RepoCommand setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public RepoCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public RepoCommand setGroups(String groups) {
        this.groups = groups;
        return this;
    }

    public RepoCommand setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public RepoCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public RepoCommand setAuthor(PersonIdent author) {
        this.author = author;
        return this;
    }

    public RepoCommand setRemoteReader(RemoteReader callback) {
        this.callback = callback;
        return this;
    }

    public RepoCommand setIncludedFileReader(IncludedFileReader reader) {
        this.includedReader = reader;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevCommit call() throws GitAPIException {
        try {
            this.checkCallable();
            if (this.uri == null || this.uri.length() == 0) {
                throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
            }
            if (this.inputStream == null) {
                if (this.path == null || this.path.length() == 0) {
                    throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
                }
                try {
                    this.inputStream = new FileInputStream(this.path);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
                }
            }
            if (this.repo.isBare()) {
                this.bareProjects = new ArrayList<Project>();
                if (this.author == null) {
                    this.author = new PersonIdent(this.repo);
                }
                if (this.callback == null) {
                    this.callback = new DefaultRemoteReader();
                }
            } else {
                this.git = new Git(this.repo);
            }
            XmlManifest manifest = new XmlManifest(this, this.includedReader, this.path, this.uri, this.groups);
            try {
                manifest.read(this.inputStream);
            }
            catch (IOException e) {
                throw new ManifestErrorException(e);
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {}
        if (this.repo.isBare()) {
            DirCache index2 = DirCache.newInCore();
            DirCacheBuilder builder = index2.builder();
            ObjectInserter inserter = this.repo.newObjectInserter();
            RevWalk rw = new RevWalk(this.repo);
            try {
                Config cfg = new Config();
                for (Project proj : this.bareProjects) {
                    String name2 = proj.path;
                    String nameUri = proj.name;
                    cfg.setString("submodule", name2, "path", name2);
                    cfg.setString("submodule", name2, "url", nameUri);
                    DirCacheEntry dcEntry = new DirCacheEntry(name2);
                    ObjectId objectId = ObjectId.isId(proj.revision) ? ObjectId.fromString(proj.revision) : this.callback.sha1(nameUri, proj.revision);
                    if (objectId == null) {
                        throw new RemoteUnavailableException(nameUri);
                    }
                    dcEntry.setObjectId(objectId);
                    dcEntry.setFileMode(FileMode.GITLINK);
                    builder.add(dcEntry);
                    for (CopyFile copyfile : proj.copyfiles) {
                        byte[] src = this.callback.readFile(nameUri, proj.revision, copyfile.src);
                        objectId = inserter.insert(3, src);
                        dcEntry = new DirCacheEntry(copyfile.dest);
                        dcEntry.setObjectId(objectId);
                        dcEntry.setFileMode(FileMode.REGULAR_FILE);
                        builder.add(dcEntry);
                    }
                }
                String content = cfg.toText();
                DirCacheEntry dcEntry = new DirCacheEntry(".gitmodules");
                ObjectId objectId = inserter.insert(3, content.getBytes("UTF-8"));
                dcEntry.setObjectId(objectId);
                dcEntry.setFileMode(FileMode.REGULAR_FILE);
                builder.add(dcEntry);
                builder.finish();
                ObjectId treeId = index2.writeTree(inserter);
                ObjectId headId = this.repo.resolve("HEAD^{commit}");
                CommitBuilder commit2 = new CommitBuilder();
                commit2.setTreeId(treeId);
                if (headId != null) {
                    commit2.setParentIds(headId);
                }
                commit2.setAuthor(this.author);
                commit2.setCommitter(this.author);
                commit2.setMessage(RepoText.get().repoCommitMessage);
                ObjectId commitId = inserter.insert(commit2);
                inserter.flush();
                RefUpdate ru = this.repo.updateRef("HEAD");
                ru.setNewObjectId(commitId);
                ru.setExpectedOldObjectId(headId != null ? headId : ObjectId.zeroId());
                RefUpdate.Result rc = ru.update(rw);
                switch (rc) {
                    case NEW: 
                    case FORCED: 
                    case FAST_FORWARD: {
                        break;
                    }
                    case REJECTED: 
                    case LOCK_FAILURE: {
                        throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                    }
                    default: {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", commitId.name(), rc}));
                    }
                }
                RevCommit revCommit = rw.parseCommit(commitId);
                Object var17_22 = null;
                rw.release();
                return revCommit;
            }
            catch (IOException e) {
                try {
                    throw new ManifestErrorException(e);
                }
                catch (Throwable throwable) {
                    Object var17_23 = null;
                    rw.release();
                    throw throwable;
                }
            }
        }
        return this.git.commit().setMessage(RepoText.get().repoCommitMessage).call();
    }

    private void addSubmodule(String url, String name2, String revision, List<CopyFile> copyfiles) throws SAXException {
        if (this.repo.isBare()) {
            Project proj = new Project(url, name2, revision, null, null);
            proj.copyfiles.addAll(copyfiles);
            this.bareProjects.add(proj);
        } else {
            SubmoduleAddCommand add2 = this.git.submoduleAdd().setPath(name2).setURI(url);
            if (this.monitor != null) {
                add2.setProgressMonitor(this.monitor);
            }
            try {
                Repository subRepo = add2.call();
                if (revision != null) {
                    Git sub = new Git(subRepo);
                    sub.checkout().setName(RepoCommand.findRef(revision, subRepo)).call();
                    subRepo.close();
                    this.git.add().addFilepattern(name2).call();
                }
                for (CopyFile copyfile : copyfiles) {
                    copyfile.copy();
                    this.git.add().addFilepattern(copyfile.dest).call();
                }
            }
            catch (GitAPIException e) {
                throw new SAXException(e);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    private static String findRef(String ref, Repository repo) throws IOException {
        Ref r;
        if (!ObjectId.isId(ref) && (r = repo.getRef("origin/" + ref)) != null) {
            return r.getName();
        }
        return ref;
    }

    private static class CopyFile {
        final Repository repo;
        final String path;
        final String src;
        final String dest;

        CopyFile(Repository repo, String path2, String src, String dest) {
            this.repo = repo;
            this.path = path2;
            this.src = src;
            this.dest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void copy() throws IOException {
            File srcFile = new File(this.repo.getWorkTree(), this.path + "/" + this.src);
            File destFile = new File(this.repo.getWorkTree(), this.dest);
            FileInputStream input2 = new FileInputStream(srcFile);
            try {
                FileOutputStream output = new FileOutputStream(destFile);
                try {
                    FileChannel channel = input2.getChannel();
                    output.getChannel().transferFrom(channel, 0L, channel.size());
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    output.close();
                    throw throwable;
                }
                output.close();
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                input2.close();
                throw throwable;
            }
            input2.close();
        }
    }

    public static class DefaultRemoteReader
    implements RemoteReader {
        public ObjectId sha1(String uri, String ref) throws GitAPIException {
            Map<String, Ref> map2 = Git.lsRemoteRepository().setRemote(uri).callAsMap();
            Ref r = RefDatabase.findRef(map2, ref);
            return r != null ? r.getObjectId() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] readFile(String uri, String ref, String path2) throws GitAPIException, IOException {
            byte[] byArray;
            File dir = FileUtils.createTempDir("jgit_", ".git", null);
            Repository repo = Git.cloneRepository().setBare(true).setDirectory(dir).setURI(uri).call().getRepository();
            try {
                byArray = this.readFileFromRepo(repo, ref, path2);
                Object var8_7 = null;
                repo.close();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                repo.close();
                FileUtils.delete(dir, 1);
                throw throwable;
            }
            FileUtils.delete(dir, 1);
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] readFileFromRepo(Repository repo, String ref, String path2) throws GitAPIException, IOException {
            byte[] result2;
            ObjectReader reader = repo.newObjectReader();
            try {
                ObjectId oid = repo.resolve(ref + ":" + path2);
                result2 = reader.open(oid).getBytes(Integer.MAX_VALUE);
                Object var8_7 = null;
                reader.release();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                reader.release();
                throw throwable;
            }
            return result2;
        }
    }

    public static interface IncludedFileReader {
        public InputStream readIncludeFile(String var1) throws GitAPIException, IOException;
    }

    private static class ManifestErrorException
    extends GitAPIException {
        ManifestErrorException(Throwable cause) {
            super(RepoText.get().invalidManifest, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Project
    implements Comparable<Project> {
        final String name;
        final String path;
        final String revision;
        final String remote;
        final Set<String> groups;
        final List<CopyFile> copyfiles;

        Project(String name2, String path2, String revision, String remote2, String groups) {
            this.name = name2;
            this.path = path2 != null ? path2 : name2;
            this.revision = revision;
            this.remote = remote2;
            this.groups = new HashSet<String>();
            if (groups != null && groups.length() > 0) {
                this.groups.addAll(Arrays.asList(groups.split(",")));
            }
            this.copyfiles = new ArrayList<CopyFile>();
        }

        void addCopyFile(CopyFile copyfile) {
            this.copyfiles.add(copyfile);
        }

        String getPathWithSlash() {
            if (this.path.endsWith("/")) {
                return this.path;
            }
            return this.path + "/";
        }

        boolean isAncestorOf(Project that) {
            return that.getPathWithSlash().startsWith(this.getPathWithSlash());
        }

        public boolean equals(Object o) {
            if (o instanceof Project) {
                Project that = (Project)o;
                return this.getPathWithSlash().equals(that.getPathWithSlash());
            }
            return false;
        }

        public int hashCode() {
            return this.getPathWithSlash().hashCode();
        }

        @Override
        public int compareTo(Project that) {
            return this.getPathWithSlash().compareTo(that.getPathWithSlash());
        }
    }

    public static interface RemoteReader {
        public ObjectId sha1(String var1, String var2) throws GitAPIException;

        public byte[] readFile(String var1, String var2, String var3) throws GitAPIException, IOException;
    }

    private static class RemoteUnavailableException
    extends GitAPIException {
        RemoteUnavailableException(String uri) {
            super(MessageFormat.format(RepoText.get().errorRemoteUnavailable, uri));
        }
    }

    private static class XmlManifest
    extends DefaultHandler {
        private final RepoCommand command;
        private final String filename;
        private final String baseUrl;
        private final Map<String, String> remotes;
        private final Set<String> plusGroups;
        private final Set<String> minusGroups;
        private List<Project> projects;
        private String defaultRemote;
        private String defaultRevision;
        private IncludedFileReader includedReader;
        private int xmlInRead;
        private Project currentProject;

        XmlManifest(RepoCommand command, IncludedFileReader includedReader, String filename, String baseUrl, String groups) {
            int lastIndex;
            this.command = command;
            this.includedReader = includedReader;
            this.filename = filename;
            for (lastIndex = baseUrl.length() - 1; lastIndex >= 0 && baseUrl.charAt(lastIndex) == '/'; --lastIndex) {
            }
            this.baseUrl = baseUrl.substring(0, lastIndex + 1);
            this.remotes = new HashMap<String, String>();
            this.projects = new ArrayList<Project>();
            this.plusGroups = new HashSet<String>();
            this.minusGroups = new HashSet<String>();
            if (groups == null || groups.length() == 0 || groups.equals("default")) {
                this.minusGroups.add("notdefault");
            } else {
                for (String group : groups.split(",")) {
                    if (group.startsWith("-")) {
                        this.minusGroups.add(group.substring(1));
                        continue;
                    }
                    this.plusGroups.add(group);
                }
            }
        }

        void read(InputStream inputStream) throws IOException {
            XMLReader xr;
            ++this.xmlInRead;
            try {
                xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                throw new IOException(JGitText.get().noXMLParserAvailable);
            }
            xr.setContentHandler(this);
            try {
                xr.parse(new InputSource(inputStream));
            }
            catch (SAXException e) {
                IOException error2 = new IOException(RepoText.get().errorParsingManifestFile);
                error2.initCause(e);
                throw error2;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("project".equals(qName)) {
                this.currentProject = new Project(attributes.getValue("name"), attributes.getValue("path"), attributes.getValue("revision"), attributes.getValue("remote"), attributes.getValue("groups"));
            } else if ("remote".equals(qName)) {
                String alias = attributes.getValue("alias");
                String fetch = attributes.getValue("fetch");
                this.remotes.put(attributes.getValue("name"), fetch);
                if (alias != null) {
                    this.remotes.put(alias, fetch);
                }
            } else if ("default".equals(qName)) {
                this.defaultRemote = attributes.getValue("remote");
                this.defaultRevision = attributes.getValue("revision");
                if (this.defaultRevision == null) {
                    this.defaultRevision = this.command.branch;
                }
            } else if ("copyfile".equals(qName)) {
                if (this.currentProject == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject.addCopyFile(new CopyFile(this.command.repo, this.currentProject.path, attributes.getValue("src"), attributes.getValue("dest")));
            } else if ("include".equals(qName)) {
                String name2 = attributes.getValue("name");
                InputStream is = null;
                if (this.includedReader != null) {
                    try {
                        is = this.includedReader.readIncludeFile(name2);
                    }
                    catch (Exception e) {
                        throw new SAXException(MessageFormat.format(RepoText.get().errorIncludeFile, name2), e);
                    }
                }
                if (this.filename != null) {
                    int index2 = this.filename.lastIndexOf(47);
                    String path2 = this.filename.substring(0, index2 + 1) + name2;
                    try {
                        is = new FileInputStream(path2);
                    }
                    catch (IOException e) {
                        throw new SAXException(MessageFormat.format(RepoText.get().errorIncludeFile, path2), e);
                    }
                }
                if (is == null) {
                    throw new SAXException(RepoText.get().errorIncludeNotImplemented);
                }
                try {
                    this.read(is);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("project".equals(qName)) {
                this.projects.add(this.currentProject);
                this.currentProject = null;
            }
        }

        public void endDocument() throws SAXException {
            URI baseUri;
            --this.xmlInRead;
            if (this.xmlInRead != 0) {
                return;
            }
            this.removeNotInGroup();
            this.removeOverlaps();
            HashMap<String, String> remoteUrls = new HashMap<String, String>();
            try {
                baseUri = new URI(this.baseUrl);
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
            for (Project proj : this.projects) {
                String remoteUrl;
                String remote2 = proj.remote;
                if (remote2 == null) {
                    if (this.defaultRemote == null) {
                        if (this.filename != null) {
                            throw new SAXException(MessageFormat.format(RepoText.get().errorNoDefaultFilename, this.filename));
                        }
                        throw new SAXException(RepoText.get().errorNoDefault);
                    }
                    remote2 = this.defaultRemote;
                }
                if ((remoteUrl = (String)remoteUrls.get(remote2)) == null) {
                    remoteUrl = baseUri.resolve(this.remotes.get(remote2)).toString();
                    if (!remoteUrl.endsWith("/")) {
                        remoteUrl = remoteUrl + "/";
                    }
                    remoteUrls.put(remote2, remoteUrl);
                }
                this.command.addSubmodule(remoteUrl + proj.name, proj.path, proj.revision == null ? this.defaultRevision : proj.revision, proj.copyfiles);
            }
        }

        void removeNotInGroup() {
            Iterator<Project> iter2 = this.projects.iterator();
            while (iter2.hasNext()) {
                if (this.inGroups(iter2.next())) continue;
                iter2.remove();
            }
        }

        void removeOverlaps() {
            Collections.sort(this.projects);
            Iterator<Project> iter2 = this.projects.iterator();
            if (!iter2.hasNext()) {
                return;
            }
            Project last2 = iter2.next();
            while (iter2.hasNext()) {
                Project p = iter2.next();
                if (last2.isAncestorOf(p)) {
                    iter2.remove();
                    continue;
                }
                last2 = p;
            }
        }

        boolean inGroups(Project proj) {
            for (String group : this.minusGroups) {
                if (!proj.groups.contains(group)) continue;
                return false;
            }
            if (this.plusGroups.isEmpty() || this.plusGroups.contains("all")) {
                return true;
            }
            for (String group : this.plusGroups) {
                if (!proj.groups.contains(group)) continue;
                return true;
            }
            return false;
        }
    }
}

