/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsInserter;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPackKey;
import org.eclipse.jgit.internal.storage.dfs.DfsText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PackedObjectInfo;

public class DfsPackParser
extends PackParser {
    private final DfsObjDatabase objdb;
    private final DfsInserter objins;
    private final CRC32 crc;
    private final MessageDigest packDigest;
    private int blockSize;
    private long packEnd;
    private byte[] packHash;
    private Deflater def;
    private boolean isEmptyPack;
    private DfsPackDescription packDsc;
    private DfsPackKey packKey;
    private PackIndex packIndex;
    private DfsOutputStream out;
    private byte[] currBuf;
    private long currPos;
    private int currEnd;
    private DfsBlockCache blockCache;
    private long readPos;
    private DfsBlock readBlock;

    protected DfsPackParser(DfsObjDatabase db, DfsInserter ins, InputStream in) {
        super(db, in);
        this.objdb = db;
        this.objins = ins;
        this.crc = new CRC32();
        this.packDigest = Constants.newMessageDigest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackLock parse(ProgressMonitor receiving, ProgressMonitor resolving) throws IOException {
        PackLock packLock;
        boolean rollback;
        block24: {
            block20: {
                PackLock packLock2;
                block21: {
                    rollback = true;
                    try {
                        this.blockCache = DfsBlockCache.getInstance();
                        super.parse(receiving, resolving);
                        if (!this.isEmptyPack) break block20;
                        packLock2 = null;
                        Object var7_6 = null;
                        this.blockCache = null;
                        this.currBuf = null;
                        this.readBlock = null;
                        if (this.def != null) {
                            this.def.end();
                            this.def = null;
                        }
                        if (this.out == null) break block21;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        this.blockCache = null;
                        this.currBuf = null;
                        this.readBlock = null;
                        if (this.def != null) {
                            this.def.end();
                            this.def = null;
                        }
                        if (this.out != null) {
                            try {
                                this.out.close();
                            }
                            catch (IOException err2) {
                                // empty catch block
                            }
                            this.out = null;
                        }
                        if (rollback && this.packDsc != null) {
                            try {
                                this.objdb.rollbackPack(Collections.singletonList(this.packDsc));
                                Object var10_16 = null;
                                this.packDsc = null;
                            }
                            catch (Throwable throwable2) {
                                Object var10_17 = null;
                                this.packDsc = null;
                                throw throwable2;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        this.out.close();
                    }
                    catch (IOException err2) {
                        // empty catch block
                    }
                    this.out = null;
                }
                if (rollback && this.packDsc != null) {
                    try {
                        this.objdb.rollbackPack(Collections.singletonList(this.packDsc));
                        Object var10_12 = null;
                        this.packDsc = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        this.packDsc = null;
                        throw throwable;
                    }
                }
                return packLock2;
            }
            this.buffer(this.packHash, 0, this.packHash.length);
            if (this.currEnd != 0) {
                this.flushBlock();
            }
            this.out.close();
            this.out = null;
            this.currBuf = null;
            this.readBlock = null;
            this.packDsc.addFileExt(PackExt.PACK);
            this.packDsc.setFileSize(PackExt.PACK, this.packEnd);
            this.writePackIndex();
            this.objdb.commitPack(Collections.singletonList(this.packDsc), null);
            rollback = false;
            DfsPackFile p = this.blockCache.getOrCreate(this.packDsc, this.packKey);
            p.setBlockSize(this.blockSize);
            if (this.packIndex != null) {
                p.setPackIndex(this.packIndex);
            }
            this.objdb.addPack(p);
            packLock = null;
            Object var7_7 = null;
            this.blockCache = null;
            this.currBuf = null;
            this.readBlock = null;
            if (this.def != null) {
                this.def.end();
                this.def = null;
            }
            if (this.out == null) break block24;
            try {
                this.out.close();
            }
            catch (IOException err2) {
                // empty catch block
            }
            this.out = null;
        }
        if (rollback && this.packDsc != null) {
            try {
                this.objdb.rollbackPack(Collections.singletonList(this.packDsc));
                Object var10_14 = null;
                this.packDsc = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                this.packDsc = null;
                throw throwable;
            }
        }
        return packLock;
    }

    public DfsPackDescription getPackDescription() {
        return this.packDsc;
    }

    protected void onPackHeader(long objectCount) throws IOException {
        if (objectCount == 0L) {
            this.isEmptyPack = true;
            this.currBuf = new byte[256];
            return;
        }
        this.packDsc = this.objdb.newPack(DfsObjDatabase.PackSource.RECEIVE);
        this.packKey = new DfsPackKey();
        this.out = this.objdb.writeFile(this.packDsc, PackExt.PACK);
        int size2 = this.out.blockSize();
        if (size2 <= 0) {
            size2 = this.blockCache.getBlockSize();
        } else if (size2 < this.blockCache.getBlockSize()) {
            size2 = this.blockCache.getBlockSize() / size2 * size2;
        }
        this.blockSize = size2;
        this.currBuf = new byte[this.blockSize];
    }

    protected void onBeginWholeObject(long streamPosition, int type, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    protected void onEndWholeObject(PackedObjectInfo info2) throws IOException {
        info2.setCRC((int)this.crc.getValue());
    }

    protected void onBeginOfsDelta(long streamPosition, long baseStreamPosition, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    protected void onBeginRefDelta(long streamPosition, AnyObjectId baseId, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    protected PackParser.UnresolvedDelta onEndDelta() throws IOException {
        PackParser.UnresolvedDelta delta = new PackParser.UnresolvedDelta();
        delta.setCRC((int)this.crc.getValue());
        return delta;
    }

    protected void onInflatedObjectData(PackedObjectInfo obj2, int typeCode, byte[] data) throws IOException {
    }

    protected void onObjectHeader(PackParser.Source src, byte[] raw2, int pos, int len2) throws IOException {
        this.crc.update(raw2, pos, len2);
    }

    protected void onObjectData(PackParser.Source src, byte[] raw2, int pos, int len2) throws IOException {
        this.crc.update(raw2, pos, len2);
    }

    protected void onStoreStream(byte[] raw2, int pos, int len2) throws IOException {
        this.buffer(raw2, pos, len2);
        this.packDigest.update(raw2, pos, len2);
    }

    private void buffer(byte[] raw2, int pos, int len2) throws IOException {
        while (0 < len2) {
            int n = Math.min(len2, this.currBuf.length - this.currEnd);
            if (n == 0) {
                DfsBlock v = this.flushBlock();
                this.currBuf = new byte[this.blockSize];
                this.currEnd = 0;
                this.currPos += (long)v.size();
                continue;
            }
            System.arraycopy(raw2, pos, this.currBuf, this.currEnd, n);
            pos += n;
            len2 -= n;
            this.currEnd += n;
            this.packEnd += (long)n;
        }
    }

    private DfsBlock flushBlock() throws IOException {
        DfsBlock v;
        byte[] buf;
        if (this.isEmptyPack) {
            throw new IOException(DfsText.get().willNotStoreEmptyPack);
        }
        this.out.write(this.currBuf, 0, this.currEnd);
        if (this.currEnd == this.currBuf.length) {
            buf = this.currBuf;
        } else {
            buf = new byte[this.currEnd];
            System.arraycopy(this.currBuf, 0, buf, 0, this.currEnd);
        }
        this.readBlock = v = new DfsBlock(this.packKey, this.currPos, buf);
        this.blockCache.put(v);
        return v;
    }

    protected void onPackFooter(byte[] hash2) throws IOException {
        this.packHash = hash2;
    }

    protected PackParser.ObjectTypeAndSize seekDatabase(PackedObjectInfo obj2, PackParser.ObjectTypeAndSize info2) throws IOException {
        this.readPos = obj2.getOffset();
        this.crc.reset();
        return this.readObjectHeader(info2);
    }

    protected PackParser.ObjectTypeAndSize seekDatabase(PackParser.UnresolvedDelta delta, PackParser.ObjectTypeAndSize info2) throws IOException {
        this.readPos = delta.getOffset();
        this.crc.reset();
        return this.readObjectHeader(info2);
    }

    protected int readDatabase(byte[] dst, int pos, int cnt) throws IOException {
        if (cnt == 0) {
            return 0;
        }
        if (this.currPos <= this.readPos) {
            int p = (int)(this.readPos - this.currPos);
            int n = Math.min(cnt, this.currEnd - p);
            if (n == 0) {
                throw new EOFException();
            }
            System.arraycopy(this.currBuf, p, dst, pos, n);
            this.readPos += (long)n;
            return n;
        }
        if (this.readBlock == null || !this.readBlock.contains(this.packKey, this.readPos)) {
            long start2 = this.toBlockStart(this.readPos);
            this.readBlock = (DfsBlock)this.blockCache.get(this.packKey, start2);
            if (this.readBlock == null) {
                int size2 = (int)Math.min((long)this.blockSize, this.packEnd - start2);
                byte[] buf = new byte[size2];
                if (this.read(start2, buf, 0, size2) != size2) {
                    throw new EOFException();
                }
                this.readBlock = new DfsBlock(this.packKey, start2, buf);
                this.blockCache.put(this.readBlock);
            }
        }
        int n = this.readBlock.copy(this.readPos, dst, pos, cnt);
        this.readPos += (long)n;
        return n;
    }

    private int read(long pos, byte[] dst, int off, int len2) throws IOException {
        int r;
        if (len2 == 0) {
            return 0;
        }
        int cnt = 0;
        while (0 < len2 && (r = this.out.read(pos, ByteBuffer.wrap(dst, off, len2))) > 0) {
            pos += (long)r;
            off += r;
            len2 -= r;
            cnt += r;
        }
        return cnt != 0 ? cnt : -1;
    }

    private long toBlockStart(long pos) {
        return pos / (long)this.blockSize * (long)this.blockSize;
    }

    protected boolean checkCRC(int oldCRC) {
        return oldCRC == (int)this.crc.getValue();
    }

    protected boolean onAppendBase(int typeCode, byte[] data, PackedObjectInfo info2) throws IOException {
        info2.setOffset(this.packEnd);
        byte[] buf = this.buffer();
        int sz = data.length;
        int len2 = 0;
        buf[len2++] = (byte)(typeCode << 4 | sz & 0xF);
        sz >>>= 4;
        while (sz > 0) {
            int n = len2 - 1;
            buf[n] = (byte)(buf[n] | 0x80);
            buf[len2++] = (byte)(sz & 0x7F);
            sz >>>= 7;
        }
        this.packDigest.update(buf, 0, len2);
        this.crc.reset();
        this.crc.update(buf, 0, len2);
        this.buffer(buf, 0, len2);
        if (this.def == null) {
            this.def = new Deflater(-1, false);
        } else {
            this.def.reset();
        }
        this.def.setInput(data);
        this.def.finish();
        while (!this.def.finished()) {
            len2 = this.def.deflate(buf);
            this.packDigest.update(buf, 0, len2);
            this.crc.update(buf, 0, len2);
            this.buffer(buf, 0, len2);
        }
        info2.setCRC((int)this.crc.getValue());
        return true;
    }

    protected void onEndThinPack() throws IOException {
        this.packHash = this.packDigest.digest();
    }

    private void writePackIndex() throws IOException {
        List<PackedObjectInfo> list2 = this.getSortedObjectList(null);
        this.packIndex = this.objins.writePackIndex(this.packDsc, this.packHash, list2);
    }
}

