/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsCachedPack;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.BlockList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfsReader
extends ObjectReader
implements ObjectReuseAsIs {
    final byte[] tempId = new byte[20];
    final DfsObjDatabase db;
    private Inflater inf;
    private DfsBlock block;
    private DeltaBaseCache baseCache;
    private DfsPackFile last;
    private boolean avoidUnreachable;
    private static final Comparator<FoundObject<?>> FOUND_OBJECT_SORT = new Comparator<FoundObject<?>>(){

        @Override
        public int compare(FoundObject<?> a, FoundObject<?> b) {
            int cmp = a.packIndex - b.packIndex;
            if (cmp == 0) {
                cmp = Long.signum(a.offset - b.offset);
            }
            return cmp;
        }
    };
    private static final Comparator<DfsObjectToPack> OFFSET_SORT = new Comparator<DfsObjectToPack>(){

        @Override
        public int compare(DfsObjectToPack a, DfsObjectToPack b) {
            return Long.signum(a.getOffset() - b.getOffset());
        }
    };

    DfsReader(DfsObjDatabase db) {
        this.db = db;
    }

    DfsReaderOptions getOptions() {
        return this.db.getReaderOptions();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache(this);
        }
        return this.baseCache;
    }

    int getStreamFileThreshold() {
        return this.getOptions().getStreamFileThreshold();
    }

    @Override
    public ObjectReader newReader() {
        return new DfsReader(this.db);
    }

    @Override
    public void setAvoidUnreachableObjects(boolean avoid) {
        this.avoidUnreachable = avoid;
    }

    @Override
    public BitmapIndex getBitmapIndex() throws IOException {
        for (DfsPackFile pack : this.db.getPacks()) {
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(this);
            if (bitmapIndex == null) continue;
            return new BitmapIndexImpl(bitmapIndex);
        }
        return null;
    }

    @Override
    public Collection<CachedPack> getCachedPacksAndUpdate(BitmapIndex.BitmapBuilder needBitmap) throws IOException {
        for (DfsPackFile pack : this.db.getPacks()) {
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(this);
            if (!needBitmap.removeAllOrNone(bitmapIndex)) continue;
            return Collections.singletonList(new DfsCachedPack(pack));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id2) throws IOException {
        if (id2.isComplete()) {
            return Collections.singleton(id2.toObjectId());
        }
        boolean noGarbage = this.avoidUnreachable;
        HashSet<ObjectId> matches = new HashSet<ObjectId>(4);
        for (DfsPackFile pack : this.db.getPacks()) {
            if (noGarbage && pack.isGarbage()) continue;
            pack.resolve(this, matches, id2, 256);
            if (256 <= matches.size()) break;
        }
        return matches;
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        if (this.last != null && this.last.hasObject(this, objectId)) {
            return true;
        }
        boolean noGarbage = this.avoidUnreachable;
        for (DfsPackFile pack : this.db.getPacks()) {
            if (pack == this.last || noGarbage && pack.isGarbage() || !pack.hasObject(this, objectId)) continue;
            this.last = pack;
            return true;
        }
        return false;
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr;
        if (this.last != null && (ldr = this.last.get(this, objectId)) != null) {
            return ldr;
        }
        boolean noGarbage = this.avoidUnreachable;
        for (DfsPackFile pack : this.db.getPacks()) {
            ObjectLoader ldr2;
            if (pack == this.last || noGarbage && pack.isGarbage() || (ldr2 = pack.get(this, objectId)) == null) continue;
            this.last = pack;
            return ldr2;
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), "unknown");
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    @Override
    public Set<ObjectId> getShallowCommits() {
        return Collections.emptySet();
    }

    private <T extends ObjectId> Iterable<FoundObject<T>> findAll(Iterable<T> objectIds) throws IOException {
        ArrayList<FoundObject<T>> r = new ArrayList<FoundObject<T>>();
        DfsPackFile[] packList = this.db.getPacks();
        if (packList.length == 0) {
            for (ObjectId t : objectIds) {
                r.add(new FoundObject<ObjectId>(t));
            }
            return r;
        }
        int lastIdx = 0;
        DfsPackFile lastPack = packList[lastIdx];
        boolean noGarbage = this.avoidUnreachable;
        block5: for (ObjectId t : objectIds) {
            try {
                long p = lastPack.findOffset(this, t);
                if (0L < p) {
                    r.add(new FoundObject<ObjectId>(t, lastIdx, lastPack, p));
                    continue;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            for (int i = 0; i < packList.length; ++i) {
                if (i == lastIdx) continue;
                DfsPackFile pack = packList[i];
                if (noGarbage && pack.isGarbage()) continue;
                try {
                    long p = pack.findOffset(this, t);
                    if (0L >= p) continue;
                    r.add(new FoundObject<ObjectId>(t, i, pack, p));
                    lastIdx = i;
                    lastPack = pack;
                    continue block5;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            r.add(new FoundObject<ObjectId>(t));
        }
        Collections.sort(r, FOUND_OBJECT_SORT);
        this.last = lastPack;
        return r;
    }

    @Override
    public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error2 = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error2 = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error2;
        return new AsyncObjectLoaderQueue<T>(){
            private FoundObject<T> cur;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public ObjectLoader open() throws IOException {
                if (this.cur.pack == null) {
                    throw new MissingObjectException((ObjectId)this.cur.id, "unknown");
                }
                return this.cur.pack.load(DfsReader.this, this.cur.offset);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error2 = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error2 = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error2;
        return new AsyncObjectSizeQueue<T>(){
            private FoundObject<T> cur;
            private long sz;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    if (this.cur.pack == null) {
                        throw new MissingObjectException((ObjectId)this.cur.id, "unknown");
                    }
                    this.sz = this.cur.pack.getObjectSize(DfsReader.this, this.cur.offset);
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public long getSize() {
                return this.sz;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz;
        if (this.last != null && 0L <= (sz = this.last.getObjectSize(this, objectId))) {
            return sz;
        }
        for (DfsPackFile pack : this.db.getPacks()) {
            long sz2;
            if (pack == this.last || 0L > (sz2 = pack.getObjectSize(this, objectId))) continue;
            this.last = pack;
            return sz2;
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), "unknown");
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    @Override
    public DfsObjectToPack newObjectToPack(AnyObjectId objectId, int type) {
        return new DfsObjectToPack(objectId, type);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        for (DfsPackFile pack : this.db.getPacks()) {
            List<DfsObjectToPack> tmp = this.findAllFromPack(pack, objects);
            if (tmp.isEmpty()) continue;
            Collections.sort(tmp, OFFSET_SORT);
            PackReverseIndex rev = pack.getReverseIdx(this);
            DfsObjectRepresentation rep2 = new DfsObjectRepresentation(pack);
            for (DfsObjectToPack otp : tmp) {
                pack.representation(rep2, otp.getOffset(), this, rev);
                otp.setOffset(0L);
                packer.select(otp, rep2);
                if (otp.isFound()) continue;
                otp.setFound();
                monitor.update(1);
            }
        }
    }

    private List<DfsObjectToPack> findAllFromPack(DfsPackFile pack, Iterable<ObjectToPack> objects) throws IOException {
        BlockList<DfsObjectToPack> tmp = new BlockList<DfsObjectToPack>();
        PackIndex idx = pack.getPackIndex(this);
        for (ObjectToPack otp : objects) {
            long p = idx.findOffset(otp);
            if (0L >= p) continue;
            otp.setOffset(p);
            tmp.add((DfsObjectToPack)otp);
        }
        return tmp;
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp, boolean validate2) throws IOException, StoredObjectRepresentationNotAvailableException {
        DfsObjectToPack src = (DfsObjectToPack)otp;
        src.pack.copyAsIs(out, src, validate2, this);
    }

    @Override
    public void writeObjects(PackOutputStream out, List<ObjectToPack> list2) throws IOException {
        for (ObjectToPack otp : list2) {
            out.writeObject(otp);
        }
    }

    @Override
    public void copyPackAsIs(PackOutputStream out, CachedPack pack, boolean validate2) throws IOException {
        ((DfsCachedPack)pack).copyAsIs(out, validate2, this);
    }

    int copy(DfsPackFile pack, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        if (cnt == 0) {
            return 0;
        }
        long length = pack.length;
        if (0L <= length && length <= position) {
            return 0;
        }
        int need = cnt;
        do {
            this.pin(pack, position);
            int r = this.block.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
            need -= r;
            if (length >= 0L) continue;
            length = pack.length;
        } while (0 < need && position < length);
        return cnt - need;
    }

    void copyPackAsIs(DfsPackFile pack, long length, boolean validate2, PackOutputStream out) throws IOException {
        int n;
        MessageDigest md = null;
        if (validate2) {
            md = Constants.newMessageDigest();
            byte[] buf = out.getCopyBuffer();
            this.pin(pack, 0L);
            if (this.block.copy(0, buf, 0, 12) != 12) {
                pack.setInvalid();
                throw new IOException(JGitText.get().packfileIsTruncated);
            }
            md.update(buf, 0, 12);
        }
        long position = 12L;
        for (long remaining = length - 32L; 0L < remaining; remaining -= (long)n) {
            this.pin(pack, position);
            int ptr = (int)(position - this.block.start);
            n = (int)Math.min((long)(this.block.size() - ptr), remaining);
            this.block.write(out, position, n, md);
            position += (long)n;
        }
        if (md != null) {
            byte[] buf = new byte[20];
            byte[] actHash = md.digest();
            this.pin(pack, position);
            if (this.block.copy(position, buf, 0, 20) != 20) {
                pack.setInvalid();
                throw new IOException(JGitText.get().packfileIsTruncated);
            }
            if (!Arrays.equals(actHash, buf)) {
                pack.setInvalid();
                throw new IOException(MessageFormat.format(JGitText.get().packfileCorruptionDetected, pack.getPackDescription().getFileName(PackExt.PACK)));
            }
        }
    }

    int inflate(DfsPackFile pack, long position, byte[] dstbuf, boolean headerOnly) throws IOException, DataFormatException {
        this.prepareInflater();
        this.pin(pack, position);
        position += (long)this.block.setInput(position, this.inf);
        int dstoff = 0;
        while (true) {
            int n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
            if (this.inf.finished() || headerOnly && (dstoff += n) == dstbuf.length) {
                return dstoff;
            }
            if (this.inf.needsInput()) {
                this.pin(pack, position);
                position += (long)this.block.setInput(position, this.inf);
                continue;
            }
            if (n == 0) break;
        }
        throw new DataFormatException();
    }

    DfsBlock quickCopy(DfsPackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.block.contains(p.key, pos + (cnt - 1L))) {
            return this.block;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(DfsPackFile pack, long position) throws IOException {
        DfsBlock b = this.block;
        if (b == null || !b.contains(pack.key, position)) {
            this.block = null;
            this.block = pack.getOrLoadBlock(position, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.last = null;
        this.block = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
            Object var2_1 = null;
            this.inf = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.inf = null;
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FoundObject<T extends ObjectId> {
        final T id;
        final DfsPackFile pack;
        final long offset;
        final int packIndex;

        FoundObject(T objectId, int packIdx, DfsPackFile pack, long offset) {
            this.id = objectId;
            this.pack = pack;
            this.offset = offset;
            this.packIndex = packIdx;
        }

        FoundObject(T objectId) {
            this.id = objectId;
            this.pack = null;
            this.offset = 0L;
            this.packIndex = 0;
        }
    }
}

