/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexV1;
import org.eclipse.jgit.internal.storage.file.SimpleDataOutput;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;

public class PackBitmapIndexWriterV1 {
    private final DigestOutputStream out;
    private final DataOutput dataOutput;

    public PackBitmapIndexWriterV1(OutputStream dst) {
        this.out = new DigestOutputStream(dst instanceof BufferedOutputStream ? dst : new SafeBufferedOutputStream(dst), Constants.newMessageDigest());
        this.dataOutput = new SimpleDataOutput(this.out);
    }

    public void write(PackBitmapIndexBuilder bitmaps, byte[] packDataChecksum) throws IOException {
        if (bitmaps == null || packDataChecksum.length != 20) {
            throw new IllegalStateException();
        }
        this.writeHeader(bitmaps.getOptions(), bitmaps.getBitmapCount(), packDataChecksum);
        this.writeBody(bitmaps);
        this.writeFooter();
        this.out.flush();
    }

    private void writeHeader(int options2, int bitmapCount, byte[] packDataChecksum) throws IOException {
        this.out.write(PackBitmapIndexV1.MAGIC);
        this.dataOutput.writeShort(1);
        this.dataOutput.writeShort(options2);
        this.dataOutput.writeInt(bitmapCount);
        this.out.write(packDataChecksum);
    }

    private void writeBody(PackBitmapIndexBuilder bitmaps) throws IOException {
        this.writeBitmap(bitmaps.getCommits());
        this.writeBitmap(bitmaps.getTrees());
        this.writeBitmap(bitmaps.getBlobs());
        this.writeBitmap(bitmaps.getTags());
        this.writeBitmaps(bitmaps);
    }

    private void writeBitmap(EWAHCompressedBitmap bitmap) throws IOException {
        bitmap.serialize(this.dataOutput);
    }

    private void writeBitmaps(PackBitmapIndexBuilder bitmaps) throws IOException {
        int bitmapCount = 0;
        for (PackBitmapIndexBuilder.StoredEntry entry : bitmaps.getCompressedBitmaps()) {
            this.writeBitmapEntry(entry);
            ++bitmapCount;
        }
        int expectedBitmapCount = bitmaps.getBitmapCount();
        if (expectedBitmapCount != bitmapCount) {
            throw new IOException(MessageFormat.format(JGitText.get().expectedGot, String.valueOf(expectedBitmapCount), String.valueOf(bitmapCount)));
        }
    }

    private void writeBitmapEntry(PackBitmapIndexBuilder.StoredEntry entry) throws IOException {
        this.dataOutput.writeInt((int)entry.getObjectId());
        this.out.write(entry.getXorOffset());
        this.out.write(entry.getFlags());
        this.writeBitmap(entry.getBitmap());
    }

    private void writeFooter() throws IOException {
        this.out.on(false);
        this.out.write(this.out.getMessageDigest().digest());
    }
}

