/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackIndexV1
extends PackIndex {
    private static final int IDX_HDR_LEN = 1024;
    private final long[] idxHeader;
    private byte[][] idxdata;
    private long objectCnt;

    PackIndexV1(InputStream fd, byte[] hdr) throws CorruptObjectException, IOException {
        int k;
        byte[] fanoutTable = new byte[1024];
        System.arraycopy(hdr, 0, fanoutTable, 0, hdr.length);
        IO.readFully(fd, fanoutTable, hdr.length, 1024 - hdr.length);
        this.idxHeader = new long[256];
        for (k = 0; k < this.idxHeader.length; ++k) {
            this.idxHeader[k] = NB.decodeUInt32(fanoutTable, k * 4);
        }
        this.idxdata = new byte[this.idxHeader.length][];
        for (k = 0; k < this.idxHeader.length; ++k) {
            int n = k == 0 ? (int)this.idxHeader[k] : (int)(this.idxHeader[k] - this.idxHeader[k - 1]);
            if (n <= 0) continue;
            long len2 = n * 24;
            if (len2 > 0x7FFFFFF7L) {
                throw new IOException(JGitText.get().indexFileIsTooLargeForJgit);
            }
            this.idxdata[k] = new byte[(int)len2];
            IO.readFully(fd, this.idxdata[k], 0, this.idxdata[k].length);
        }
        this.objectCnt = this.idxHeader[255];
        this.packChecksum = new byte[20];
        IO.readFully(fd, this.packChecksum, 0, this.packChecksum.length);
    }

    @Override
    public long getObjectCount() {
        return this.objectCnt;
    }

    @Override
    public long getOffset64Count() {
        long n64 = 0L;
        for (PackIndex.MutableEntry e : this) {
            if (e.getOffset() < Integer.MAX_VALUE) continue;
            ++n64;
        }
        return n64;
    }

    private int findLevelOne(long nthPosition) {
        int levelOne = Arrays.binarySearch(this.idxHeader, nthPosition + 1L);
        if (levelOne >= 0) {
            long base = this.idxHeader[levelOne];
            while (levelOne > 0 && base == this.idxHeader[levelOne - 1]) {
                --levelOne;
            }
        } else {
            levelOne = -(levelOne + 1);
        }
        return levelOne;
    }

    private int getLevelTwo(long nthPosition, int levelOne) {
        long base = levelOne > 0 ? this.idxHeader[levelOne - 1] : 0L;
        return (int)(nthPosition - base);
    }

    @Override
    public ObjectId getObjectId(long nthPosition) {
        int levelOne = this.findLevelOne(nthPosition);
        int p = this.getLevelTwo(nthPosition, levelOne);
        int dataIdx = PackIndexV1.idOffset(p);
        return ObjectId.fromRaw(this.idxdata[levelOne], dataIdx);
    }

    @Override
    long getOffset(long nthPosition) {
        int levelOne = this.findLevelOne(nthPosition);
        int levelTwo = this.getLevelTwo(nthPosition, levelOne);
        int p = 24 * levelTwo;
        return NB.decodeUInt32(this.idxdata[levelOne], p);
    }

    @Override
    public long findOffset(AnyObjectId objId) {
        int levelOne = objId.getFirstByte();
        byte[] data = this.idxdata[levelOne];
        if (data == null) {
            return -1L;
        }
        int high = data.length / 24;
        int low = 0;
        do {
            int mid;
            int pos;
            int cmp;
            if ((cmp = objId.compareTo(data, pos = PackIndexV1.idOffset(mid = low + high >>> 1))) < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                int b0 = data[pos - 4] & 0xFF;
                int b1 = data[pos - 3] & 0xFF;
                int b2 = data[pos - 2] & 0xFF;
                int b3 = data[pos - 1] & 0xFF;
                return (long)b0 << 24 | (long)(b1 << 16) | (long)(b2 << 8) | (long)b3;
            }
            low = mid + 1;
        } while (low < high);
        return -1L;
    }

    @Override
    public long findCRC32(AnyObjectId objId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasCRC32Support() {
        return false;
    }

    @Override
    public Iterator<PackIndex.MutableEntry> iterator() {
        return new IndexV1Iterator();
    }

    @Override
    public void resolve(Set<ObjectId> matches, AbbreviatedObjectId id2, int matchLimit) throws IOException {
        int max2;
        byte[] data = this.idxdata[id2.getFirstByte()];
        if (data == null) {
            return;
        }
        int high = max2 = data.length / 24;
        int low = 0;
        do {
            int p;
            int cmp;
            if ((cmp = id2.prefixCompare(data, PackIndexV1.idOffset(p = low + high >>> 1))) < 0) {
                high = p;
                continue;
            }
            if (cmp == 0) {
                while (0 < p && id2.prefixCompare(data, PackIndexV1.idOffset(p - 1)) == 0) {
                    --p;
                }
                while (p < max2 && id2.prefixCompare(data, PackIndexV1.idOffset(p)) == 0) {
                    matches.add(ObjectId.fromRaw(data, PackIndexV1.idOffset(p)));
                    if (matches.size() > matchLimit) break;
                    ++p;
                }
                return;
            }
            low = p + 1;
        } while (low < high);
    }

    private static int idOffset(int mid) {
        return 24 * mid + 4;
    }

    private class IndexV1Iterator
    extends PackIndex.EntriesIterator {
        private int levelOne;
        private int levelTwo;

        private IndexV1Iterator() {
        }

        protected PackIndex.MutableEntry initEntry() {
            return new PackIndex.MutableEntry(){

                protected void ensureId() {
                    this.idBuffer.fromRaw(PackIndexV1.this.idxdata[IndexV1Iterator.this.levelOne], IndexV1Iterator.this.levelTwo - 20);
                }
            };
        }

        public PackIndex.MutableEntry next() {
            while (this.levelOne < PackIndexV1.this.idxdata.length) {
                if (PackIndexV1.this.idxdata[this.levelOne] != null) {
                    if (this.levelTwo < PackIndexV1.this.idxdata[this.levelOne].length) {
                        this.entry.offset = NB.decodeUInt32(PackIndexV1.this.idxdata[this.levelOne], this.levelTwo);
                        this.levelTwo += 24;
                        ++this.returnedNumber;
                        return this.entry;
                    }
                    this.levelTwo = 0;
                }
                ++this.levelOne;
            }
            throw new NoSuchElementException();
        }
    }
}

