/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.RefDirectoryRename;
import org.eclipse.jgit.internal.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.internal.storage.file.ReflogWriter;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefWriter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefDirectory
extends RefDatabase {
    public static final String SYMREF = "ref: ";
    public static final String PACKED_REFS_HEADER = "# pack-refs with:";
    public static final String PACKED_REFS_PEELED = " peeled";
    private static final String[] additionalRefsNames = new String[]{"MERGE_HEAD", "FETCH_HEAD", "ORIG_HEAD", "CHERRY_PICK_HEAD"};
    private final FileRepository parent;
    private final File gitDir;
    private final File refsDir;
    private final ReflogWriter logWriter;
    private final File packedRefsFile;
    private final AtomicReference<RefList<LooseRef>> looseRefs = new AtomicReference();
    private final AtomicReference<PackedRefList> packedRefs = new AtomicReference();
    private final AtomicInteger modCnt = new AtomicInteger();
    private final AtomicInteger lastNotifiedModCnt = new AtomicInteger();

    RefDirectory(FileRepository db) {
        FS fs = db.getFS();
        this.parent = db;
        this.gitDir = db.getDirectory();
        this.logWriter = new ReflogWriter(db);
        this.refsDir = fs.resolve(this.gitDir, "refs/");
        this.packedRefsFile = fs.resolve(this.gitDir, "packed-refs");
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(PackedRefList.NO_PACKED_REFS);
    }

    Repository getRepository() {
        return this.parent;
    }

    ReflogWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void create() throws IOException {
        FileUtils.mkdir(this.refsDir);
        FileUtils.mkdir(new File(this.refsDir, "refs/heads/".substring("refs/".length())));
        FileUtils.mkdir(new File(this.refsDir, "refs/tags/".substring("refs/".length())));
        this.logWriter.create();
    }

    @Override
    public void close() {
    }

    void rescan() {
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(PackedRefList.NO_PACKED_REFS);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.rescan();
    }

    @Override
    public boolean isNameConflicting(String name2) throws IOException {
        PackedRefList packed = this.getPackedRefs();
        RefList<LooseRef> loose = this.getLooseRefs();
        int lastSlash = name2.lastIndexOf(47);
        while (0 < lastSlash) {
            String needle = name2.substring(0, lastSlash);
            if (loose.contains(needle) || packed.contains(needle)) {
                return true;
            }
            lastSlash = name2.lastIndexOf(47, lastSlash - 1);
        }
        String prefix = name2 + '/';
        int idx = -(packed.find(prefix) + 1);
        if (idx < packed.size() && packed.get(idx).getName().startsWith(prefix)) {
            return true;
        }
        idx = -(loose.find(prefix) + 1);
        return idx < loose.size() && loose.get(idx).getName().startsWith(prefix);
    }

    private RefList<LooseRef> getLooseRefs() {
        RefList<LooseRef> loose;
        RefList<LooseRef> oldLoose = this.looseRefs.get();
        LooseScanner scan2 = new LooseScanner(oldLoose);
        scan2.scan("");
        if (scan2.newLoose != null) {
            loose = scan2.newLoose.toRefList();
            if (this.looseRefs.compareAndSet(oldLoose, loose)) {
                this.modCnt.incrementAndGet();
            }
        } else {
            loose = oldLoose;
        }
        return loose;
    }

    @Override
    public Ref getRef(String needle) throws IOException {
        PackedRefList packed = this.getPackedRefs();
        Ref ref = null;
        for (String prefix : SEARCH_PATH) {
            try {
                ref = this.readRef(prefix + needle, packed);
                if (ref == null) continue;
                ref = this.resolve(ref, 0, null, null, packed);
                break;
            }
            catch (IOException e) {
                if (!needle.contains("/") && "".equals(prefix) && e.getCause() instanceof InvalidObjectIdException) continue;
                throw e;
            }
        }
        this.fireRefsChanged();
        return ref;
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        RefList<LooseRef> loose;
        PackedRefList packed = this.getPackedRefs();
        RefList<LooseRef> oldLoose = this.looseRefs.get();
        LooseScanner scan2 = new LooseScanner(oldLoose);
        scan2.scan(prefix);
        if (scan2.newLoose != null) {
            scan2.newLoose.sort();
            loose = scan2.newLoose.toRefList();
            if (this.looseRefs.compareAndSet(oldLoose, loose)) {
                this.modCnt.incrementAndGet();
            }
        } else {
            loose = oldLoose;
        }
        this.fireRefsChanged();
        RefList.Builder<Ref> symbolic = scan2.symbolic;
        int idx = 0;
        while (idx < symbolic.size()) {
            Ref symbolicRef = symbolic.get(idx);
            Ref resolvedRef = this.resolve(symbolicRef, 0, prefix, loose, packed);
            if (resolvedRef != null && resolvedRef.getObjectId() != null) {
                symbolic.set(idx, resolvedRef);
                ++idx;
                continue;
            }
            symbolic.remove(idx);
            int toRemove = loose.find(symbolicRef.getName());
            if (0 > toRemove) continue;
            loose = loose.remove(toRemove);
        }
        symbolic.sort();
        return new RefMap(prefix, packed, this.upcast(loose), symbolic.toRefList());
    }

    @Override
    public List<Ref> getAdditionalRefs() throws IOException {
        LinkedList<Ref> ret = new LinkedList<Ref>();
        for (String name2 : additionalRefsNames) {
            Ref r = this.getRef(name2);
            if (r == null) continue;
            ret.add(r);
        }
        return ret;
    }

    private RefList<Ref> upcast(RefList<? extends Ref> loose) {
        return loose;
    }

    @Override
    public Ref peel(Ref ref) throws IOException {
        RefList<LooseRef> curList;
        int idx;
        Ref leaf = ref.getLeaf();
        if (leaf.isPeeled() || leaf.getObjectId() == null) {
            return ref;
        }
        ObjectIdRef newLeaf = this.doPeel(leaf);
        if (leaf.getStorage().isLoose() && 0 <= (idx = (curList = this.looseRefs.get()).find(leaf.getName())) && curList.get(idx) == leaf) {
            LooseRef asPeeled = ((LooseRef)leaf).peel(newLeaf);
            RefList<LooseRef> newList = curList.set(idx, asPeeled);
            this.looseRefs.compareAndSet(curList, newList);
        }
        return RefDirectory.recreate(ref, newLeaf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectIdRef doPeel(Ref leaf) throws MissingObjectException, IOException {
        RevWalk rw;
        block3: {
            rw = new RevWalk(this.getRepository());
            try {
                RevObject obj2 = rw.parseAny(leaf.getObjectId());
                if (!(obj2 instanceof RevTag)) break block3;
                ObjectIdRef.PeeledTag peeledTag = new ObjectIdRef.PeeledTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId(), rw.peel(obj2).copy());
                Object var6_6 = null;
                rw.release();
                return peeledTag;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                rw.release();
                throw throwable;
            }
        }
        ObjectIdRef.PeeledNonTag peeledNonTag = new ObjectIdRef.PeeledNonTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId());
        Object var6_7 = null;
        rw.release();
        return peeledNonTag;
    }

    private static Ref recreate(Ref old, ObjectIdRef leaf) {
        if (old.isSymbolic()) {
            Ref dst = RefDirectory.recreate(old.getTarget(), leaf);
            return new SymbolicRef(old.getName(), dst);
        }
        return leaf;
    }

    void storedSymbolicRef(RefDirectoryUpdate u, FileSnapshot snapshot, String target) {
        this.putLooseRef(RefDirectory.newSymbolicRef(snapshot, u.getRef().getName(), target));
        this.fireRefsChanged();
    }

    @Override
    public RefDirectoryUpdate newUpdate(String name2, boolean detach) throws IOException {
        boolean detachingSymbolicRef = false;
        PackedRefList packed = this.getPackedRefs();
        Ref ref = this.readRef(name2, packed);
        if (ref != null) {
            ref = this.resolve(ref, 0, null, null, packed);
        }
        if (ref == null) {
            ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name2, null);
        } else {
            boolean bl = detachingSymbolicRef = detach && ref.isSymbolic();
            if (detachingSymbolicRef) {
                ref = new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name2, ref.getObjectId());
            }
        }
        RefDirectoryUpdate refDirUpdate = new RefDirectoryUpdate(this, ref);
        if (detachingSymbolicRef) {
            refDirUpdate.setDetachingSymbolicRef();
        }
        return refDirUpdate;
    }

    @Override
    public RefDirectoryRename newRename(String fromName, String toName) throws IOException {
        RefDirectoryUpdate from2 = this.newUpdate(fromName, false);
        RefDirectoryUpdate to2 = this.newUpdate(toName, false);
        return new RefDirectoryRename(from2, to2);
    }

    void stored(RefDirectoryUpdate update2, FileSnapshot snapshot) {
        ObjectId target = update2.getNewObjectId().copy();
        Ref leaf = update2.getRef().getLeaf();
        this.putLooseRef(new LooseUnpeeled(snapshot, leaf.getName(), target));
    }

    private void putLooseRef(LooseRef ref) {
        RefList<LooseRef> nList;
        RefList<LooseRef> cList;
        while (!this.looseRefs.compareAndSet(cList = this.looseRefs.get(), nList = cList.put(ref))) {
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(RefDirectoryUpdate update2) throws IOException {
        RefList<LooseRef> newLoose;
        RefList<LooseRef> curLoose;
        int idx;
        Ref dst = update2.getRef().getLeaf();
        String name2 = dst.getName();
        PackedRefList packed = this.getPackedRefs();
        if (packed.contains(name2)) {
            LockFile lck = new LockFile(this.packedRefsFile, update2.getRepository().getFS());
            if (!lck.lock()) {
                throw new LockFailedException(this.packedRefsFile);
            }
            try {
                PackedRefList cur = this.readPackedRefs();
                idx = cur.find(name2);
                if (0 <= idx) {
                    this.commitPackedRefs(lck, cur.remove(idx), packed);
                }
                Object var9_8 = null;
                lck.unlock();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                lck.unlock();
                throw throwable;
            }
        }
        while ((idx = (curLoose = this.looseRefs.get()).find(name2)) >= 0 && !this.looseRefs.compareAndSet(curLoose, newLoose = curLoose.remove(idx))) {
        }
        int levels = RefDirectory.levelsIn(name2) - 2;
        RefDirectory.delete(this.logWriter.logFor(name2), levels);
        if (dst.getStorage().isLoose()) {
            update2.unlock();
            RefDirectory.delete(this.fileFor(name2), levels);
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(List<String> refs) throws IOException {
        if (refs.size() == 0) {
            return;
        }
        FS fs = this.parent.getFS();
        LockFile lck = new LockFile(this.packedRefsFile, fs);
        if (!lck.lock()) {
            throw new IOException(MessageFormat.format(JGitText.get().cannotLock, this.packedRefsFile));
        }
        try {
            PackedRefList packed = this.getPackedRefs();
            RefList cur = this.readPackedRefs();
            for (String refName : refs) {
                Ref ref = this.readRef(refName, cur);
                if (ref.isSymbolic()) continue;
                int idx = cur.find(refName);
                if (idx >= 0) {
                    cur = cur.set(idx, this.peeledPackedRef(ref));
                    continue;
                }
                cur = cur.add(idx, this.peeledPackedRef(ref));
            }
            this.commitPackedRefs(lck, cur, packed);
            for (String refName : refs) {
                Object var17_17;
                LockFile rLck;
                block13: {
                    File refFile = this.fileFor(refName);
                    if (!fs.exists(refFile) || !(rLck = new LockFile(refFile, this.parent.getFS())).lock()) continue;
                    try {
                        RefList<LooseRef> newLoose;
                        RefList<LooseRef> curLoose;
                        int idx;
                        LooseRef currentLooseRef;
                        block15: {
                            block14: {
                                currentLooseRef = this.scanRef(null, refName);
                                if (currentLooseRef == null) break block14;
                                if (!currentLooseRef.isSymbolic()) break block15;
                            }
                            var17_17 = null;
                            rLck.unlock();
                            continue;
                        }
                        Object packedRef = cur.get(refName);
                        ObjectId clr_oid = currentLooseRef.getObjectId();
                        if (clr_oid == null || !clr_oid.equals(packedRef.getObjectId())) break block13;
                        while ((idx = (curLoose = this.looseRefs.get()).find(refName)) >= 0 && !this.looseRefs.compareAndSet(curLoose, newLoose = curLoose.remove(idx))) {
                        }
                        int levels = RefDirectory.levelsIn(refName) - 2;
                        RefDirectory.delete(this.fileFor(refName), levels);
                    }
                    catch (Throwable throwable) {
                        var17_17 = null;
                        rLck.unlock();
                        throw throwable;
                    }
                }
                var17_17 = null;
                rLck.unlock();
                {
                }
            }
            Object var19_19 = null;
            lck.unlock();
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            lck.unlock();
            throw throwable;
        }
    }

    private Ref peeledPackedRef(Ref f2) throws MissingObjectException, IOException {
        if (f2.getStorage().isPacked() && f2.isPeeled()) {
            return f2;
        }
        if (!f2.isPeeled()) {
            f2 = this.peel(f2);
        }
        if (f2.getPeeledObjectId() != null) {
            return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, f2.getName(), f2.getObjectId(), f2.getPeeledObjectId());
        }
        return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, f2.getName(), f2.getObjectId());
    }

    void log(RefUpdate update2, String msg, boolean deref) throws IOException {
        this.logWriter.log(update2, msg, deref);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Ref resolve(Ref ref, int depth, String prefix, RefList<LooseRef> loose, RefList<Ref> packed) throws IOException {
        if (!ref.isSymbolic()) return ref;
        Ref dst = ref.getTarget();
        if (5 <= depth) {
            return null;
        }
        if (loose != null && dst.getName().startsWith(prefix)) {
            int idx = loose.find(dst.getName());
            if (0 <= idx) {
                dst = loose.get(idx);
            } else {
                idx = packed.find(dst.getName());
                if (0 > idx) return ref;
                dst = packed.get(idx);
            }
        } else if ((dst = this.readRef(dst.getName(), packed)) == null) {
            return ref;
        }
        if ((dst = this.resolve(dst, depth + 1, prefix, loose, packed)) != null) return new SymbolicRef(ref.getName(), dst);
        return null;
    }

    private PackedRefList getPackedRefs() throws IOException {
        PackedRefList curList = this.packedRefs.get();
        if (!curList.snapshot.isModified(this.packedRefsFile)) {
            return curList;
        }
        PackedRefList newList = this.readPackedRefs();
        if (this.packedRefs.compareAndSet(curList, newList) && !curList.id.equals(newList.id)) {
            this.modCnt.incrementAndGet();
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackedRefList readPackedRefs() throws IOException {
        PackedRefList packedRefList;
        BufferedReader br;
        FileSnapshot snapshot = FileSnapshot.save(this.packedRefsFile);
        MessageDigest digest2 = Constants.newMessageDigest();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new DigestInputStream(new FileInputStream(this.packedRefsFile), digest2), Constants.CHARSET));
        }
        catch (FileNotFoundException noPackedRefs) {
            return PackedRefList.NO_PACKED_REFS;
        }
        try {
            packedRefList = new PackedRefList(this.parsePackedRefs(br), snapshot, ObjectId.fromRaw(digest2.digest()));
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            br.close();
            throw throwable;
        }
        br.close();
        return packedRefList;
    }

    private RefList<Ref> parsePackedRefs(BufferedReader br) throws IOException {
        String p;
        RefList.Builder<Ref> all = new RefList.Builder<Ref>();
        Ref last2 = null;
        boolean peeled = false;
        boolean needSort = false;
        while ((p = br.readLine()) != null) {
            if (p.charAt(0) == '#') {
                if (!p.startsWith(PACKED_REFS_HEADER)) continue;
                p = p.substring(PACKED_REFS_HEADER.length());
                peeled = p.contains(PACKED_REFS_PEELED);
                continue;
            }
            if (p.charAt(0) == '^') {
                if (last2 == null) {
                    throw new IOException(JGitText.get().peeledLineBeforeRef);
                }
                ObjectId id2 = ObjectId.fromString(p.substring(1));
                last2 = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last2.getName(), last2.getObjectId(), id2);
                all.set(all.size() - 1, last2);
                continue;
            }
            int sp2 = p.indexOf(32);
            ObjectId id3 = ObjectId.fromString(p.substring(0, sp2));
            String name2 = RefDirectory.copy(p, sp2 + 1, p.length());
            ObjectIdRef cur = peeled ? new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name2, id3) : new ObjectIdRef.Unpeeled(Ref.Storage.PACKED, name2, id3);
            if (last2 != null && RefComparator.compareTo(last2, cur) > 0) {
                needSort = true;
            }
            all.add(cur);
            last2 = cur;
        }
        if (needSort) {
            all.sort();
        }
        return all.toRefList();
    }

    private static String copy(String src, int off, int end2) {
        return new StringBuilder(end2 - off).append(src, off, end2).toString();
    }

    private void commitPackedRefs(final LockFile lck, final RefList<Ref> refs, final PackedRefList oldPackedList) throws IOException {
        new RefWriter(refs){

            protected void writeFile(String name2, byte[] content) throws IOException {
                lck.setFSync(true);
                lck.setNeedSnapshot(true);
                try {
                    lck.write(content);
                }
                catch (IOException ioe) {
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToWrite, name2), ioe);
                }
                try {
                    lck.waitForStatChange();
                }
                catch (InterruptedException e) {
                    lck.unlock();
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().interruptedWriting, name2));
                }
                if (!lck.commit()) {
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToWrite, name2));
                }
                byte[] digest2 = Constants.newMessageDigest().digest(content);
                RefDirectory.this.packedRefs.compareAndSet(oldPackedList, new PackedRefList(refs, lck.getCommitSnapshot(), ObjectId.fromRaw(digest2)));
            }
        }.writePackedRefs();
    }

    private Ref readRef(String name2, RefList<Ref> packed) throws IOException {
        RefList<LooseRef> curList = this.looseRefs.get();
        int idx = curList.find(name2);
        if (0 <= idx) {
            LooseRef o = curList.get(idx);
            LooseRef n = this.scanRef(o, name2);
            if (n == null) {
                if (this.looseRefs.compareAndSet(curList, curList.remove(idx))) {
                    this.modCnt.incrementAndGet();
                }
                return packed.get(name2);
            }
            if (o == n) {
                return n;
            }
            if (this.looseRefs.compareAndSet(curList, curList.set(idx, n))) {
                this.modCnt.incrementAndGet();
            }
            return n;
        }
        LooseRef n = this.scanRef(null, name2);
        if (n == null) {
            return packed.get(name2);
        }
        for (int i = 0; i < additionalRefsNames.length; ++i) {
            if (!name2.equals(additionalRefsNames[i])) continue;
            return n;
        }
        if (this.looseRefs.compareAndSet(curList, curList.add(idx, n))) {
            this.modCnt.incrementAndGet();
        }
        return n;
    }

    private LooseRef scanRef(LooseRef ref, String name2) throws IOException {
        ObjectId id2;
        int n;
        byte[] buf;
        File path2 = this.fileFor(name2);
        FileSnapshot currentSnapshot = null;
        if (ref != null) {
            currentSnapshot = ref.getSnapShot();
            if (!currentSnapshot.isModified(path2)) {
                return ref;
            }
            name2 = ref.getName();
        }
        int limit = 4096;
        FileSnapshot otherSnapshot = FileSnapshot.save(path2);
        try {
            buf = IO.readSome(path2, 4096);
        }
        catch (FileNotFoundException noFile) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        if (RefDirectory.isSymRef(buf, n)) {
            if (n == 4096) {
                return null;
            }
            for (n = buf.length; 0 < n && Character.isWhitespace(buf[n - 1]); --n) {
            }
            if (n < 6) {
                String content = RawParseUtils.decode(buf, 0, n);
                throw new IOException(MessageFormat.format(JGitText.get().notARef, name2, content));
            }
            String target = RawParseUtils.decode(buf, 5, n);
            if (ref != null && ref.isSymbolic() && ref.getTarget().getName().equals(target)) {
                currentSnapshot.setClean(otherSnapshot);
                return ref;
            }
            return RefDirectory.newSymbolicRef(otherSnapshot, name2, target);
        }
        if (n < 40) {
            return null;
        }
        try {
            id2 = ObjectId.fromString(buf, 0);
            if (ref != null && !ref.isSymbolic() && ref.getTarget().getObjectId().equals(id2)) {
                currentSnapshot.setClean(otherSnapshot);
                return ref;
            }
        }
        catch (IllegalArgumentException notRef) {
            while (0 < n && Character.isWhitespace(buf[n - 1])) {
                --n;
            }
            String content = RawParseUtils.decode(buf, 0, n);
            IOException ioException = new IOException(MessageFormat.format(JGitText.get().notARef, name2, content));
            ioException.initCause(notRef);
            throw ioException;
        }
        return new LooseUnpeeled(otherSnapshot, name2, id2);
    }

    private static boolean isSymRef(byte[] buf, int n) {
        if (n < 6) {
            return false;
        }
        return buf[0] == 114 && buf[1] == 101 && buf[2] == 102 && buf[3] == 58 && buf[4] == 32;
    }

    private void fireRefsChanged() {
        int curr;
        int last2 = this.lastNotifiedModCnt.get();
        if (last2 != (curr = this.modCnt.get()) && this.lastNotifiedModCnt.compareAndSet(last2, curr) && last2 != 0) {
            this.parent.fireEvent(new RefsChangedEvent());
        }
    }

    RefDirectoryUpdate newTemporaryUpdate() throws IOException {
        File tmp = File.createTempFile("renamed_", "_ref", this.refsDir);
        String name2 = "refs/" + tmp.getName();
        ObjectIdRef.Unpeeled ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name2, null);
        return new RefDirectoryUpdate(this, ref);
    }

    File fileFor(String name2) {
        if (name2.startsWith("refs/")) {
            name2 = name2.substring("refs/".length());
            return new File(this.refsDir, name2);
        }
        return new File(this.gitDir, name2);
    }

    static int levelsIn(String name2) {
        int count2 = 0;
        int p = name2.indexOf(47);
        while (p >= 0) {
            ++count2;
            p = name2.indexOf(47, p + 1);
        }
        return count2;
    }

    static void delete(File file2, int depth) throws IOException {
        if (!file2.delete() && file2.isFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().fileCannotBeDeleted, file2));
        }
        File dir = file2.getParentFile();
        for (int i = 0; i < depth && dir.delete(); ++i) {
            dir = dir.getParentFile();
        }
    }

    private static LooseSymbolicRef newSymbolicRef(FileSnapshot snapshot, String name2, String target) {
        ObjectIdRef.Unpeeled dst = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
        return new LooseSymbolicRef(snapshot, name2, dst);
    }

    private static final class LooseNonTag
    extends ObjectIdRef.PeeledNonTag
    implements LooseRef {
        private final FileSnapshot snapShot;

        LooseNonTag(FileSnapshot snapshot, String refName, ObjectId id2) {
            super(Ref.Storage.LOOSE, refName, id2);
            this.snapShot = snapshot;
        }

        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        public LooseRef peel(ObjectIdRef newLeaf) {
            return this;
        }
    }

    private static final class LoosePeeledTag
    extends ObjectIdRef.PeeledTag
    implements LooseRef {
        private final FileSnapshot snapShot;

        LoosePeeledTag(FileSnapshot snapshot, String refName, ObjectId id2, ObjectId p) {
            super(Ref.Storage.LOOSE, refName, id2, p);
            this.snapShot = snapshot;
        }

        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        public LooseRef peel(ObjectIdRef newLeaf) {
            return this;
        }
    }

    private static interface LooseRef
    extends Ref {
        public FileSnapshot getSnapShot();

        public LooseRef peel(ObjectIdRef var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LooseScanner {
        private final RefList<LooseRef> curLoose;
        private int curIdx;
        final RefList.Builder<Ref> symbolic = new RefList.Builder(4);
        RefList.Builder<LooseRef> newLoose;

        LooseScanner(RefList<LooseRef> curLoose) {
            this.curLoose = curLoose;
        }

        void scan(String prefix) {
            if ("".equals(prefix)) {
                this.scanOne("HEAD");
                this.scanTree("refs/", RefDirectory.this.refsDir);
                if (this.newLoose == null && this.curIdx < this.curLoose.size()) {
                    this.newLoose = this.curLoose.copy(this.curIdx);
                }
            } else if (prefix.startsWith("refs/") && prefix.endsWith("/")) {
                this.curIdx = -(this.curLoose.find(prefix) + 1);
                File dir = new File(RefDirectory.this.refsDir, prefix.substring("refs/".length()));
                this.scanTree(prefix, dir);
                while (this.curIdx < this.curLoose.size() && this.curLoose.get(this.curIdx).getName().startsWith(prefix)) {
                    if (this.newLoose == null) {
                        this.newLoose = this.curLoose.copy(this.curIdx);
                    }
                    ++this.curIdx;
                }
                if (this.newLoose != null) {
                    while (this.curIdx < this.curLoose.size()) {
                        this.newLoose.add(this.curLoose.get(this.curIdx++));
                    }
                }
            }
        }

        private boolean scanTree(String prefix, File dir) {
            Object[] entries = dir.list(LockFile.FILTER);
            if (entries == null) {
                return false;
            }
            if (0 < entries.length) {
                for (int i = 0; i < entries.length; ++i) {
                    Object e = entries[i];
                    File f2 = new File(dir, (String)e);
                    if (!f2.isDirectory()) continue;
                    int n = i;
                    entries[n] = (String)entries[n] + '/';
                }
                Arrays.sort(entries);
                for (Object name2 : entries) {
                    if (((String)name2).charAt(((String)name2).length() - 1) == '/') {
                        this.scanTree(prefix + (String)name2, new File(dir, (String)name2));
                        continue;
                    }
                    this.scanOne(prefix + (String)name2);
                }
            }
            return true;
        }

        private void scanOne(String name2) {
            LooseRef n;
            LooseRef cur;
            if (this.curIdx < this.curLoose.size()) {
                do {
                    int cmp;
                    if ((cmp = RefComparator.compareTo((Ref)(cur = this.curLoose.get(this.curIdx)), name2)) >= 0) {
                        if (cmp > 0) {
                            cur = null;
                        }
                        break;
                    }
                    if (this.newLoose == null) {
                        this.newLoose = this.curLoose.copy(this.curIdx);
                    }
                    ++this.curIdx;
                    cur = null;
                } while (this.curIdx < this.curLoose.size());
            } else {
                cur = null;
            }
            try {
                n = RefDirectory.this.scanRef(cur, name2);
            }
            catch (IOException notValid) {
                n = null;
            }
            if (n != null) {
                if (cur != n && this.newLoose == null) {
                    this.newLoose = this.curLoose.copy(this.curIdx);
                }
                if (this.newLoose != null) {
                    this.newLoose.add(n);
                }
                if (n.isSymbolic()) {
                    this.symbolic.add(n);
                }
            } else if (cur != null && this.newLoose == null) {
                this.newLoose = this.curLoose.copy(this.curIdx);
            }
            if (cur != null) {
                ++this.curIdx;
            }
        }
    }

    private static final class LooseSymbolicRef
    extends SymbolicRef
    implements LooseRef {
        private final FileSnapshot snapShot;

        LooseSymbolicRef(FileSnapshot snapshot, String refName, Ref target) {
            super(refName, target);
            this.snapShot = snapshot;
        }

        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        public LooseRef peel(ObjectIdRef newLeaf) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LooseUnpeeled
    extends ObjectIdRef.Unpeeled
    implements LooseRef {
        private FileSnapshot snapShot;

        LooseUnpeeled(FileSnapshot snapShot, String refName, ObjectId id2) {
            super(Ref.Storage.LOOSE, refName, id2);
            this.snapShot = snapShot;
        }

        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        public LooseRef peel(ObjectIdRef newLeaf) {
            if (newLeaf.getPeeledObjectId() != null) {
                return new LoosePeeledTag(this.snapShot, this.getName(), this.getObjectId(), newLeaf.getPeeledObjectId());
            }
            return new LooseNonTag(this.snapShot, this.getName(), this.getObjectId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackedRefList
    extends RefList<Ref> {
        static final PackedRefList NO_PACKED_REFS = new PackedRefList(RefList.<Ref>emptyList(), FileSnapshot.MISSING_FILE, ObjectId.zeroId());
        final FileSnapshot snapshot;
        final ObjectId id;

        PackedRefList(RefList<Ref> src, FileSnapshot s2, ObjectId i) {
            super(src);
            this.snapshot = s2;
            this.id = i;
        }
    }
}

