/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import org.eclipse.jgit.internal.storage.pack.DeltaIndex;

class DeltaIndexScanner {
    final int[] table;
    final long[] entries;
    final int[] next;
    final int tableMask;
    private int entryCnt;

    DeltaIndexScanner(byte[] raw2, int len2) {
        len2 -= len2 % 16;
        int worstCaseBlockCnt = len2 / 16;
        if (worstCaseBlockCnt < 1) {
            this.table = new int[0];
            this.tableMask = 0;
            this.entries = new long[0];
            this.next = new int[0];
        } else {
            this.table = new int[DeltaIndexScanner.tableSize(worstCaseBlockCnt)];
            this.tableMask = this.table.length - 1;
            this.entries = new long[1 + worstCaseBlockCnt];
            this.next = new int[this.entries.length];
            this.scan(raw2, len2);
        }
    }

    private void scan(byte[] raw2, int end2) {
        int lastHash = 0;
        int ptr = end2 - 16;
        do {
            int key;
            int tIdx;
            int head2;
            if ((head2 = this.table[tIdx = (key = DeltaIndex.hashBlock(raw2, ptr)) & this.tableMask]) != 0 && lastHash == key) {
                this.entries[head2] = (long)key << 32 | (long)ptr;
            } else {
                int eIdx = ++this.entryCnt;
                this.entries[eIdx] = (long)key << 32 | (long)ptr;
                this.next[eIdx] = head2;
                this.table[tIdx] = eIdx;
            }
            lastHash = key;
        } while (0 <= (ptr -= 16));
    }

    private static int tableSize(int worstCaseBlockCnt) {
        int shift = 32 - Integer.numberOfLeadingZeros(worstCaseBlockCnt);
        int sz = 1 << shift - 1;
        if (sz < worstCaseBlockCnt) {
            sz <<= 1;
        }
        return sz;
    }
}

