/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchRefUpdate {
    private final RefDatabase refdb;
    private final List<ReceiveCommand> commands;
    private boolean allowNonFastForwards;
    private PersonIdent refLogIdent;
    private String refLogMessage;
    private boolean refLogIncludeResult;

    protected BatchRefUpdate(RefDatabase refdb) {
        this.refdb = refdb;
        this.commands = new ArrayList<ReceiveCommand>();
    }

    public boolean isAllowNonFastForwards() {
        return this.allowNonFastForwards;
    }

    public BatchRefUpdate setAllowNonFastForwards(boolean allow) {
        this.allowNonFastForwards = allow;
        return this;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public BatchRefUpdate setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
        return this;
    }

    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    public boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    public BatchRefUpdate setRefLogMessage(String msg, boolean appendStatus) {
        if (msg == null && !appendStatus) {
            this.disableRefLog();
        } else if (msg == null && appendStatus) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = msg;
            this.refLogIncludeResult = appendStatus;
        }
        return this;
    }

    public BatchRefUpdate disableRefLog() {
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
        return this;
    }

    public boolean isRefLogDisabled() {
        return this.refLogMessage == null;
    }

    public List<ReceiveCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public BatchRefUpdate addCommand(ReceiveCommand cmd) {
        this.commands.add(cmd);
        return this;
    }

    public BatchRefUpdate addCommand(ReceiveCommand ... cmd) {
        return this.addCommand(Arrays.asList(cmd));
    }

    public BatchRefUpdate addCommand(Collection<ReceiveCommand> cmd) {
        this.commands.addAll(cmd);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(RevWalk walk2, ProgressMonitor monitor) throws IOException {
        monitor.beginTask(JGitText.get().updatingReferences, this.commands.size());
        ArrayList<ReceiveCommand> commands2 = new ArrayList<ReceiveCommand>(this.commands.size());
        ArrayList<String> namesToCheck = new ArrayList<String>(this.commands.size());
        block16: for (ReceiveCommand cmd : this.commands) {
            try {
                if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                cmd.updateType(walk2);
                switch (cmd.getType()) {
                    case CREATE: {
                        namesToCheck.add(cmd.getRefName());
                        commands2.add(cmd);
                        break;
                    }
                    case UPDATE: 
                    case UPDATE_NONFASTFORWARD: {
                        commands2.add(cmd);
                        break;
                    }
                    case DELETE: {
                        RefUpdate rud = this.newUpdate(cmd);
                        monitor.update(1);
                        cmd.setResult(rud.delete(walk2));
                        continue block16;
                    }
                }
            }
            catch (IOException err2) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, err2.getMessage()));
            }
        }
        if (!commands2.isEmpty()) {
            HashSet<String> takenNames = new HashSet<String>(this.refdb.getRefs("").keySet());
            Collection<String> takenPrefixes = BatchRefUpdate.getTakenPrefixes(takenNames);
            for (ReceiveCommand cmd : commands2) {
                Object var14_15;
                try {
                    block21: {
                        try {
                            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) break block21;
                            cmd.updateType(walk2);
                            RefUpdate ru = this.newUpdate(cmd);
                            block8 : switch (cmd.getType()) {
                                case DELETE: {
                                    break;
                                }
                                case UPDATE: 
                                case UPDATE_NONFASTFORWARD: {
                                    RefUpdate ruu = this.newUpdate(cmd);
                                    cmd.setResult(ruu.update(walk2));
                                    break;
                                }
                                case CREATE: {
                                    for (String prefix : BatchRefUpdate.getPrefixes(cmd.getRefName())) {
                                        if (!takenNames.contains(prefix)) continue;
                                        cmd.setResult(RefUpdate.Result.LOCK_FAILURE);
                                        break block8;
                                    }
                                    if (takenPrefixes.contains(cmd.getRefName())) {
                                        cmd.setResult(RefUpdate.Result.LOCK_FAILURE);
                                        break;
                                    }
                                    ru.setCheckConflicting(false);
                                    BatchRefUpdate.addRefToPrefixes(takenPrefixes, cmd.getRefName());
                                    takenNames.add(cmd.getRefName());
                                    cmd.setResult(ru.update(walk2));
                                    break;
                                }
                            }
                        }
                        catch (IOException err3) {
                            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, err3.getMessage()));
                            var14_15 = null;
                            monitor.update(1);
                            continue;
                        }
                        {
                        }
                    }
                    var14_15 = null;
                    monitor.update(1);
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    monitor.update(1);
                    throw throwable;
                }
            }
        }
        monitor.endTask();
    }

    private static Collection<String> getTakenPrefixes(Collection<String> names) {
        HashSet<String> ref = new HashSet<String>();
        for (String name2 : names) {
            ref.addAll(BatchRefUpdate.getPrefixes(name2));
        }
        return ref;
    }

    private static void addRefToPrefixes(Collection<String> prefixes, String name2) {
        for (String prefix : BatchRefUpdate.getPrefixes(name2)) {
            prefixes.add(prefix);
        }
    }

    static Collection<String> getPrefixes(String s2) {
        HashSet<String> ret = new HashSet<String>();
        int p1 = s2.indexOf(47);
        while (p1 > 0) {
            ret.add(s2.substring(0, p1));
            p1 = s2.indexOf(47, p1 + 1);
        }
        return ret;
    }

    protected RefUpdate newUpdate(ReceiveCommand cmd) throws IOException {
        RefUpdate ru = this.refdb.newUpdate(cmd.getRefName(), false);
        if (this.isRefLogDisabled()) {
            ru.disableRefLog();
        } else {
            ru.setRefLogIdent(this.refLogIdent);
            ru.setRefLogMessage(this.refLogMessage, this.refLogIncludeResult);
        }
        switch (cmd.getType()) {
            case DELETE: {
                if (!ObjectId.zeroId().equals(cmd.getOldId())) {
                    ru.setExpectedOldObjectId(cmd.getOldId());
                }
                ru.setForceUpdate(true);
                return ru;
            }
        }
        ru.setForceUpdate(this.isAllowNonFastForwards());
        ru.setExpectedOldObjectId(cmd.getOldId());
        ru.setNewObjectId(cmd.getNewId());
        return ru;
    }
}

