/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotWalk
extends RevWalk {
    private Map<AnyObjectId, Set<Ref>> reverseRefMap;

    @Override
    public void dispose() {
        super.dispose();
        this.reverseRefMap.clear();
    }

    public PlotWalk(Repository repo) {
        super(repo);
        super.sort(RevSort.TOPO, true);
        this.reverseRefMap = repo.getAllRefsByPeeledObjectId();
    }

    public void addAdditionalRefs(Iterable<Ref> refs) throws IOException {
        for (Ref ref : refs) {
            Set<Ref> set2 = this.reverseRefMap.get(ref.getObjectId());
            if (set2 == null) {
                set2 = Collections.singleton(ref);
            } else {
                set2 = new HashSet<Ref>(set2);
                set2.add(ref);
            }
            this.reverseRefMap.put(ref.getObjectId(), set2);
        }
    }

    @Override
    public void sort(RevSort s2, boolean use) {
        if (s2 == RevSort.TOPO && !use) {
            throw new IllegalArgumentException(JGitText.get().topologicalSortRequired);
        }
        super.sort(s2, use);
    }

    @Override
    protected RevCommit createCommit(AnyObjectId id2) {
        return new PlotCommit(id2);
    }

    @Override
    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        PlotCommit pc = (PlotCommit)super.next();
        if (pc != null) {
            pc.refs = this.getRefs(pc);
        }
        return pc;
    }

    private Ref[] getRefs(AnyObjectId commitId) {
        Collection list2 = this.reverseRefMap.get(commitId);
        if (list2 == null) {
            return PlotCommit.NO_REFS;
        }
        Ref[] tags = list2.toArray(new Ref[list2.size()]);
        Arrays.sort(tags, new PlotRefComparator());
        return tags;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PlotRefComparator
    implements Comparator<Ref> {
        PlotRefComparator() {
        }

        @Override
        public int compare(Ref o1, Ref o2) {
            try {
                RevObject obj1 = PlotWalk.this.parseAny(o1.getObjectId());
                RevObject obj2 = PlotWalk.this.parseAny(o2.getObjectId());
                long t1 = this.timeof(obj1);
                long t2 = this.timeof(obj2);
                if (t1 > t2) {
                    return -1;
                }
                if (t1 < t2) {
                    return 1;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            int cmp = this.kind(o1) - this.kind(o2);
            if (cmp == 0) {
                cmp = o1.getName().compareTo(o2.getName());
            }
            return cmp;
        }

        long timeof(RevObject o) {
            if (o instanceof RevCommit) {
                return ((RevCommit)o).getCommitTime();
            }
            if (o instanceof RevTag) {
                RevTag tag = (RevTag)o;
                try {
                    PlotWalk.this.parseBody(tag);
                }
                catch (IOException e) {
                    return 0L;
                }
                PersonIdent who = tag.getTaggerIdent();
                return who != null ? who.getWhen().getTime() : 0L;
            }
            return 0L;
        }

        int kind(Ref r) {
            if (r.getName().startsWith("refs/tags/")) {
                return 0;
            }
            if (r.getName().startsWith("refs/heads/")) {
                return 1;
            }
            if (r.getName().startsWith("refs/remotes/")) {
                return 2;
            }
            return 3;
        }
    }
}

