/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;

public interface DepthWalk {
    public int getDepth();

    public RevFlag getUnshallowFlag();

    public RevFlag getReinterestingFlag();

    public static class Commit
    extends RevCommit {
        int depth = -1;

        public int getDepth() {
            return this.depth;
        }

        protected Commit(AnyObjectId id2) {
            super(id2);
        }
    }

    public static class ObjectWalk
    extends org.eclipse.jgit.revwalk.ObjectWalk
    implements DepthWalk {
        private final int depth;
        private final RevFlag UNSHALLOW;
        private final RevFlag REINTERESTING;

        public ObjectWalk(Repository repo, int depth) {
            super(repo);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public ObjectWalk(ObjectReader or2, int depth) {
            super(or2);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public void markRoot(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            RevObject c = o;
            while (c instanceof RevTag) {
                c = ((RevTag)c).getObject();
                this.parseHeaders(c);
            }
            if (c instanceof Commit) {
                ((Commit)c).depth = 0;
            }
            super.markStart(o);
        }

        public void markUnshallow(RevObject c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            if (c instanceof RevCommit) {
                c.add(this.UNSHALLOW);
            }
            super.markStart(c);
        }

        protected RevCommit createCommit(AnyObjectId id2) {
            return new Commit(id2);
        }

        public int getDepth() {
            return this.depth;
        }

        public RevFlag getUnshallowFlag() {
            return this.UNSHALLOW;
        }

        public RevFlag getReinterestingFlag() {
            return this.REINTERESTING;
        }
    }

    public static class RevWalk
    extends org.eclipse.jgit.revwalk.RevWalk
    implements DepthWalk {
        private final int depth;
        private final RevFlag UNSHALLOW;
        private final RevFlag REINTERESTING;

        public RevWalk(Repository repo, int depth) {
            super(repo);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public RevWalk(ObjectReader or2, int depth) {
            super(or2);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public void markRoot(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            if (c instanceof Commit) {
                ((Commit)c).depth = 0;
            }
            super.markStart(c);
        }

        protected RevCommit createCommit(AnyObjectId id2) {
            return new Commit(id2);
        }

        public int getDepth() {
            return this.depth;
        }

        public RevFlag getUnshallowFlag() {
            return this.UNSHALLOW;
        }

        public RevFlag getReinterestingFlag() {
            return this.REINTERESTING;
        }
    }
}

