/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.StartGenerator;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevWalk
implements Iterable<RevCommit> {
    private static final int MB = 0x100000;
    static final int PARSED = 1;
    static final int SEEN = 2;
    static final int UNINTERESTING = 4;
    static final int REWRITE = 8;
    static final int TEMP_MARK = 16;
    static final int TOPO_DELAY = 32;
    static final int RESERVED_FLAGS = 6;
    private static final int APP_FLAGS = -64;
    final ObjectReader reader;
    final MutableObjectId idBuffer;
    ObjectIdOwnerMap<RevObject> objects;
    private int freeFlags = -64;
    private int delayFreeFlags;
    private int retainOnReset;
    int carryFlags = 4;
    final ArrayList<RevCommit> roots;
    AbstractRevQueue queue;
    Generator pending;
    private final EnumSet<RevSort> sorting;
    private RevFilter filter;
    private TreeFilter treeFilter;
    private boolean retainBody;
    private boolean rewriteParents = true;
    boolean shallowCommitsInitialized;

    public RevWalk(Repository repo) {
        this(repo.newObjectReader());
    }

    public RevWalk(ObjectReader or2) {
        this.reader = or2;
        this.idBuffer = new MutableObjectId();
        this.objects = new ObjectIdOwnerMap();
        this.roots = new ArrayList();
        this.queue = new DateRevQueue();
        this.pending = new StartGenerator(this);
        this.sorting = EnumSet.of(RevSort.NONE);
        this.filter = RevFilter.ALL;
        this.treeFilter = TreeFilter.ALL;
        this.retainBody = true;
    }

    public ObjectReader getObjectReader() {
        return this.reader;
    }

    public void release() {
        this.reader.release();
    }

    public void markStart(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if ((c.flags & 2) != 0) {
            return;
        }
        if ((c.flags & 1) == 0) {
            c.parseHeaders(this);
        }
        c.flags |= 2;
        this.roots.add(c);
        this.queue.add(c);
    }

    public void markStart(Collection<RevCommit> list2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        for (RevCommit c : list2) {
            this.markStart(c);
        }
    }

    public void markUninteresting(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        c.flags |= 4;
        this.carryFlagsImpl(c);
        this.markStart(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMergedInto(RevCommit base, RevCommit tip) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevFilter oldRF = this.filter;
        TreeFilter oldTF = this.treeFilter;
        try {
            RevCommit mergeBase;
            this.finishDelayedFreeFlags();
            this.reset(~this.freeFlags & 0xFFFFFFC0);
            this.filter = RevFilter.MERGE_BASE;
            this.treeFilter = TreeFilter.ALL;
            this.markStart(tip);
            this.markStart(base);
            while ((mergeBase = this.next()) != null) {
                if (mergeBase != base) continue;
                boolean bl = true;
                Object var8_8 = null;
                this.filter = oldRF;
                this.treeFilter = oldTF;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.filter = oldRF;
            this.treeFilter = oldTF;
            throw throwable;
        }
        boolean bl = false;
        Object var8_9 = null;
        this.filter = oldRF;
        this.treeFilter = oldTF;
        return bl;
    }

    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.pending.next();
    }

    public EnumSet<RevSort> getRevSort() {
        return this.sorting.clone();
    }

    public boolean hasRevSort(RevSort sort2) {
        return this.sorting.contains((Object)sort2);
    }

    public void sort(RevSort s2) {
        this.assertNotStarted();
        this.sorting.clear();
        this.sorting.add(s2);
    }

    public void sort(RevSort s2, boolean use) {
        this.assertNotStarted();
        if (use) {
            this.sorting.add(s2);
        } else {
            this.sorting.remove((Object)s2);
        }
        if (this.sorting.size() > 1) {
            this.sorting.remove((Object)RevSort.NONE);
        } else if (this.sorting.size() == 0) {
            this.sorting.add(RevSort.NONE);
        }
    }

    public RevFilter getRevFilter() {
        return this.filter;
    }

    public void setRevFilter(RevFilter newFilter) {
        this.assertNotStarted();
        this.filter = newFilter != null ? newFilter : RevFilter.ALL;
    }

    public TreeFilter getTreeFilter() {
        return this.treeFilter;
    }

    public void setTreeFilter(TreeFilter newFilter) {
        this.assertNotStarted();
        this.treeFilter = newFilter != null ? newFilter : TreeFilter.ALL;
    }

    public void setRewriteParents(boolean rewrite) {
        this.rewriteParents = rewrite;
    }

    boolean getRewriteParents() {
        return this.rewriteParents;
    }

    public boolean isRetainBody() {
        return this.retainBody;
    }

    public void setRetainBody(boolean retain2) {
        this.retainBody = retain2;
    }

    public RevBlob lookupBlob(AnyObjectId id2) {
        RevBlob c = (RevBlob)this.objects.get(id2);
        if (c == null) {
            c = new RevBlob(id2);
            this.objects.add(c);
        }
        return c;
    }

    public RevTree lookupTree(AnyObjectId id2) {
        RevTree c = (RevTree)this.objects.get(id2);
        if (c == null) {
            c = new RevTree(id2);
            this.objects.add(c);
        }
        return c;
    }

    public RevCommit lookupCommit(AnyObjectId id2) {
        RevCommit c = (RevCommit)this.objects.get(id2);
        if (c == null) {
            c = this.createCommit(id2);
            this.objects.add(c);
        }
        return c;
    }

    public RevTag lookupTag(AnyObjectId id2) {
        RevTag c = (RevTag)this.objects.get(id2);
        if (c == null) {
            c = new RevTag(id2);
            this.objects.add(c);
        }
        return c;
    }

    public RevObject lookupAny(AnyObjectId id2, int type) {
        RevObject r = this.objects.get(id2);
        if (r == null) {
            switch (type) {
                case 1: {
                    r = this.createCommit(id2);
                    break;
                }
                case 2: {
                    r = new RevTree(id2);
                    break;
                }
                case 3: {
                    r = new RevBlob(id2);
                    break;
                }
                case 4: {
                    r = new RevTag(id2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidGitType, type));
                }
            }
            this.objects.add(r);
        }
        return r;
    }

    public RevObject lookupOrNull(AnyObjectId id2) {
        return this.objects.get(id2);
    }

    public RevCommit parseCommit(AnyObjectId id2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject c = this.peel(this.parseAny(id2));
        if (!(c instanceof RevCommit)) {
            throw new IncorrectObjectTypeException(id2.toObjectId(), "commit");
        }
        return (RevCommit)c;
    }

    public RevTree parseTree(AnyObjectId id2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevTree t;
        RevObject c = this.peel(this.parseAny(id2));
        if (c instanceof RevCommit) {
            t = ((RevCommit)c).getTree();
        } else {
            if (!(c instanceof RevTree)) {
                throw new IncorrectObjectTypeException(id2.toObjectId(), "tree");
            }
            t = (RevTree)c;
        }
        this.parseHeaders(t);
        return t;
    }

    public RevTag parseTag(AnyObjectId id2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject c = this.parseAny(id2);
        if (!(c instanceof RevTag)) {
            throw new IncorrectObjectTypeException(id2.toObjectId(), "tag");
        }
        return (RevTag)c;
    }

    public RevObject parseAny(AnyObjectId id2) throws MissingObjectException, IOException {
        RevObject r = this.objects.get(id2);
        if (r == null) {
            r = this.parseNew(id2, this.reader.open(id2));
        } else {
            this.parseHeaders(r);
        }
        return r;
    }

    private RevObject parseNew(AnyObjectId id2, ObjectLoader ldr) throws LargeObjectException, CorruptObjectException, MissingObjectException, IOException {
        RevObject r;
        int type = ldr.getType();
        switch (type) {
            case 1: {
                RevCommit c = this.createCommit(id2);
                c.parseCanonical(this, this.getCachedBytes(c, ldr));
                r = c;
                break;
            }
            case 2: {
                r = new RevTree(id2);
                r.flags |= 1;
                break;
            }
            case 3: {
                r = new RevBlob(id2);
                r.flags |= 1;
                break;
            }
            case 4: {
                RevTag t = new RevTag(id2);
                t.parseCanonical(this, this.getCachedBytes(t, ldr));
                r = t;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, type));
            }
        }
        this.objects.add(r);
        return r;
    }

    byte[] getCachedBytes(RevObject obj2) throws LargeObjectException, MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.getCachedBytes(obj2, this.reader.open(obj2, obj2.getType()));
    }

    byte[] getCachedBytes(RevObject obj2, ObjectLoader ldr) throws LargeObjectException, MissingObjectException, IOException {
        try {
            return ldr.getCachedBytes(0x500000);
        }
        catch (LargeObjectException tooBig) {
            tooBig.setObjectId(obj2);
            throw tooBig;
        }
    }

    public <T extends ObjectId> AsyncRevObjectQueue parseAny(Iterable<T> objectIds, boolean reportMissing) {
        ArrayList<ObjectId> need = new ArrayList<ObjectId>();
        ArrayList<RevObject> have = new ArrayList<RevObject>();
        for (ObjectId id2 : objectIds) {
            RevObject r = this.objects.get(id2);
            if (r != null && (r.flags & 1) != 0) {
                have.add(r);
                continue;
            }
            need.add(id2);
        }
        final Iterator objItr = have.iterator();
        if (need.isEmpty()) {
            return new AsyncRevObjectQueue(){

                public RevObject next() {
                    return objItr.hasNext() ? (RevObject)objItr.next() : null;
                }

                public boolean cancel(boolean mayInterruptIfRunning) {
                    return true;
                }

                public void release() {
                }
            };
        }
        final AsyncObjectLoaderQueue lItr = this.reader.open(need, reportMissing);
        return new AsyncRevObjectQueue(){

            public RevObject next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
                if (objItr.hasNext()) {
                    return (RevObject)objItr.next();
                }
                if (!lItr.next()) {
                    return null;
                }
                ObjectId id2 = lItr.getObjectId();
                ObjectLoader ldr = lItr.open();
                RevObject r = RevWalk.this.objects.get(id2);
                if (r == null) {
                    r = RevWalk.this.parseNew(id2, ldr);
                } else if (r instanceof RevCommit) {
                    byte[] raw2 = ldr.getCachedBytes();
                    ((RevCommit)r).parseCanonical(RevWalk.this, raw2);
                } else if (r instanceof RevTag) {
                    byte[] raw3 = ldr.getCachedBytes();
                    ((RevTag)r).parseCanonical(RevWalk.this, raw3);
                } else {
                    r.flags |= 1;
                }
                return r;
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                return lItr.cancel(mayInterruptIfRunning);
            }

            public void release() {
                lItr.release();
            }
        };
    }

    public void parseHeaders(RevObject obj2) throws MissingObjectException, IOException {
        if ((obj2.flags & 1) == 0) {
            obj2.parseHeaders(this);
        }
    }

    public void parseBody(RevObject obj2) throws MissingObjectException, IOException {
        obj2.parseBody(this);
    }

    public RevObject peel(RevObject obj2) throws MissingObjectException, IOException {
        while (obj2 instanceof RevTag) {
            this.parseHeaders(obj2);
            obj2 = ((RevTag)obj2).getObject();
        }
        this.parseHeaders(obj2);
        return obj2;
    }

    public RevFlag newFlag(String name2) {
        int m = this.allocFlag();
        return new RevFlag(this, name2, m);
    }

    int allocFlag() {
        if (this.freeFlags == 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagsAlreadyCreated, 26));
        }
        int m = Integer.lowestOneBit(this.freeFlags);
        this.freeFlags &= ~m;
        return m;
    }

    public void carry(RevFlag flag) {
        if ((this.freeFlags & flag.mask) != 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagIsDisposed, flag.name));
        }
        if (flag.walker != this) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagNotFromThis, flag.name));
        }
        this.carryFlags |= flag.mask;
    }

    public void carry(Collection<RevFlag> set2) {
        for (RevFlag flag : set2) {
            this.carry(flag);
        }
    }

    public final void retainOnReset(RevFlag flag) {
        if ((this.freeFlags & flag.mask) != 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagIsDisposed, flag.name));
        }
        if (flag.walker != this) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagNotFromThis, flag.name));
        }
        this.retainOnReset |= flag.mask;
    }

    public final void retainOnReset(Collection<RevFlag> flags) {
        for (RevFlag f2 : flags) {
            this.retainOnReset(f2);
        }
    }

    public void disposeFlag(RevFlag flag) {
        this.freeFlag(flag.mask);
    }

    void freeFlag(int mask) {
        this.retainOnReset &= ~mask;
        if (this.isNotStarted()) {
            this.freeFlags |= mask;
            this.carryFlags &= ~mask;
        } else {
            this.delayFreeFlags |= mask;
        }
    }

    private void finishDelayedFreeFlags() {
        if (this.delayFreeFlags != 0) {
            this.freeFlags |= this.delayFreeFlags;
            this.carryFlags &= ~this.delayFreeFlags;
            this.delayFreeFlags = 0;
        }
    }

    public final void reset() {
        this.reset(0);
    }

    public final void resetRetain(RevFlagSet retainFlags) {
        this.reset(retainFlags.mask);
    }

    public final void resetRetain(RevFlag ... retainFlags) {
        int mask = 0;
        for (RevFlag flag : retainFlags) {
            mask |= flag.mask;
        }
        this.reset(mask);
    }

    protected void reset(int retainFlags) {
        RevCommit c;
        this.finishDelayedFreeFlags();
        int clearFlags = ~(retainFlags |= 1 | this.retainOnReset);
        FIFORevQueue q = new FIFORevQueue();
        for (RevCommit c2 : this.roots) {
            if ((c2.flags & clearFlags) == 0) continue;
            c2.flags &= retainFlags;
            c2.reset();
            q.add(c2);
        }
        while ((c = q.next()) != null) {
            if (c.parents == null) continue;
            for (RevCommit p : c.parents) {
                if ((p.flags & clearFlags) == 0) continue;
                p.flags &= retainFlags;
                p.reset();
                q.add(p);
            }
        }
        this.roots.clear();
        this.queue = new DateRevQueue();
        this.pending = new StartGenerator(this);
    }

    public void dispose() {
        this.reader.release();
        this.freeFlags = -64;
        this.delayFreeFlags = 0;
        this.retainOnReset = 0;
        this.carryFlags = 4;
        this.objects.clear();
        this.reader.release();
        this.roots.clear();
        this.queue = new DateRevQueue();
        this.pending = new StartGenerator(this);
        this.shallowCommitsInitialized = false;
    }

    @Override
    public Iterator<RevCommit> iterator() {
        RevCommit first;
        try {
            first = this.next();
        }
        catch (MissingObjectException e) {
            throw new RevWalkException(e);
        }
        catch (IncorrectObjectTypeException e) {
            throw new RevWalkException(e);
        }
        catch (IOException e) {
            throw new RevWalkException(e);
        }
        return new Iterator<RevCommit>(){
            RevCommit next;
            {
                this.next = first;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public RevCommit next() {
                try {
                    RevCommit r = this.next;
                    this.next = RevWalk.this.next();
                    return r;
                }
                catch (MissingObjectException e) {
                    throw new RevWalkException(e);
                }
                catch (IncorrectObjectTypeException e) {
                    throw new RevWalkException(e);
                }
                catch (IOException e) {
                    throw new RevWalkException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void assertNotStarted() {
        if (this.isNotStarted()) {
            return;
        }
        throw new IllegalStateException(JGitText.get().outputHasAlreadyBeenStarted);
    }

    private boolean isNotStarted() {
        return this.pending instanceof StartGenerator;
    }

    public ObjectWalk toObjectWalkWithSameObjects() {
        ObjectWalk ow;
        ObjectWalk rw = ow = new ObjectWalk(this.reader);
        rw.objects = this.objects;
        rw.freeFlags = this.freeFlags;
        return ow;
    }

    protected RevCommit createCommit(AnyObjectId id2) {
        return new RevCommit(id2);
    }

    void carryFlagsImpl(RevCommit c) {
        int carry = c.flags & this.carryFlags;
        if (carry != 0) {
            RevCommit.carryFlags(c, carry);
        }
    }

    public void assumeShallow(Collection<? extends ObjectId> ids) {
        for (ObjectId objectId : ids) {
            this.lookupCommit((AnyObjectId)objectId).parents = RevCommit.NO_PARENTS;
        }
    }

    void initializeShallowCommits() throws IOException {
        if (this.shallowCommitsInitialized) {
            throw new IllegalStateException(JGitText.get().shallowCommitsAlreadyInitialized);
        }
        this.shallowCommitsInitialized = true;
        if (this.reader == null) {
            return;
        }
        for (ObjectId id2 : this.reader.getShallowCommits()) {
            this.lookupCommit((AnyObjectId)id2).parents = RevCommit.NO_PARENTS;
        }
    }
}

