/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RevWalkUtils {
    private RevWalkUtils() {
    }

    public static int count(RevWalk walk2, RevCommit start2, RevCommit end2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.find(walk2, start2, end2).size();
    }

    public static List<RevCommit> find(RevWalk walk2, RevCommit start2, RevCommit end2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        walk2.reset();
        walk2.markStart(start2);
        if (end2 != null) {
            walk2.markUninteresting(end2);
        }
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        for (RevCommit c : walk2) {
            commits.add(c);
        }
        return commits;
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit2, RevWalk revWalk, Collection<Ref> refs) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        commit2 = revWalk.parseCommit(commit2.getId());
        revWalk.reset();
        ArrayList<Ref> result2 = new ArrayList<Ref>();
        int SKEW = 86400;
        for (Ref ref : refs) {
            RevCommit headCommit;
            RevObject maybehead = revWalk.parseAny(ref.getObjectId());
            if (!(maybehead instanceof RevCommit) || (headCommit = (RevCommit)maybehead).getCommitTime() + 86400 < commit2.getCommitTime() || !revWalk.isMergedInto(commit2, headCommit)) continue;
            result2.add(ref);
        }
        return result2;
    }
}

