/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class PatternMatchRevFilter
extends RevFilter {
    private final String patternText;
    private final Matcher compiledPattern;

    protected static final String forceToRaw(String patternText) {
        byte[] b = Constants.encode(patternText);
        StringBuilder needle = new StringBuilder(b.length);
        for (int i = 0; i < b.length; ++i) {
            needle.append((char)(b[i] & 0xFF));
        }
        return needle.toString();
    }

    protected PatternMatchRevFilter(String pattern2, boolean innerString, boolean rawEncoding, int flags) {
        if (pattern2.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.patternText = pattern2;
        if (innerString) {
            if (!pattern2.startsWith("^") && !pattern2.startsWith(".*")) {
                pattern2 = ".*" + pattern2;
            }
            if (!pattern2.endsWith("$") && !pattern2.endsWith(".*")) {
                pattern2 = pattern2 + ".*";
            }
        }
        String p = rawEncoding ? PatternMatchRevFilter.forceToRaw(pattern2) : pattern2;
        this.compiledPattern = Pattern.compile(p, flags).matcher("");
    }

    public String pattern() {
        return this.patternText;
    }

    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.compiledPattern.reset(this.text(cmit)).matches();
    }

    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract CharSequence text(RevCommit var1);

    public String toString() {
        return super.toString() + "(\"" + this.patternText + "\")";
    }
}

