/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FetchHeadRecord;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FetchProcess {
    private final Transport transport;
    private final Collection<RefSpec> toFetch;
    private final HashMap<ObjectId, Ref> askFor = new HashMap();
    private final HashSet<ObjectId> have = new HashSet();
    private final ArrayList<TrackingRefUpdate> localUpdates = new ArrayList();
    private final ArrayList<FetchHeadRecord> fetchHeadUpdates = new ArrayList();
    private final ArrayList<PackLock> packLocks = new ArrayList();
    private FetchConnection conn;
    private Map<String, Ref> localRefs;

    FetchProcess(Transport t, Collection<RefSpec> f2) {
        this.transport = t;
        this.toFetch = f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void execute(ProgressMonitor monitor, FetchResult result2) throws NotSupportedException, TransportException {
        block7: {
            this.askFor.clear();
            this.localUpdates.clear();
            this.fetchHeadUpdates.clear();
            this.packLocks.clear();
            this.localRefs = null;
            this.executeImp(monitor, result2);
            Object var4_3 = null;
            try {
                for (PackLock lock : this.packLocks) {
                    lock.unlock();
                }
            }
            catch (IOException e) {
                throw new TransportException(e.getMessage(), e);
            }
            break block7;
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    for (PackLock lock : this.packLocks) {
                        lock.unlock();
                    }
                }
                catch (IOException e) {
                    throw new TransportException(e.getMessage(), e);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeImp(ProgressMonitor monitor, FetchResult result2) throws NotSupportedException, TransportException {
        this.conn = this.transport.openFetch();
        try {
            boolean includedTags;
            result2.setAdvertisedRefs(this.transport.getURI(), this.conn.getRefsMap());
            HashSet<Ref> matched = new HashSet<Ref>();
            for (RefSpec spec : this.toFetch) {
                if (spec.getSource() == null) {
                    throw new TransportException(MessageFormat.format(JGitText.get().sourceRefNotSpecifiedForRefspec, spec));
                }
                if (spec.isWildcard()) {
                    this.expandWildcard(spec, matched);
                    continue;
                }
                this.expandSingle(spec, matched);
            }
            Collection<Object> additionalTags = Collections.emptyList();
            TagOpt tagopt = this.transport.getTagOpt();
            if (tagopt == TagOpt.AUTO_FOLLOW) {
                additionalTags = this.expandAutoFollowTags();
            } else if (tagopt == TagOpt.FETCH_TAGS) {
                this.expandFetchTags();
            }
            if (!this.askFor.isEmpty() && !this.askForIsComplete()) {
                this.fetchObjects(monitor);
                includedTags = this.conn.didFetchIncludeTags();
                this.closeConnection(result2);
            } else {
                includedTags = false;
            }
            if (tagopt == TagOpt.AUTO_FOLLOW && !additionalTags.isEmpty()) {
                this.have.addAll(this.askFor.keySet());
                this.askFor.clear();
                for (Ref ref : additionalTags) {
                    ObjectId id2 = ref.getPeeledObjectId();
                    if (id2 == null) {
                        id2 = ref.getObjectId();
                    }
                    if (!this.transport.local.hasObject(id2)) continue;
                    this.wantTag(ref);
                }
                if (!(this.askFor.isEmpty() || includedTags && this.askForIsComplete())) {
                    this.reopenConnection();
                    if (!this.askFor.isEmpty()) {
                        this.fetchObjects(monitor);
                    }
                }
            }
            Object var11_15 = null;
            this.closeConnection(result2);
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.closeConnection(result2);
            throw throwable;
        }
        BatchRefUpdate batch = this.transport.local.getRefDatabase().newBatchUpdate().setAllowNonFastForwards(true).setRefLogMessage("fetch", true);
        RevWalk walk2 = new RevWalk(this.transport.local);
        try {
            block28: {
                try {
                    if (monitor instanceof BatchingProgressMonitor) {
                        ((BatchingProgressMonitor)monitor).setDelayStart(250L, TimeUnit.MILLISECONDS);
                    }
                    if (this.transport.isRemoveDeletedRefs()) {
                        this.deleteStaleTrackingRefs(result2, batch);
                    }
                    for (TrackingRefUpdate u : this.localUpdates) {
                        result2.add(u);
                        batch.addCommand(u.asReceiveCommand());
                    }
                    for (ReceiveCommand cmd : batch.getCommands()) {
                        cmd.updateType(walk2);
                        if (cmd.getType() != ReceiveCommand.Type.UPDATE_NONFASTFORWARD || !(cmd instanceof TrackingRefUpdate.Command) || ((TrackingRefUpdate.Command)cmd).canForceUpdate()) continue;
                        cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                    }
                    if (this.transport.isDryRun()) {
                        for (ReceiveCommand cmd : batch.getCommands()) {
                            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                            cmd.setResult(ReceiveCommand.Result.OK);
                        }
                        break block28;
                    }
                    batch.execute(walk2, monitor);
                }
                catch (IOException err2) {
                    throw new TransportException(MessageFormat.format(JGitText.get().failureUpdatingTrackingRef, FetchProcess.getFirstFailedRefName(batch), err2.getMessage()), err2);
                }
            }
            Object var13_18 = null;
            walk2.release();
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            walk2.release();
            throw throwable;
        }
        if (!this.fetchHeadUpdates.isEmpty()) {
            try {
                this.updateFETCH_HEAD(result2);
            }
            catch (IOException err3) {
                throw new TransportException(MessageFormat.format(JGitText.get().failureUpdatingFETCH_HEAD, err3.getMessage()), err3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchObjects(ProgressMonitor monitor) throws TransportException {
        try {
            this.conn.setPackLockMessage("jgit fetch " + this.transport.uri);
            this.conn.fetch(monitor, this.askFor.values(), this.have);
            Object var3_2 = null;
            this.packLocks.addAll(this.conn.getPackLocks());
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.packLocks.addAll(this.conn.getPackLocks());
            throw throwable;
        }
        if (this.transport.isCheckFetchedObjects() && !this.conn.didFetchTestConnectivity() && !this.askForIsComplete()) {
            throw new TransportException(this.transport.getURI(), JGitText.get().peerDidNotSupplyACompleteObjectGraph);
        }
    }

    private void closeConnection(FetchResult result2) {
        if (this.conn != null) {
            this.conn.close();
            result2.addMessages(this.conn.getMessages());
            this.conn = null;
        }
    }

    private void reopenConnection() throws NotSupportedException, TransportException {
        if (this.conn != null) {
            return;
        }
        this.conn = this.transport.openFetch();
        HashMap<ObjectId, Ref> avail = new HashMap<ObjectId, Ref>();
        for (Ref r : this.conn.getRefs()) {
            avail.put(r.getObjectId(), r);
        }
        ArrayList<Ref> wants = new ArrayList<Ref>(this.askFor.values());
        this.askFor.clear();
        for (Ref want : wants) {
            Ref newRef = (Ref)avail.get(want.getObjectId());
            if (newRef != null) {
                this.askFor.put(newRef.getObjectId(), newRef);
                continue;
            }
            this.removeFetchHeadRecord(want.getObjectId());
            this.removeTrackingRefUpdate(want.getObjectId());
        }
    }

    private void removeTrackingRefUpdate(ObjectId want) {
        Iterator<TrackingRefUpdate> i = this.localUpdates.iterator();
        while (i.hasNext()) {
            TrackingRefUpdate u = i.next();
            if (!u.getNewObjectId().equals(want)) continue;
            i.remove();
        }
    }

    private void removeFetchHeadRecord(ObjectId want) {
        Iterator<FetchHeadRecord> i = this.fetchHeadUpdates.iterator();
        while (i.hasNext()) {
            FetchHeadRecord fh = i.next();
            if (!fh.newValue.equals(want)) continue;
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFETCH_HEAD(FetchResult result2) throws IOException {
        File meta = this.transport.local.getDirectory();
        if (meta == null) {
            return;
        }
        LockFile lock = new LockFile(new File(meta, "FETCH_HEAD"), this.transport.local.getFS());
        try {
            if (lock.lock()) {
                OutputStreamWriter w = new OutputStreamWriter(lock.getOutputStream());
                try {
                    for (FetchHeadRecord h2 : this.fetchHeadUpdates) {
                        h2.write(w);
                        result2.add(h2);
                    }
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    ((Writer)w).close();
                    throw throwable;
                }
                ((Writer)w).close();
                lock.commit();
            }
            Object var10_10 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean askForIsComplete() throws TransportException {
        try {
            ObjectWalk ow = new ObjectWalk(this.transport.local);
            try {
                for (ObjectId want : this.askFor.keySet()) {
                    ow.markStart(ow.parseAny(want));
                }
                for (Ref ref : this.localRefs().values()) {
                    ow.markUninteresting(ow.parseAny(ref.getObjectId()));
                }
                ow.checkConnectivity();
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ow.release();
                throw throwable;
            }
            ow.release();
            return true;
        }
        catch (MissingObjectException e) {
            return false;
        }
        catch (IOException e) {
            throw new TransportException(JGitText.get().unableToCheckConnectivity, e);
        }
    }

    private void expandWildcard(RefSpec spec, Set<Ref> matched) throws TransportException {
        for (Ref src : this.conn.getRefs()) {
            if (!spec.matchSource(src) || !matched.add(src)) continue;
            this.want(src, spec.expandFromSource(src));
        }
    }

    private void expandSingle(RefSpec spec, Set<Ref> matched) throws TransportException {
        Ref src = this.conn.getRef(spec.getSource());
        if (src == null) {
            throw new TransportException(MessageFormat.format(JGitText.get().remoteDoesNotHaveSpec, spec.getSource()));
        }
        if (matched.add(src)) {
            this.want(src, spec);
        }
    }

    private Collection<Ref> expandAutoFollowTags() throws TransportException {
        ArrayList<Ref> additionalTags = new ArrayList<Ref>();
        Map<String, Ref> haveRefs = this.localRefs();
        for (Ref r : this.conn.getRefs()) {
            Ref local;
            if (!FetchProcess.isTag(r) || (local = haveRefs.get(r.getName())) != null) continue;
            ObjectId obj2 = r.getPeeledObjectId();
            if (obj2 == null) {
                obj2 = r.getObjectId();
            }
            if (this.askFor.containsKey(obj2) || this.transport.local.hasObject(obj2)) {
                this.wantTag(r);
                continue;
            }
            additionalTags.add(r);
        }
        return additionalTags;
    }

    private void expandFetchTags() throws TransportException {
        Map<String, Ref> haveRefs = this.localRefs();
        for (Ref r : this.conn.getRefs()) {
            Ref local;
            if (!FetchProcess.isTag(r) || (local = haveRefs.get(r.getName())) != null && r.getObjectId().equals(local.getObjectId())) continue;
            this.wantTag(r);
        }
    }

    private void wantTag(Ref r) throws TransportException {
        this.want(r, new RefSpec().setSource(r.getName()).setDestination(r.getName()).setForceUpdate(true));
    }

    private void want(Ref src, RefSpec spec) throws TransportException {
        ObjectId newId = src.getObjectId();
        if (spec.getDestination() != null) {
            TrackingRefUpdate tru = this.createUpdate(spec, newId);
            if (newId.equals(tru.getOldObjectId())) {
                return;
            }
            this.localUpdates.add(tru);
        }
        this.askFor.put(newId, src);
        FetchHeadRecord fhr = new FetchHeadRecord();
        fhr.newValue = newId;
        fhr.notForMerge = spec.getDestination() != null;
        fhr.sourceName = src.getName();
        fhr.sourceURI = this.transport.getURI();
        this.fetchHeadUpdates.add(fhr);
    }

    private TrackingRefUpdate createUpdate(RefSpec spec, ObjectId newId) throws TransportException {
        Ref ref = this.localRefs().get(spec.getDestination());
        ObjectId oldId = ref != null && ref.getObjectId() != null ? ref.getObjectId() : ObjectId.zeroId();
        return new TrackingRefUpdate(spec.isForceUpdate(), spec.getSource(), spec.getDestination(), oldId, newId);
    }

    private Map<String, Ref> localRefs() throws TransportException {
        if (this.localRefs == null) {
            try {
                this.localRefs = this.transport.local.getRefDatabase().getRefs("");
            }
            catch (IOException err2) {
                throw new TransportException(JGitText.get().cannotListRefs, err2);
            }
        }
        return this.localRefs;
    }

    private void deleteStaleTrackingRefs(FetchResult result2, BatchRefUpdate batch) throws IOException {
        for (Ref ref : this.localRefs().values()) {
            String refname = ref.getName();
            for (RefSpec spec : this.toFetch) {
                RefSpec s2;
                if (!spec.matchDestination(refname) || result2.getAdvertisedRef((s2 = spec.expandFromDestination(refname)).getSource()) != null) continue;
                this.deleteTrackingRef(result2, batch, s2, ref);
            }
        }
    }

    private void deleteTrackingRef(FetchResult result2, BatchRefUpdate batch, RefSpec spec, Ref localRef) {
        if (localRef.getObjectId() == null) {
            return;
        }
        TrackingRefUpdate update2 = new TrackingRefUpdate(true, spec.getSource(), localRef.getName(), localRef.getObjectId(), ObjectId.zeroId());
        result2.add(update2);
        batch.addCommand(update2.asReceiveCommand());
    }

    private static boolean isTag(Ref r) {
        return FetchProcess.isTag(r.getName());
    }

    private static boolean isTag(String name2) {
        return name2.startsWith("refs/tags/");
    }

    private static String getFirstFailedRefName(BatchRefUpdate batch) {
        for (ReceiveCommand cmd : batch.getCommands()) {
            if (cmd.getResult() == ReceiveCommand.Result.OK) continue;
            return cmd.getRefName();
        }
        return "";
    }
}

