/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSshConfig {
    static final int SSH_PORT = 22;
    private final File home;
    private final File configFile;
    private long lastModified;
    private Map<String, Host> hosts;

    public static OpenSshConfig get(FS fs) {
        File home = fs.userHome();
        if (home == null) {
            home = new File(".").getAbsoluteFile();
        }
        File config2 = new File(new File(home, ".ssh"), "config");
        OpenSshConfig osc = new OpenSshConfig(home, config2);
        osc.refresh();
        return osc;
    }

    OpenSshConfig(File h2, File cfg) {
        this.home = h2;
        this.configFile = cfg;
        this.hosts = Collections.emptyMap();
    }

    public Host lookup(String hostName) {
        Map<String, Host> cache = this.refresh();
        Host h2 = cache.get(hostName);
        if (h2 == null) {
            h2 = new Host();
        }
        if (h2.patternsApplied) {
            return h2;
        }
        for (Map.Entry<String, Host> e : cache.entrySet()) {
            if (!OpenSshConfig.isHostPattern(e.getKey()) || !OpenSshConfig.isHostMatch(e.getKey(), hostName)) continue;
            h2.copyFrom(e.getValue());
        }
        if (h2.hostName == null) {
            h2.hostName = hostName;
        }
        if (h2.user == null) {
            h2.user = OpenSshConfig.userName();
        }
        if (h2.port == 0) {
            h2.port = 22;
        }
        if (h2.connectionAttempts == 0) {
            h2.connectionAttempts = 1;
        }
        h2.patternsApplied = true;
        return h2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<String, Host> refresh() {
        long mtime = this.configFile.lastModified();
        if (mtime != this.lastModified) {
            try {
                FileInputStream in = new FileInputStream(this.configFile);
                try {
                    this.hosts = this.parse(in);
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                {
                }
            }
            catch (FileNotFoundException none) {
                this.hosts = Collections.emptyMap();
            }
            catch (IOException err2) {
                this.hosts = Collections.emptyMap();
            }
            this.lastModified = mtime;
        }
        return this.hosts;
    }

    private Map<String, Host> parse(InputStream in) throws IOException {
        String line2;
        LinkedHashMap<String, Host> m = new LinkedHashMap<String, Host>();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        ArrayList<Host> current2 = new ArrayList<Host>(4);
        while ((line2 = br.readLine()) != null) {
            if ((line2 = line2.trim()).length() == 0 || line2.startsWith("#")) continue;
            String[] parts = line2.split("[ \t]*[= \t]", 2);
            String keyword2 = parts[0].trim();
            String argValue = parts[1].trim();
            if (StringUtils.equalsIgnoreCase("Host", keyword2)) {
                current2.clear();
                for (String pattern2 : argValue.split("[ \t]")) {
                    String name2 = OpenSshConfig.dequote(pattern2);
                    Host c = (Host)m.get(name2);
                    if (c == null) {
                        c = new Host();
                        m.put(name2, c);
                    }
                    current2.add(c);
                }
                continue;
            }
            if (current2.isEmpty()) continue;
            if (StringUtils.equalsIgnoreCase("HostName", keyword2)) {
                for (Host c : current2) {
                    if (c.hostName != null) continue;
                    c.hostName = OpenSshConfig.dequote(argValue);
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("User", keyword2)) {
                for (Host c : current2) {
                    if (c.user != null) continue;
                    c.user = OpenSshConfig.dequote(argValue);
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("Port", keyword2)) {
                try {
                    int port = Integer.parseInt(OpenSshConfig.dequote(argValue));
                    for (Host c : current2) {
                        if (c.port != 0) continue;
                        c.port = port;
                    }
                    continue;
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
            }
            if (StringUtils.equalsIgnoreCase("IdentityFile", keyword2)) {
                for (Host c : current2) {
                    if (c.identityFile != null) continue;
                    c.identityFile = this.toFile(OpenSshConfig.dequote(argValue));
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("PreferredAuthentications", keyword2)) {
                for (Host c : current2) {
                    if (c.preferredAuthentications != null) continue;
                    c.preferredAuthentications = OpenSshConfig.nows(OpenSshConfig.dequote(argValue));
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("BatchMode", keyword2)) {
                for (Host c : current2) {
                    if (c.batchMode != null) continue;
                    c.batchMode = OpenSshConfig.yesno(OpenSshConfig.dequote(argValue));
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("StrictHostKeyChecking", keyword2)) {
                String value2 = OpenSshConfig.dequote(argValue);
                for (Host c : current2) {
                    if (c.strictHostKeyChecking != null) continue;
                    c.strictHostKeyChecking = value2;
                }
                continue;
            }
            if (!StringUtils.equalsIgnoreCase("ConnectionAttempts", keyword2)) continue;
            try {
                int connectionAttempts = Integer.parseInt(OpenSshConfig.dequote(argValue));
                if (connectionAttempts <= 0) continue;
                for (Host c : current2) {
                    if (c.connectionAttempts != 0) continue;
                    c.connectionAttempts = connectionAttempts;
                }
            }
            catch (NumberFormatException nfe) {
            }
        }
        return m;
    }

    private static boolean isHostPattern(String s2) {
        return s2.indexOf(42) >= 0 || s2.indexOf(63) >= 0;
    }

    private static boolean isHostMatch(String pattern2, String name2) {
        FileNameMatcher fn;
        try {
            fn = new FileNameMatcher(pattern2, null);
        }
        catch (InvalidPatternException e) {
            return false;
        }
        fn.append(name2);
        return fn.isMatch();
    }

    private static String dequote(String value2) {
        if (value2.startsWith("\"") && value2.endsWith("\"")) {
            return value2.substring(1, value2.length() - 1);
        }
        return value2;
    }

    private static String nows(String value2) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < value2.length(); ++i) {
            if (Character.isSpaceChar(value2.charAt(i))) continue;
            b.append(value2.charAt(i));
        }
        return b.toString();
    }

    private static Boolean yesno(String value2) {
        if (StringUtils.equalsIgnoreCase("yes", value2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private File toFile(String path2) {
        if (path2.startsWith("~/")) {
            return new File(this.home, path2.substring(2));
        }
        File ret = new File(path2);
        if (ret.isAbsolute()) {
            return ret;
        }
        return new File(this.home, path2);
    }

    static String userName() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.name");
            }
        });
    }

    public static class Host {
        boolean patternsApplied;
        String hostName;
        int port;
        File identityFile;
        String user;
        String preferredAuthentications;
        Boolean batchMode;
        String strictHostKeyChecking;
        int connectionAttempts;

        void copyFrom(Host src) {
            if (this.hostName == null) {
                this.hostName = src.hostName;
            }
            if (this.port == 0) {
                this.port = src.port;
            }
            if (this.identityFile == null) {
                this.identityFile = src.identityFile;
            }
            if (this.user == null) {
                this.user = src.user;
            }
            if (this.preferredAuthentications == null) {
                this.preferredAuthentications = src.preferredAuthentications;
            }
            if (this.batchMode == null) {
                this.batchMode = src.batchMode;
            }
            if (this.strictHostKeyChecking == null) {
                this.strictHostKeyChecking = src.strictHostKeyChecking;
            }
            if (this.connectionAttempts == 0) {
                this.connectionAttempts = src.connectionAttempts;
            }
        }

        public String getStrictHostKeyChecking() {
            return this.strictHostKeyChecking;
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }

        public File getIdentityFile() {
            return this.identityFile;
        }

        public String getUser() {
            return this.user;
        }

        public String getPreferredAuthentications() {
            return this.preferredAuthentications;
        }

        public boolean isBatchMode() {
            return this.batchMode != null && this.batchMode != false;
        }

        public int getConnectionAttempts() {
            return this.connectionAttempts;
        }
    }
}

