/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationResult {
    Map<String, Ref> advertisedRefs = Collections.emptyMap();
    URIish uri;
    final SortedMap<String, TrackingRefUpdate> updates = new TreeMap<String, TrackingRefUpdate>();
    StringBuilder messageBuffer;

    public URIish getURI() {
        return this.uri;
    }

    public Collection<Ref> getAdvertisedRefs() {
        return Collections.unmodifiableCollection(this.advertisedRefs.values());
    }

    public final Ref getAdvertisedRef(String name2) {
        return this.advertisedRefs.get(name2);
    }

    public Collection<TrackingRefUpdate> getTrackingRefUpdates() {
        return Collections.unmodifiableCollection(this.updates.values());
    }

    public TrackingRefUpdate getTrackingRefUpdate(String localName) {
        return (TrackingRefUpdate)this.updates.get(localName);
    }

    void setAdvertisedRefs(URIish u, Map<String, Ref> ar) {
        this.uri = u;
        this.advertisedRefs = ar;
    }

    void add(TrackingRefUpdate u) {
        this.updates.put(u.getLocalName(), u);
    }

    public String getMessages() {
        return this.messageBuffer != null ? this.messageBuffer.toString() : "";
    }

    void addMessages(String msg) {
        if (msg != null && msg.length() > 0) {
            if (this.messageBuffer == null) {
                this.messageBuffer = new StringBuilder();
            }
            this.messageBuffer.append(msg);
            if (!msg.endsWith("\n")) {
                this.messageBuffer.append('\n');
            }
        }
    }
}

