/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class PacketLineIn {
    public static final String END = new StringBuilder(0).toString();
    private final InputStream in;
    private final byte[] lineBuffer;

    public PacketLineIn(InputStream i) {
        this.in = i;
        this.lineBuffer = new byte[1000];
    }

    AckNackResult readACK(MutableObjectId returnedId) throws IOException {
        String line2 = this.readString();
        if (line2.length() == 0) {
            throw new PackProtocolException(JGitText.get().expectedACKNAKFoundEOF);
        }
        if ("NAK".equals(line2)) {
            return AckNackResult.NAK;
        }
        if (line2.startsWith("ACK ")) {
            returnedId.fromString(line2.substring(4, 44));
            if (line2.length() == 44) {
                return AckNackResult.ACK;
            }
            String arg = line2.substring(44);
            if (arg.equals(" continue")) {
                return AckNackResult.ACK_CONTINUE;
            }
            if (arg.equals(" common")) {
                return AckNackResult.ACK_COMMON;
            }
            if (arg.equals(" ready")) {
                return AckNackResult.ACK_READY;
            }
        }
        if (line2.startsWith("ERR ")) {
            throw new PackProtocolException(line2.substring(4));
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedACKNAKGot, line2));
    }

    public String readString() throws IOException {
        int len2 = this.readLength();
        if (len2 == 0) {
            return END;
        }
        if ((len2 -= 4) == 0) {
            return "";
        }
        byte[] raw2 = len2 <= this.lineBuffer.length ? this.lineBuffer : new byte[len2];
        IO.readFully(this.in, raw2, 0, len2);
        if (raw2[len2 - 1] == 10) {
            --len2;
        }
        return RawParseUtils.decode(Constants.CHARSET, raw2, 0, len2);
    }

    public String readStringRaw() throws IOException {
        int len2 = this.readLength();
        if (len2 == 0) {
            return END;
        }
        byte[] raw2 = (len2 -= 4) <= this.lineBuffer.length ? this.lineBuffer : new byte[len2];
        IO.readFully(this.in, raw2, 0, len2);
        return RawParseUtils.decode(Constants.CHARSET, raw2, 0, len2);
    }

    int readLength() throws IOException {
        IO.readFully(this.in, this.lineBuffer, 0, 4);
        try {
            int len2 = RawParseUtils.parseHexInt16(this.lineBuffer, 0);
            if (len2 != 0 && len2 < 4) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return len2;
        }
        catch (ArrayIndexOutOfBoundsException err2) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidPacketLineHeader, "" + (char)this.lineBuffer[0] + (char)this.lineBuffer[1] + (char)this.lineBuffer[2] + (char)this.lineBuffer[3]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AckNackResult {
        NAK,
        ACK,
        ACK_CONTINUE,
        ACK_COMMON,
        ACK_READY;

    }
}

