/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.errors.UnpackException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.RefAdvertiser;

public class ReceivePack
extends BaseReceivePack {
    private PreReceiveHook preReceive = PreReceiveHook.NULL;
    private PostReceiveHook postReceive = PostReceiveHook.NULL;
    private boolean reportStatus;
    private boolean echoCommandFailures;

    public ReceivePack(Repository into) {
        super(into);
    }

    public PreReceiveHook getPreReceiveHook() {
        return this.preReceive;
    }

    public void setPreReceiveHook(PreReceiveHook h2) {
        this.preReceive = h2 != null ? h2 : PreReceiveHook.NULL;
    }

    public PostReceiveHook getPostReceiveHook() {
        return this.postReceive;
    }

    public void setPostReceiveHook(PostReceiveHook h2) {
        this.postReceive = h2 != null ? h2 : PostReceiveHook.NULL;
    }

    public void setEchoCommandFailures(boolean echo) {
        this.echoCommandFailures = echo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(InputStream input2, OutputStream output, OutputStream messages2) throws IOException {
        this.init(input2, output, messages2);
        try {
            this.service();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.close();
                Object var7_8 = null;
            }
            catch (Throwable throwable2) {
                Object var7_9 = null;
                this.release();
                throw throwable2;
            }
            this.release();
            throw throwable;
        }
        try {
            this.close();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.release();
            throw throwable;
        }
        this.release();
    }

    protected void enableCapabilities() {
        this.reportStatus = this.isCapabilityEnabled("report-status");
        super.enableCapabilities();
    }

    private void service() throws IOException {
        if (this.isBiDirectionalPipe()) {
            this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut));
            this.pckOut.flush();
        } else {
            this.getAdvertisedOrDefaultRefs();
        }
        if (this.hasError()) {
            return;
        }
        this.recvCommands();
        if (this.hasCommands()) {
            this.enableCapabilities();
            Throwable unpackError = null;
            if (this.needPack()) {
                try {
                    this.receivePackAndCheckConnectivity();
                }
                catch (IOException err2) {
                    unpackError = err2;
                }
                catch (RuntimeException err3) {
                    unpackError = err3;
                }
                catch (Error err4) {
                    unpackError = err4;
                }
            }
            if (unpackError == null) {
                boolean atomic2 = this.isCapabilityEnabled("atomic-push");
                this.validateCommands();
                if (atomic2 && this.anyRejects()) {
                    this.failPendingCommands();
                }
                this.preReceive.onPreReceive(this, this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED));
                if (atomic2 && this.anyRejects()) {
                    this.failPendingCommands();
                }
                this.executeCommands();
            }
            this.unlockPack();
            if (this.reportStatus) {
                if (this.echoCommandFailures && this.msgOut != null) {
                    this.sendStatusReport(false, unpackError, new BaseReceivePack.Reporter(){

                        void sendString(String s2) throws IOException {
                            ReceivePack.this.msgOut.write(Constants.encode(s2 + "\n"));
                        }
                    });
                    this.msgOut.flush();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.sendStatusReport(true, unpackError, new BaseReceivePack.Reporter(){

                    void sendString(String s2) throws IOException {
                        ReceivePack.this.pckOut.writeString(s2 + "\n");
                    }
                });
                this.pckOut.end();
            } else if (this.msgOut != null) {
                this.sendStatusReport(false, unpackError, new BaseReceivePack.Reporter(){

                    void sendString(String s2) throws IOException {
                        ReceivePack.this.msgOut.write(Constants.encode(s2 + "\n"));
                    }
                });
            }
            this.postReceive.onPostReceive(this, this.filterCommands(ReceiveCommand.Result.OK));
            if (unpackError != null) {
                throw new UnpackException(unpackError);
            }
        }
    }

    protected String getLockMessageProcessName() {
        return "jgit receive-pack";
    }
}

