/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.HttpAuthMethod;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.util.HttpSupport;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.eclipse.jgit.util.io.UnionInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportHttp
extends HttpTransport
implements WalkTransport,
PackTransport {
    private static final String SVC_UPLOAD_PACK = "git-upload-pack";
    private static final String SVC_RECEIVE_PACK = "git-receive-pack";
    private static final String userAgent = TransportHttp.computeUserAgent();
    static final TransportProtocol PROTO_HTTP = new TransportProtocol(){
        private final String[] schemeNames = new String[]{"http", "https"};
        private final Set<String> schemeSet = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(this.schemeNames)));

        @Override
        public String getName() {
            return JGitText.get().transportProtoHTTP;
        }

        @Override
        public Set<String> getSchemes() {
            return this.schemeSet;
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.USER, TransportProtocol.URIishField.PASS, TransportProtocol.URIishField.PORT));
        }

        @Override
        public int getDefaultPort() {
            return 80;
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException {
            return new TransportHttp(local, uri);
        }

        @Override
        public Transport open(URIish uri) throws NotSupportedException {
            return new TransportHttp(uri);
        }
    };
    static final TransportProtocol PROTO_FTP = new TransportProtocol(){

        @Override
        public String getName() {
            return JGitText.get().transportProtoFTP;
        }

        @Override
        public Set<String> getSchemes() {
            return Collections.singleton("ftp");
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.USER, TransportProtocol.URIishField.PASS, TransportProtocol.URIishField.PORT));
        }

        @Override
        public int getDefaultPort() {
            return 21;
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException {
            return new TransportHttp(local, uri);
        }
    };
    private static final Config.SectionParser<HttpConfig> HTTP_KEY = new Config.SectionParser<HttpConfig>(){

        @Override
        public HttpConfig parse(Config cfg) {
            return new HttpConfig(cfg);
        }
    };
    private final URL baseUrl;
    private final URL objectsUrl;
    private final HttpConfig http;
    private final ProxySelector proxySelector;
    private boolean useSmartHttp = true;
    private HttpAuthMethod authMethod = HttpAuthMethod.Type.NONE.method(null);
    private Map<String, String> headers;

    private static String computeUserAgent() {
        Package pkg = TransportHttp.class.getPackage();
        String version2 = pkg != null && pkg.getImplementationVersion() != null ? pkg.getImplementationVersion() : "unknown";
        return "JGit/" + version2;
    }

    TransportHttp(Repository local, URIish uri) throws NotSupportedException {
        super(local, uri);
        try {
            String uriString = uri.toString();
            if (!uriString.endsWith("/")) {
                uriString = uriString + "/";
            }
            this.baseUrl = new URL(uriString);
            this.objectsUrl = new URL(this.baseUrl, "objects/");
        }
        catch (MalformedURLException e) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().invalidURL, uri), e);
        }
        this.http = local.getConfig().get(HTTP_KEY);
        this.proxySelector = ProxySelector.getDefault();
    }

    TransportHttp(URIish uri) throws NotSupportedException {
        super(uri);
        try {
            String uriString = uri.toString();
            if (!uriString.endsWith("/")) {
                uriString = uriString + "/";
            }
            this.baseUrl = new URL(uriString);
            this.objectsUrl = new URL(this.baseUrl, "objects/");
        }
        catch (MalformedURLException e) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().invalidURL, uri), e);
        }
        this.http = new HttpConfig();
        this.proxySelector = ProxySelector.getDefault();
    }

    public void setUseSmartHttp(boolean on) {
        this.useSmartHttp = on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FetchConnection openFetch() throws TransportException, NotSupportedException {
        String service = SVC_UPLOAD_PACK;
        try {
            FetchConnection fetchConnection;
            InputStream in;
            block8: {
                SmartHttpFetchConnection smartHttpFetchConnection;
                block7: {
                    HttpConnection c = this.connect(SVC_UPLOAD_PACK);
                    in = this.openInputStream(c);
                    try {
                        if (this.isSmartHttp(c, SVC_UPLOAD_PACK)) {
                            this.readSmartHeaders(in, SVC_UPLOAD_PACK);
                            smartHttpFetchConnection = new SmartHttpFetchConnection(in);
                            Object var6_9 = null;
                            break block7;
                        }
                        fetchConnection = this.newDumbConnection(in);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        in.close();
                        throw throwable;
                    }
                }
                in.close();
                return smartHttpFetchConnection;
            }
            Object var6_10 = null;
            in.close();
            return fetchConnection;
        }
        catch (NotSupportedException err2) {
            throw err2;
        }
        catch (TransportException err3) {
            throw err3;
        }
        catch (IOException err4) {
            throw new TransportException(this.uri, JGitText.get().errorReadingInfoRefs, err4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FetchConnection newDumbConnection(InputStream in) throws IOException, PackProtocolException {
        Map<String, Ref> refs;
        HttpObjectDB d = new HttpObjectDB(this.objectsUrl);
        BufferedReader br = this.toBufferedReader(in);
        try {
            refs = d.readAdvertisedImpl(br);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            br.close();
            throw throwable;
        }
        br.close();
        if (!refs.containsKey("HEAD")) {
            HttpConnection conn = this.httpOpen(new URL(this.baseUrl, "HEAD"));
            int status = HttpSupport.response(conn);
            switch (status) {
                case 200: {
                    br = this.toBufferedReader(this.openInputStream(conn));
                    try {
                        String line2 = br.readLine();
                        if (line2 != null && line2.startsWith("ref: ")) {
                            String target = line2.substring("ref: ".length());
                            Ref r = refs.get(target);
                            if (r == null) {
                                r = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
                            }
                            r = new SymbolicRef("HEAD", r);
                            refs.put(r.getName(), r);
                        } else if (line2 != null && ObjectId.isId(line2)) {
                            ObjectIdRef.Unpeeled r = new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, "HEAD", ObjectId.fromString(line2));
                            refs.put(r.getName(), r);
                        }
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        br.close();
                        throw throwable;
                    }
                    br.close();
                    break;
                }
                case 404: {
                    break;
                }
                default: {
                    throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotReadHEAD, status, conn.getResponseMessage()));
                }
            }
        }
        WalkFetchConnection wfc = new WalkFetchConnection(this, d);
        wfc.available(refs);
        return wfc;
    }

    private BufferedReader toBufferedReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, Constants.CHARSET));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PushConnection openPush() throws NotSupportedException, TransportException {
        String service = SVC_RECEIVE_PACK;
        try {
            SmartHttpPushConnection smartHttpPushConnection;
            HttpConnection c = this.connect(SVC_RECEIVE_PACK);
            InputStream in = this.openInputStream(c);
            try {
                if (!this.isSmartHttp(c, SVC_RECEIVE_PACK)) {
                    if (!this.useSmartHttp) {
                        String msg = JGitText.get().smartHTTPPushDisabled;
                        throw new NotSupportedException(msg);
                    }
                    String msg = JGitText.get().remoteDoesNotSupportSmartHTTPPush;
                    throw new NotSupportedException(msg);
                }
                this.readSmartHeaders(in, SVC_RECEIVE_PACK);
                smartHttpPushConnection = new SmartHttpPushConnection(in);
                Object var6_10 = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return smartHttpPushConnection;
        }
        catch (NotSupportedException err2) {
            throw err2;
        }
        catch (TransportException err3) {
            throw err3;
        }
        catch (IOException err4) {
            throw new TransportException(this.uri, JGitText.get().errorReadingInfoRefs, err4);
        }
    }

    @Override
    public void close() {
    }

    public void setAdditionalHeaders(Map<String, String> headers2) {
        this.headers = headers2;
    }

    private HttpConnection connect(String service) throws TransportException, NotSupportedException {
        URL u;
        try {
            StringBuilder b = new StringBuilder();
            b.append(this.baseUrl);
            if (b.charAt(b.length() - 1) != '/') {
                b.append('/');
            }
            b.append("info/refs");
            if (this.useSmartHttp) {
                b.append(b.indexOf("?") < 0 ? (char)'?' : '&');
                b.append("service=");
                b.append(service);
            }
            u = new URL(b.toString());
        }
        catch (MalformedURLException e) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().invalidURL, this.uri), e);
        }
        try {
            int status;
            HttpConnection conn;
            int authAttempts = 1;
            block12: while (true) {
                conn = this.httpOpen(u);
                if (this.useSmartHttp) {
                    String exp = "application/x-" + service + "-advertisement";
                    conn.setRequestProperty("Accept", exp + ", */*");
                } else {
                    conn.setRequestProperty("Accept", "*/*");
                }
                status = HttpSupport.response(conn);
                switch (status) {
                    case 200: {
                        if (this.authMethod.getType() == HttpAuthMethod.Type.NONE && conn.getHeaderField("WWW-Authenticate") != null) {
                            this.authMethod = HttpAuthMethod.scanResponse(conn);
                        }
                        return conn;
                    }
                    case 404: {
                        throw new NoRemoteRepositoryException(this.uri, MessageFormat.format(JGitText.get().uriNotFound, u));
                    }
                    case 401: {
                        this.authMethod = HttpAuthMethod.scanResponse(conn);
                        if (this.authMethod.getType() == HttpAuthMethod.Type.NONE) {
                            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().authenticationNotSupported, this.uri));
                        }
                        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
                        if (credentialsProvider == null) {
                            throw new TransportException(this.uri, JGitText.get().noCredentialsProvider);
                        }
                        if (authAttempts > 1) {
                            credentialsProvider.reset(this.uri);
                        }
                        if (3 < authAttempts || !this.authMethod.authorize(this.uri, credentialsProvider)) {
                            throw new TransportException(this.uri, JGitText.get().notAuthorized);
                        }
                        ++authAttempts;
                        continue block12;
                    }
                    case 403: {
                        throw new TransportException(this.uri, MessageFormat.format(JGitText.get().serviceNotPermitted, service));
                    }
                }
                break;
            }
            String err2 = status + " " + conn.getResponseMessage();
            throw new TransportException(this.uri, err2);
        }
        catch (NotSupportedException e) {
            throw e;
        }
        catch (TransportException e) {
            throw e;
        }
        catch (IOException e) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotOpenService, service), e);
        }
    }

    final HttpConnection httpOpen(URL u) throws IOException {
        return this.httpOpen("GET", u);
    }

    protected HttpConnection httpOpen(String method, URL u) throws IOException {
        Proxy proxy = HttpSupport.proxyFor(this.proxySelector, u);
        HttpConnection conn = connectionFactory.create(u, proxy);
        if (!this.http.sslVerify && "https".equals(u.getProtocol())) {
            this.disableSslVerify(conn);
        }
        conn.setRequestMethod(method);
        conn.setUseCaches(false);
        conn.setRequestProperty("Accept-Encoding", "gzip");
        conn.setRequestProperty("Pragma", "no-cache");
        conn.setRequestProperty("User-Agent", userAgent);
        int timeOut = this.getTimeout();
        if (timeOut != -1) {
            int effTimeOut = timeOut * 1000;
            conn.setConnectTimeout(effTimeOut);
            conn.setReadTimeout(effTimeOut);
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        this.authMethod.configureRequest(conn);
        return conn;
    }

    private void disableSslVerify(HttpConnection conn) throws IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new DummyX509TrustManager()};
        try {
            conn.configure(null, trustAllCerts, null);
            conn.setHostnameVerifier(new DummyHostnameVerifier());
        }
        catch (KeyManagementException e) {
            throw new IOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
    }

    final InputStream openInputStream(HttpConnection conn) throws IOException {
        InputStream input2 = conn.getInputStream();
        if ("gzip".equals(conn.getHeaderField("Content-Encoding"))) {
            input2 = new GZIPInputStream(input2);
        }
        return input2;
    }

    IOException wrongContentType(String expType, String actType) {
        String why = MessageFormat.format(JGitText.get().expectedReceivedContentType, expType, actType);
        return new TransportException(this.uri, why);
    }

    private boolean isSmartHttp(HttpConnection c, String service) {
        String expType = "application/x-" + service + "-advertisement";
        String actType = c.getContentType();
        return expType.equals(actType);
    }

    private void readSmartHeaders(InputStream in, String service) throws IOException {
        String act;
        byte[] magic = new byte[5];
        IO.readFully(in, magic, 0, magic.length);
        if (magic[4] != 35) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedPktLineWithService, RawParseUtils.decode(magic)));
        }
        PacketLineIn pckIn = new PacketLineIn(new UnionInputStream(new ByteArrayInputStream(magic), in));
        String exp = "# service=" + service;
        if (!exp.equals(act = pckIn.readString())) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedGot, exp, act));
        }
        while (pckIn.readString() != PacketLineIn.END) {
        }
    }

    private static class DummyHostnameVerifier
    implements HostnameVerifier {
        private DummyHostnameVerifier() {
        }

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class DummyX509TrustManager
    implements X509TrustManager {
        private DummyX509TrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    private static class HttpConfig {
        final int postBuffer;
        final boolean sslVerify;

        HttpConfig(Config rc) {
            this.postBuffer = rc.getInt("http", "postbuffer", 0x100000);
            this.sslVerify = rc.getBoolean("http", "sslVerify", true);
        }

        private HttpConfig() {
            this(new Config());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpObjectDB
    extends WalkRemoteObjectDatabase {
        private final URL httpObjectsUrl;

        HttpObjectDB(URL b) {
            this.httpObjectsUrl = b;
        }

        @Override
        URIish getURI() {
            return new URIish(this.httpObjectsUrl);
        }

        @Override
        Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException {
            try {
                return this.readAlternates("info/http-alternates");
            }
            catch (FileNotFoundException err2) {
                try {
                    return this.readAlternates("info/alternates");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }

        @Override
        WalkRemoteObjectDatabase openAlternate(String location) throws IOException {
            return new HttpObjectDB(new URL(this.httpObjectsUrl, location));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Collection<String> getPackNames() throws IOException {
            ArrayList<String> arrayList;
            ArrayList<String> packs = new ArrayList<String>();
            BufferedReader br = this.openReader("info/packs");
            try {
                String s2;
                while ((s2 = br.readLine()) != null && s2.length() != 0) {
                    if (!s2.startsWith("P pack-") || !s2.endsWith(".pack")) {
                        throw this.invalidAdvertisement(s2);
                    }
                    packs.add(s2.substring(2));
                }
                arrayList = packs;
                {
                    Object var5_5 = null;
                }
            }
            catch (Throwable throwable) {
                try {
                    Object var5_6 = null;
                    br.close();
                    throw throwable;
                }
                catch (FileNotFoundException err2) {
                    return packs;
                }
            }
            {
                br.close();
            }
            return arrayList;
        }

        @Override
        WalkRemoteObjectDatabase.FileStream open(String path2) throws IOException {
            URL base = this.httpObjectsUrl;
            URL u = new URL(base, path2);
            HttpConnection c = TransportHttp.this.httpOpen(u);
            switch (HttpSupport.response(c)) {
                case 200: {
                    InputStream in = TransportHttp.this.openInputStream(c);
                    int len2 = c.getContentLength();
                    return new WalkRemoteObjectDatabase.FileStream(in, len2);
                }
                case 404: {
                    throw new FileNotFoundException(u.toString());
                }
            }
            throw new IOException(u.toString() + ": " + HttpSupport.response(c) + " " + c.getResponseMessage());
        }

        Map<String, Ref> readAdvertisedImpl(BufferedReader br) throws IOException, PackProtocolException {
            String line2;
            TreeMap<String, Ref> avail = new TreeMap<String, Ref>();
            while ((line2 = br.readLine()) != null) {
                Ref prior;
                int tab = line2.indexOf(9);
                if (tab < 0) {
                    throw this.invalidAdvertisement(line2);
                }
                String name2 = line2.substring(tab + 1);
                ObjectId id2 = ObjectId.fromString(line2.substring(0, tab));
                if (name2.endsWith("^{}")) {
                    prior = avail.get(name2 = name2.substring(0, name2.length() - 3));
                    if (prior == null) {
                        throw this.outOfOrderAdvertisement(name2);
                    }
                    if (prior.getPeeledObjectId() != null) {
                        throw this.duplicateAdvertisement(name2 + "^{}");
                    }
                    avail.put(name2, new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name2, prior.getObjectId(), id2));
                    continue;
                }
                prior = avail.put(name2, new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name2, id2));
                if (prior == null) continue;
                throw this.duplicateAdvertisement(name2);
            }
            return avail;
        }

        private PackProtocolException outOfOrderAdvertisement(String n) {
            return new PackProtocolException(MessageFormat.format(JGitText.get().advertisementOfCameBefore, n, n));
        }

        private PackProtocolException invalidAdvertisement(String n) {
            return new PackProtocolException(MessageFormat.format(JGitText.get().invalidAdvertisementOf, n));
        }

        private PackProtocolException duplicateAdvertisement(String n) {
            return new PackProtocolException(MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, n));
        }

        @Override
        void close() {
        }
    }

    class LongPollService
    extends Service {
        LongPollService(String serviceName) {
            super(serviceName);
        }

        void execute() throws IOException {
            this.out.close();
            if (this.conn == null) {
                this.sendRequest();
            }
            this.openResponse();
            this.in.add(TransportHttp.this.openInputStream(this.conn));
        }
    }

    class MultiRequestService
    extends Service {
        boolean finalRequest;

        MultiRequestService(String serviceName) {
            super(serviceName);
        }

        void execute() throws IOException {
            this.out.close();
            if (this.conn == null) {
                if (this.out.length() == 0L) {
                    if (this.finalRequest) {
                        return;
                    }
                    throw new TransportException(TransportHttp.this.uri, JGitText.get().startingReadStageWithoutWrittenRequestDataPendingIsNotSupported);
                }
                this.sendRequest();
            }
            this.out.reset();
            this.openResponse();
            this.in.add(TransportHttp.this.openInputStream(this.conn));
            if (!this.finalRequest) {
                this.in.add(this.execute);
            }
            this.conn = null;
        }
    }

    abstract class Service {
        protected final String serviceName;
        protected final String requestType;
        protected final String responseType;
        protected HttpConnection conn;
        protected HttpOutputStream out;
        protected final HttpExecuteStream execute;
        final UnionInputStream in;

        Service(String serviceName) {
            this.serviceName = serviceName;
            this.requestType = "application/x-" + serviceName + "-request";
            this.responseType = "application/x-" + serviceName + "-result";
            this.out = new HttpOutputStream();
            this.execute = new HttpExecuteStream();
            this.in = new UnionInputStream(this.execute);
        }

        void openStream() throws IOException {
            this.conn = TransportHttp.this.httpOpen("POST", new URL(TransportHttp.this.baseUrl, this.serviceName));
            this.conn.setInstanceFollowRedirects(false);
            this.conn.setDoOutput(true);
            this.conn.setRequestProperty("Content-Type", this.requestType);
            this.conn.setRequestProperty("Accept", this.responseType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendRequest() throws IOException {
            TemporaryBuffer buf = new TemporaryBuffer.Heap(((TransportHttp)TransportHttp.this).http.postBuffer);
            try {
                GZIPOutputStream gzip = new GZIPOutputStream(buf);
                this.out.writeTo(gzip, null);
                gzip.close();
                if (this.out.length() < buf.length()) {
                    buf = this.out;
                }
            }
            catch (IOException err2) {
                buf = this.out;
            }
            this.openStream();
            if (buf != this.out) {
                this.conn.setRequestProperty("Content-Encoding", "gzip");
            }
            this.conn.setFixedLengthStreamingMode((int)buf.length());
            OutputStream httpOut = this.conn.getOutputStream();
            try {
                buf.writeTo(httpOut, null);
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                httpOut.close();
                throw throwable;
            }
            httpOut.close();
        }

        void openResponse() throws IOException {
            int status = HttpSupport.response(this.conn);
            if (status != 200) {
                throw new TransportException(TransportHttp.this.uri, status + " " + this.conn.getResponseMessage());
            }
            String contentType2 = this.conn.getContentType();
            if (!this.responseType.equals(contentType2)) {
                this.conn.getInputStream().close();
                throw TransportHttp.this.wrongContentType(this.responseType, contentType2);
            }
        }

        HttpOutputStream getOutputStream() {
            return this.out;
        }

        InputStream getInputStream() {
            return this.in;
        }

        abstract void execute() throws IOException;

        class HttpExecuteStream
        extends InputStream {
            HttpExecuteStream() {
            }

            public int read() throws IOException {
                Service.this.execute();
                return -1;
            }

            public int read(byte[] b, int off, int len2) throws IOException {
                Service.this.execute();
                return -1;
            }

            public long skip(long n) throws IOException {
                Service.this.execute();
                return 0L;
            }
        }

        class HttpOutputStream
        extends TemporaryBuffer {
            HttpOutputStream() {
                super(((TransportHttp)TransportHttp.this).http.postBuffer);
            }

            protected OutputStream overflow() throws IOException {
                Service.this.openStream();
                Service.this.conn.setChunkedStreamingMode(0);
                return Service.this.conn.getOutputStream();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SmartHttpFetchConnection
    extends BasePackFetchConnection {
        private MultiRequestService svc;

        SmartHttpFetchConnection(InputStream advertisement) throws TransportException {
            super(TransportHttp.this);
            this.statelessRPC = true;
            this.init(advertisement, DisabledOutputStream.INSTANCE);
            this.outNeedsEnd = false;
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have, OutputStream outputStream2) throws TransportException {
            try {
                this.svc = new MultiRequestService(TransportHttp.SVC_UPLOAD_PACK);
                this.init(this.svc.getInputStream(), this.svc.getOutputStream());
                super.doFetch(monitor, want, have, outputStream2);
                Object var6_5 = null;
                this.svc = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.svc = null;
                throw throwable;
            }
        }

        @Override
        protected void onReceivePack() {
            this.svc.finalRequest = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SmartHttpPushConnection
    extends BasePackPushConnection {
        SmartHttpPushConnection(InputStream advertisement) throws TransportException {
            super(TransportHttp.this);
            this.statelessRPC = true;
            this.init(advertisement, DisabledOutputStream.INSTANCE);
            this.outNeedsEnd = false;
            this.readAdvertisedRefs();
        }

        @Override
        protected void doPush(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates, OutputStream outputStream2) throws TransportException {
            MultiRequestService svc = new MultiRequestService(TransportHttp.SVC_RECEIVE_PACK);
            this.init(svc.getInputStream(), svc.getOutputStream());
            super.doPush(monitor, refUpdates, outputStream2);
        }
    }
}

