/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.JschSession;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkPushConnection;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;

public class TransportSftp
extends SshTransport
implements WalkTransport {
    static final TransportProtocol PROTO_SFTP = new TransportProtocol(){

        @Override
        public String getName() {
            return JGitText.get().transportProtoSFTP;
        }

        @Override
        public Set<String> getSchemes() {
            return Collections.singleton("sftp");
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.USER, TransportProtocol.URIishField.PASS, TransportProtocol.URIishField.PORT));
        }

        @Override
        public int getDefaultPort() {
            return 22;
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException {
            return new TransportSftp(local, uri);
        }
    };

    TransportSftp(Repository local, URIish uri) {
        super(local, uri);
    }

    public FetchConnection openFetch() throws TransportException {
        SftpObjectDB c = new SftpObjectDB(this.uri.getPath());
        WalkFetchConnection r = new WalkFetchConnection(this, c);
        r.available(c.readAdvertisedRefs());
        return r;
    }

    public PushConnection openPush() throws TransportException {
        SftpObjectDB c = new SftpObjectDB(this.uri.getPath());
        WalkPushConnection r = new WalkPushConnection(this, c);
        r.available(c.readAdvertisedRefs());
        return r;
    }

    ChannelSftp newSftp() throws TransportException {
        int tms = this.getTimeout() > 0 ? this.getTimeout() * 1000 : 0;
        try {
            Channel channel = ((JschSession)this.getSession()).getSftpChannel();
            channel.connect(tms);
            return (ChannelSftp)channel;
        }
        catch (JSchException je) {
            throw new TransportException(this.uri, je.getMessage(), je);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SftpObjectDB
    extends WalkRemoteObjectDatabase {
        private final String objectsPath;
        private ChannelSftp ftp;

        SftpObjectDB(String path2) throws TransportException {
            if (path2.startsWith("/~")) {
                path2 = path2.substring(1);
            }
            if (path2.startsWith("~/")) {
                path2 = path2.substring(2);
            }
            try {
                this.ftp = TransportSftp.this.newSftp();
                this.ftp.cd(path2);
                this.ftp.cd("objects");
                this.objectsPath = this.ftp.pwd();
            }
            catch (TransportException err2) {
                this.close();
                throw err2;
            }
            catch (SftpException je) {
                throw new TransportException("Can't enter " + path2 + "/objects" + ": " + je.getMessage(), je);
            }
        }

        SftpObjectDB(SftpObjectDB parent, String p) throws TransportException {
            try {
                this.ftp = TransportSftp.this.newSftp();
                this.ftp.cd(parent.objectsPath);
                this.ftp.cd(p);
                this.objectsPath = this.ftp.pwd();
            }
            catch (TransportException err2) {
                this.close();
                throw err2;
            }
            catch (SftpException je) {
                throw new TransportException("Can't enter " + p + " from " + parent.objectsPath + ": " + je.getMessage(), je);
            }
        }

        @Override
        URIish getURI() {
            return TransportSftp.this.uri.setPath(this.objectsPath);
        }

        @Override
        Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException {
            try {
                return this.readAlternates("info/alternates");
            }
            catch (FileNotFoundException err2) {
                return null;
            }
        }

        @Override
        WalkRemoteObjectDatabase openAlternate(String location) throws IOException {
            return new SftpObjectDB(this, location);
        }

        @Override
        Collection<String> getPackNames() throws IOException {
            ArrayList<String> packs = new ArrayList<String>();
            try {
                Vector list2 = this.ftp.ls("pack");
                HashMap<String, ChannelSftp.LsEntry> files2 = new HashMap<String, ChannelSftp.LsEntry>();
                final HashMap<String, Integer> mtimes = new HashMap<String, Integer>();
                for (ChannelSftp.LsEntry ent : list2) {
                    files2.put(ent.getFilename(), ent);
                }
                for (ChannelSftp.LsEntry ent : list2) {
                    String in;
                    String n = ent.getFilename();
                    if (!n.startsWith("pack-") || !n.endsWith(".pack") || !files2.containsKey(in = n.substring(0, n.length() - 5) + ".idx")) continue;
                    mtimes.put(n, ent.getAttrs().getMTime());
                    packs.add(n);
                }
                Collections.sort(packs, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return (Integer)mtimes.get(o2) - (Integer)mtimes.get(o1);
                    }
                });
            }
            catch (SftpException je) {
                throw new TransportException("Can't ls " + this.objectsPath + "/pack: " + je.getMessage(), je);
            }
            return packs;
        }

        @Override
        WalkRemoteObjectDatabase.FileStream open(String path2) throws IOException {
            try {
                SftpATTRS a = this.ftp.lstat(path2);
                return new WalkRemoteObjectDatabase.FileStream(this.ftp.get(path2), a.getSize());
            }
            catch (SftpException je) {
                if (je.id == 2) {
                    throw new FileNotFoundException(path2);
                }
                throw new TransportException("Can't get " + this.objectsPath + "/" + path2 + ": " + je.getMessage(), je);
            }
        }

        @Override
        void deleteFile(String path2) throws IOException {
            try {
                this.ftp.rm(path2);
            }
            catch (SftpException je) {
                if (je.id == 2) {
                    return;
                }
                throw new TransportException("Can't delete " + this.objectsPath + "/" + path2 + ": " + je.getMessage(), je);
            }
            String dir = path2;
            int s2 = dir.lastIndexOf(47);
            while (s2 > 0) {
                try {
                    dir = dir.substring(0, s2);
                    this.ftp.rmdir(dir);
                    s2 = dir.lastIndexOf(47);
                }
                catch (SftpException je) {
                    break;
                }
            }
        }

        @Override
        OutputStream writeFile(String path2, ProgressMonitor monitor, String monitorTask) throws IOException {
            try {
                return this.ftp.put(path2);
            }
            catch (SftpException je) {
                if (je.id == 2) {
                    this.mkdir_p(path2);
                    try {
                        return this.ftp.put(path2);
                    }
                    catch (SftpException je2) {
                        je = je2;
                    }
                }
                throw new TransportException("Can't write " + this.objectsPath + "/" + path2 + ": " + je.getMessage(), je);
            }
        }

        @Override
        void writeFile(String path2, byte[] data) throws IOException {
            String lock = path2 + ".lock";
            try {
                super.writeFile(lock, data);
                try {
                    this.ftp.rename(lock, path2);
                }
                catch (SftpException je) {
                    throw new TransportException("Can't write " + this.objectsPath + "/" + path2 + ": " + je.getMessage(), je);
                }
            }
            catch (IOException err2) {
                try {
                    this.ftp.rm(lock);
                }
                catch (SftpException e) {
                    // empty catch block
                }
                throw err2;
            }
        }

        private void mkdir_p(String path2) throws IOException {
            int s2 = path2.lastIndexOf(47);
            if (s2 <= 0) {
                return;
            }
            path2 = path2.substring(0, s2);
            try {
                this.ftp.mkdir(path2);
            }
            catch (SftpException je) {
                if (je.id == 2) {
                    this.mkdir_p(path2);
                    try {
                        this.ftp.mkdir(path2);
                        return;
                    }
                    catch (SftpException je2) {
                        je = je2;
                    }
                }
                throw new TransportException("Can't mkdir " + this.objectsPath + "/" + path2 + ": " + je.getMessage(), je);
            }
        }

        Map<String, Ref> readAdvertisedRefs() throws TransportException {
            TreeMap<String, Ref> avail = new TreeMap<String, Ref>();
            this.readPackedRefs(avail);
            this.readRef(avail, "../HEAD", "HEAD");
            this.readLooseRefs(avail, "../refs", "refs/");
            return avail;
        }

        private void readLooseRefs(TreeMap<String, Ref> avail, String dir, String prefix) throws TransportException {
            Vector list2;
            try {
                list2 = this.ftp.ls(dir);
            }
            catch (SftpException je) {
                throw new TransportException("Can't ls " + this.objectsPath + "/" + dir + ": " + je.getMessage(), je);
            }
            for (ChannelSftp.LsEntry ent : list2) {
                String n = ent.getFilename();
                if (".".equals(n) || "..".equals(n)) continue;
                String nPath = dir + "/" + n;
                if (ent.getAttrs().isDir()) {
                    this.readLooseRefs(avail, nPath, prefix + n + "/");
                    continue;
                }
                this.readRef(avail, nPath, prefix + n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Ref readRef(TreeMap<String, Ref> avail, String path2, String name2) throws TransportException {
            String line2;
            try {
                BufferedReader br = this.openReader(path2);
                try {
                    line2 = br.readLine();
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    br.close();
                    throw throwable;
                }
                br.close();
                {
                }
            }
            catch (FileNotFoundException noRef) {
                return null;
            }
            catch (IOException err2) {
                throw new TransportException("Cannot read " + this.objectsPath + "/" + path2 + ": " + err2.getMessage(), err2);
            }
            if (line2 == null) {
                throw new TransportException("Empty ref: " + name2);
            }
            if (line2.startsWith("ref: ")) {
                String target = line2.substring("ref: ".length());
                Ref r = avail.get(target);
                if (r == null) {
                    r = this.readRef(avail, "../" + target, target);
                }
                if (r == null) {
                    r = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
                }
                r = new SymbolicRef(name2, r);
                avail.put(r.getName(), r);
                return r;
            }
            if (ObjectId.isId(line2)) {
                ObjectIdRef.Unpeeled r = new ObjectIdRef.Unpeeled(this.loose(avail.get(name2)), name2, ObjectId.fromString(line2));
                avail.put(r.getName(), r);
                return r;
            }
            throw new TransportException("Bad ref: " + name2 + ": " + line2);
        }

        private Ref.Storage loose(Ref r) {
            if (r != null && r.getStorage() == Ref.Storage.PACKED) {
                return Ref.Storage.LOOSE_PACKED;
            }
            return Ref.Storage.LOOSE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void close() {
            if (this.ftp != null) {
                try {
                    if (this.ftp.isConnected()) {
                        this.ftp.disconnect();
                    }
                    Object var2_1 = null;
                    this.ftp = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.ftp = null;
                    throw throwable;
                }
            }
        }
    }
}

