/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WalkRemoteObjectDatabase {
    static final String ROOT_DIR = "../";
    static final String INFO_PACKS = "info/packs";
    static final String INFO_ALTERNATES = "info/alternates";
    static final String INFO_HTTP_ALTERNATES = "info/http-alternates";
    static final String INFO_REFS = "../info/refs";

    WalkRemoteObjectDatabase() {
    }

    abstract URIish getURI();

    abstract Collection<String> getPackNames() throws IOException;

    abstract Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException;

    abstract FileStream open(String var1) throws FileNotFoundException, IOException;

    abstract WalkRemoteObjectDatabase openAlternate(String var1) throws IOException;

    abstract void close();

    void deleteFile(String path2) throws IOException {
        throw new IOException(MessageFormat.format(JGitText.get().deletingNotSupported, path2));
    }

    OutputStream writeFile(String path2, ProgressMonitor monitor, String monitorTask) throws IOException {
        throw new IOException(MessageFormat.format(JGitText.get().writingNotSupported, path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFile(String path2, byte[] data) throws IOException {
        OutputStream os = this.writeFile(path2, null, null);
        try {
            os.write(data);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    void deleteRef(String name2) throws IOException {
        this.deleteFile(ROOT_DIR + name2);
    }

    void deleteRefLog(String name2) throws IOException {
        this.deleteFile("../logs/" + name2);
    }

    void writeRef(String name2, ObjectId value2) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream(41);
        value2.copyTo(b);
        b.write(10);
        this.writeFile(ROOT_DIR + name2, b.toByteArray());
    }

    void writeInfoPacks(Collection<String> packNames) throws IOException {
        StringBuilder w = new StringBuilder();
        for (String n : packNames) {
            w.append("P ");
            w.append(n);
            w.append('\n');
        }
        this.writeFile(INFO_PACKS, Constants.encodeASCII(w.toString()));
    }

    BufferedReader openReader(String path2) throws IOException {
        InputStream is = this.open((String)path2).in;
        return new BufferedReader(new InputStreamReader(is, Constants.CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<WalkRemoteObjectDatabase> readAlternates(String listPath) throws IOException {
        ArrayList<WalkRemoteObjectDatabase> arrayList;
        BufferedReader br = this.openReader(listPath);
        try {
            String line2;
            ArrayList<WalkRemoteObjectDatabase> alts = new ArrayList<WalkRemoteObjectDatabase>();
            while ((line2 = br.readLine()) != null) {
                if (!line2.endsWith("/")) {
                    line2 = line2 + "/";
                }
                alts.add(this.openAlternate(line2));
            }
            arrayList = alts;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            br.close();
            throw throwable;
        }
        br.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPackedRefs(Map<String, Ref> avail) throws TransportException {
        try {
            BufferedReader br = this.openReader("../packed-refs");
            try {
                this.readPackedRefsImpl(avail, br);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                br.close();
                throw throwable;
            }
            br.close();
            {
            }
        }
        catch (FileNotFoundException notPacked) {
        }
        catch (IOException e) {
            throw new TransportException(this.getURI(), JGitText.get().errorInPackedRefs, e);
        }
    }

    private void readPackedRefsImpl(Map<String, Ref> avail, BufferedReader br) throws IOException {
        String line2;
        Ref last2 = null;
        boolean peeled = false;
        while ((line2 = br.readLine()) != null) {
            if (line2.charAt(0) == '#') {
                if (!line2.startsWith("# pack-refs with:")) continue;
                line2 = line2.substring("# pack-refs with:".length());
                peeled = line2.contains(" peeled");
                continue;
            }
            if (line2.charAt(0) == '^') {
                if (last2 == null) {
                    throw new TransportException(JGitText.get().peeledLineBeforeRef);
                }
                ObjectId id2 = ObjectId.fromString(line2.substring(1));
                last2 = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last2.getName(), last2.getObjectId(), id2);
                avail.put(last2.getName(), last2);
                continue;
            }
            int sp2 = line2.indexOf(32);
            if (sp2 < 0) {
                throw new TransportException(MessageFormat.format(JGitText.get().unrecognizedRef, line2));
            }
            ObjectId id3 = ObjectId.fromString(line2.substring(0, sp2));
            String name2 = line2.substring(sp2 + 1);
            last2 = peeled ? new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name2, id3) : new ObjectIdRef.Unpeeled(Ref.Storage.PACKED, name2, id3);
            avail.put(last2.getName(), last2);
        }
    }

    static final class FileStream {
        final InputStream in;
        final long length;

        FileStream(InputStream i) {
            this.in = i;
            this.length = -1L;
        }

        FileStream(InputStream i, long n) {
            this.in = i;
            this.length = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] toArray() throws IOException {
            byte[] byArray;
            block4: {
                if (this.length < 0L) break block4;
                byte[] r = new byte[(int)this.length];
                IO.readFully(this.in, r, 0, r.length);
                byte[] byArray2 = r;
                Object var6_5 = null;
                this.in.close();
                return byArray2;
            }
            try {
                int n;
                ByteArrayOutputStream r = new ByteArrayOutputStream();
                byte[] buf = new byte[2048];
                while ((n = this.in.read(buf)) >= 0) {
                    r.write(buf, 0, n);
                }
                byArray = r.toByteArray();
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.in.close();
                throw throwable;
            }
            this.in.close();
            return byArray;
        }
    }
}

