/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.FS;

public class FileUtils {
    public static final int NONE = 0;
    public static final int RECURSIVE = 1;
    public static final int RETRY = 2;
    public static final int SKIP_MISSING = 4;
    public static final int IGNORE_ERRORS = 8;
    public static final int EMPTY_DIRECTORIES_ONLY = 16;

    public static void delete(File f2) throws IOException {
        FileUtils.delete(f2, 0);
    }

    public static void delete(File f2, int options2) throws IOException {
        File[] items;
        FS fs = FS.DETECTED;
        if ((options2 & 4) != 0 && !fs.exists(f2)) {
            return;
        }
        if ((options2 & 1) != 0 && fs.isDirectory(f2) && (items = f2.listFiles()) != null) {
            ArrayList<File> files2 = new ArrayList<File>();
            ArrayList<File> dirs2 = new ArrayList<File>();
            for (File c : items) {
                if (c.isFile()) {
                    files2.add(c);
                    continue;
                }
                dirs2.add(c);
            }
            for (File file2 : files2) {
                FileUtils.delete(file2, options2);
            }
            for (File d : dirs2) {
                FileUtils.delete(d, options2);
            }
        }
        boolean delete = false;
        if ((options2 & 0x10) != 0) {
            if (f2.isDirectory()) {
                delete = true;
            } else if ((options2 & 8) == 0) {
                throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, f2.getAbsolutePath()));
            }
        } else {
            delete = true;
        }
        if (delete && !f2.delete()) {
            if ((options2 & 2) != 0 && fs.exists(f2)) {
                for (int i = 1; i < 10; ++i) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!f2.delete()) continue;
                    return;
                }
            }
            if ((options2 & 8) == 0) {
                throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, f2.getAbsolutePath()));
            }
        }
    }

    public static void rename(File src, File dst) throws IOException {
        int attempts;
        int n = attempts = FS.DETECTED.retryFailedLockFileCommit() ? 10 : 1;
        while (--attempts >= 0) {
            if (src.renameTo(dst)) {
                return;
            }
            try {
                if (!dst.delete()) {
                    FileUtils.delete(dst, 17);
                }
                if (src.renameTo(dst)) {
                    return;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, src.getAbsolutePath(), dst.getAbsolutePath()));
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, src.getAbsolutePath(), dst.getAbsolutePath()));
    }

    public static void mkdir(File d) throws IOException {
        FileUtils.mkdir(d, false);
    }

    public static void mkdir(File d, boolean skipExisting) throws IOException {
        if (!d.mkdir()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirFailed, d.getAbsolutePath()));
        }
    }

    public static void mkdirs(File d) throws IOException {
        FileUtils.mkdirs(d, false);
    }

    public static void mkdirs(File d, boolean skipExisting) throws IOException {
        if (!d.mkdirs()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirsFailed, d.getAbsolutePath()));
        }
    }

    public static void createNewFile(File f2) throws IOException {
        if (!f2.createNewFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().createNewFileFailed, f2));
        }
    }

    public static void createSymLink(File path2, String target) throws IOException {
        FS.DETECTED.createSymLink(path2, target);
    }

    public static String readSymLink(File path2) throws IOException {
        return FS.DETECTED.readSymLink(path2);
    }

    public static File createTempDir(String prefix, String suffix, File dir) throws IOException {
        boolean RETRIES = true;
        for (int i = 0; i < 1; ++i) {
            File tmp = File.createTempFile(prefix, suffix, dir);
            if (!tmp.delete() || !tmp.mkdir()) continue;
            return tmp;
        }
        throw new IOException(JGitText.get().cannotCreateTempDir);
    }
}

