/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.TemporaryBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IO {
    public static final byte[] readFully(File path2) throws FileNotFoundException, IOException {
        return IO.readFully(path2, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readSome(File path2, int limit) throws FileNotFoundException, IOException {
        int cnt;
        byte[] buf;
        FileInputStream in;
        block8: {
            byte[] n22;
            in = new FileInputStream(path2);
            try {
                int n22;
                buf = new byte[limit];
                cnt = 0;
                while ((n22 = in.read(buf, cnt, buf.length - cnt)) > 0) {
                    cnt += n22;
                }
                if (cnt != buf.length) break block8;
                n22 = buf;
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    in.close();
                }
                catch (IOException ignored) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return n22;
        }
        byte[] res = new byte[cnt];
        System.arraycopy(buf, 0, res, 0, cnt);
        byte[] byArray = res;
        Object var8_9 = null;
        try {
            in.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readFully(File path2, int max2) throws FileNotFoundException, IOException {
        byte[] byArray;
        FileInputStream in = new FileInputStream(path2);
        try {
            long sz = Math.max(path2.length(), 1L);
            if (sz > (long)max2) {
                throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path2));
            }
            byte[] buf = new byte[(int)sz];
            int valid = 0;
            while (true) {
                int n;
                if (buf.length == valid) {
                    if (buf.length == max2) {
                        int next2 = in.read();
                        if (next2 < 0) break;
                        throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path2));
                    }
                    byte[] nb = new byte[Math.min(buf.length * 2, max2)];
                    System.arraycopy(buf, 0, nb, 0, valid);
                    buf = nb;
                }
                if ((n = in.read(buf, valid, buf.length - valid)) < 0) break;
                valid += n;
            }
            if (valid < buf.length) {
                byte[] nb = new byte[valid];
                System.arraycopy(buf, 0, nb, 0, valid);
                buf = nb;
            }
            byArray = buf;
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                in.close();
            }
            catch (IOException ignored) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return byArray;
    }

    public static ByteBuffer readWholeStream(InputStream in, int sizeHint) throws IOException {
        int pos;
        int read2;
        byte[] out = new byte[sizeHint];
        for (pos = 0; pos < out.length; pos += read2) {
            read2 = in.read(out, pos, out.length - pos);
            if (read2 >= 0) continue;
            return ByteBuffer.wrap(out, 0, pos);
        }
        int last2 = in.read();
        if (last2 < 0) {
            return ByteBuffer.wrap(out, 0, pos);
        }
        TemporaryBuffer.Heap tmp = new TemporaryBuffer.Heap(Integer.MAX_VALUE);
        tmp.write(out);
        tmp.write(last2);
        tmp.copy(in);
        return ByteBuffer.wrap(tmp.toByteArray());
    }

    public static void readFully(InputStream fd, byte[] dst, int off, int len2) throws IOException {
        while (len2 > 0) {
            int r = fd.read(dst, off, len2);
            if (r <= 0) {
                throw new EOFException(JGitText.get().shortReadOfBlock);
            }
            off += r;
            len2 -= r;
        }
    }

    public static int read(ReadableByteChannel channel, byte[] dst, int off, int len2) throws IOException {
        int r;
        if (len2 == 0) {
            return 0;
        }
        int cnt = 0;
        while (0 < len2 && (r = channel.read(ByteBuffer.wrap(dst, off, len2))) > 0) {
            off += r;
            len2 -= r;
            cnt += r;
        }
        return cnt != 0 ? cnt : -1;
    }

    public static int readFully(InputStream fd, byte[] dst, int off) throws IOException {
        int len2;
        int r;
        for (len2 = 0; (r = fd.read(dst, off, dst.length - off)) >= 0 && len2 < dst.length; len2 += r) {
            off += r;
        }
        return len2;
    }

    public static void skipFully(InputStream fd, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            toSkip -= r;
        }
    }

    public static List<String> readLines(String s2) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\n') {
                l.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (c == '\r') {
                if (i + 1 < s2.length()) {
                    c = s2.charAt(++i);
                    l.add(sb.toString());
                    sb.setLength(0);
                    if (c == '\n') continue;
                    sb.append(c);
                    continue;
                }
                l.add(sb.toString());
                break;
            }
            sb.append(c);
        }
        l.add(sb.toString());
        return l;
    }

    private IO() {
    }
}

