/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.util.RefList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefMap
extends AbstractMap<String, Ref> {
    private final String prefix;
    private RefList<Ref> packed;
    private RefList<Ref> loose;
    private RefList<Ref> resolved;
    private int size;
    private boolean sizeIsValid;
    private Set<Map.Entry<String, Ref>> entrySet;

    public RefMap() {
        this.prefix = "";
        this.packed = RefList.emptyList();
        this.loose = RefList.emptyList();
        this.resolved = RefList.emptyList();
    }

    public RefMap(String prefix, RefList<? extends Ref> packed, RefList<? extends Ref> loose, RefList<? extends Ref> resolved) {
        this.prefix = prefix;
        this.packed = packed;
        this.loose = loose;
        this.resolved = resolved;
    }

    @Override
    public boolean containsKey(Object name2) {
        return this.get(name2) != null;
    }

    @Override
    public Ref get(Object key) {
        String name2 = this.toRefName((String)key);
        Ref ref = this.resolved.get(name2);
        if (ref == null) {
            ref = this.loose.get(name2);
        }
        if (ref == null) {
            ref = this.packed.get(name2);
        }
        return ref;
    }

    @Override
    public Ref put(String keyName, Ref value2) {
        Ref prior;
        int idx;
        String name2 = this.toRefName(keyName);
        if (!name2.equals(value2.getName())) {
            throw new IllegalArgumentException();
        }
        if (!this.resolved.isEmpty()) {
            for (Ref ref : this.resolved) {
                this.loose = this.loose.put(ref);
            }
            this.resolved = RefList.emptyList();
        }
        if (0 <= (idx = this.loose.find(name2))) {
            prior = this.loose.get(name2);
            this.loose = this.loose.set(idx, value2);
            return prior;
        }
        prior = this.get(keyName);
        this.loose = this.loose.add(idx, value2);
        this.sizeIsValid = false;
        return prior;
    }

    @Override
    public Ref remove(Object key) {
        String name2 = this.toRefName((String)key);
        Ref res = null;
        int idx = this.packed.find(name2);
        if (0 <= idx) {
            res = this.packed.get(name2);
            this.packed = this.packed.remove(idx);
            this.sizeIsValid = false;
        }
        if (0 <= (idx = this.loose.find(name2))) {
            res = this.loose.get(name2);
            this.loose = this.loose.remove(idx);
            this.sizeIsValid = false;
        }
        if (0 <= (idx = this.resolved.find(name2))) {
            res = this.resolved.get(name2);
            this.resolved = this.resolved.remove(idx);
            this.sizeIsValid = false;
        }
        return res;
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public Set<Map.Entry<String, Ref>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<String, Ref>>(){

                @Override
                public Iterator<Map.Entry<String, Ref>> iterator() {
                    return new SetIterator();
                }

                @Override
                public int size() {
                    if (!RefMap.this.sizeIsValid) {
                        RefMap.this.size = 0;
                        Iterator<Map.Entry<String, Ref>> i = RefMap.this.entrySet().iterator();
                        while (i.hasNext()) {
                            RefMap.this.size++;
                            i.next();
                        }
                        RefMap.this.sizeIsValid = true;
                    }
                    return RefMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    if (RefMap.this.sizeIsValid) {
                        return 0 == RefMap.this.size;
                    }
                    return !this.iterator().hasNext();
                }

                @Override
                public void clear() {
                    RefMap.this.packed = RefList.emptyList();
                    RefMap.this.loose = RefList.emptyList();
                    RefMap.this.resolved = RefList.emptyList();
                    RefMap.this.size = 0;
                    RefMap.this.sizeIsValid = true;
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public String toString() {
        StringBuilder r = new StringBuilder();
        boolean first = true;
        r.append('[');
        for (Ref ref : this.values()) {
            if (first) {
                first = false;
            } else {
                r.append(", ");
            }
            r.append(ref);
        }
        r.append(']');
        return r.toString();
    }

    private String toRefName(String name2) {
        if (0 < this.prefix.length()) {
            name2 = this.prefix + name2;
        }
        return name2;
    }

    private String toMapKey(Ref ref) {
        String name2 = ref.getName();
        if (0 < this.prefix.length()) {
            name2 = name2.substring(this.prefix.length());
        }
        return name2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Ent
    implements Map.Entry<String, Ref> {
        private Ref ref;

        Ent(Ref ref) {
            this.ref = ref;
        }

        @Override
        public String getKey() {
            return RefMap.this.toMapKey(this.ref);
        }

        @Override
        public Ref getValue() {
            return this.ref;
        }

        @Override
        public Ref setValue(Ref value2) {
            Ref prior = RefMap.this.put(this.getKey(), value2);
            this.ref = value2;
            return prior;
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode();
        }

        @Override
        public boolean equals(Object obj2) {
            if (obj2 instanceof Map.Entry) {
                Ref r;
                Object key = ((Map.Entry)obj2).getKey();
                Object val = ((Map.Entry)obj2).getValue();
                if (key instanceof String && val instanceof Ref && (r = (Ref)val).getName().equals(this.ref.getName())) {
                    ObjectId a = r.getObjectId();
                    ObjectId b = this.ref.getObjectId();
                    if (a != null && b != null && AnyObjectId.equals(a, b)) {
                        return true;
                    }
                }
            }
            return false;
        }

        public String toString() {
            return this.ref.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetIterator
    implements Iterator<Map.Entry<String, Ref>> {
        private int packedIdx;
        private int looseIdx;
        private int resolvedIdx;
        private Map.Entry<String, Ref> next;

        SetIterator() {
            if (0 < RefMap.this.prefix.length()) {
                this.packedIdx = -(RefMap.this.packed.find(RefMap.this.prefix) + 1);
                this.looseIdx = -(RefMap.this.loose.find(RefMap.this.prefix) + 1);
                this.resolvedIdx = -(RefMap.this.resolved.find(RefMap.this.prefix) + 1);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.peek();
            }
            return this.next != null;
        }

        @Override
        public Map.Entry<String, Ref> next() {
            if (this.hasNext()) {
                Map.Entry<String, Ref> r = this.next;
                this.next = this.peek();
                return r;
            }
            throw new NoSuchElementException();
        }

        public Map.Entry<String, Ref> peek() {
            if (this.packedIdx < RefMap.this.packed.size() && this.looseIdx < RefMap.this.loose.size()) {
                Object l;
                Object p = RefMap.this.packed.get(this.packedIdx);
                int cmp = RefComparator.compareTo(p, l = RefMap.this.loose.get(this.looseIdx));
                if (cmp < 0) {
                    ++this.packedIdx;
                    return this.toEntry((Ref)p);
                }
                if (cmp == 0) {
                    ++this.packedIdx;
                }
                ++this.looseIdx;
                return this.toEntry(this.resolveLoose((Ref)l));
            }
            if (this.looseIdx < RefMap.this.loose.size()) {
                return this.toEntry(this.resolveLoose((Ref)RefMap.this.loose.get(this.looseIdx++)));
            }
            if (this.packedIdx < RefMap.this.packed.size()) {
                return this.toEntry((Ref)RefMap.this.packed.get(this.packedIdx++));
            }
            return null;
        }

        private Ref resolveLoose(Ref l) {
            if (this.resolvedIdx < RefMap.this.resolved.size()) {
                Object r = RefMap.this.resolved.get(this.resolvedIdx);
                int cmp = RefComparator.compareTo(l, r);
                if (cmp == 0) {
                    ++this.resolvedIdx;
                    return r;
                }
                if (cmp > 0) {
                    throw new IllegalStateException();
                }
            }
            return l;
        }

        private Ent toEntry(Ref p) {
            if (p.getName().startsWith(RefMap.this.prefix)) {
                return new Ent(p);
            }
            this.packedIdx = RefMap.this.packed.size();
            this.looseIdx = RefMap.this.loose.size();
            this.resolvedIdx = RefMap.this.resolved.size();
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

