/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;

public abstract class TemporaryBuffer
extends OutputStream {
    protected static final int DEFAULT_IN_CORE_LIMIT = 0x100000;
    private ArrayList<Block> blocks;
    private int inCoreLimit;
    private OutputStream overflow;

    protected TemporaryBuffer(int limit) {
        this.inCoreLimit = limit;
        this.reset();
    }

    public void write(int b) throws IOException {
        if (this.overflow != null) {
            this.overflow.write(b);
            return;
        }
        Block s2 = this.last();
        if (s2.isFull()) {
            if (this.reachedInCoreLimit()) {
                this.overflow.write(b);
                return;
            }
            s2 = new Block();
            this.blocks.add(s2);
        }
        s2.buffer[s2.count++] = (byte)b;
    }

    public void write(byte[] b, int off, int len2) throws IOException {
        if (this.overflow == null) {
            while (len2 > 0) {
                Block s2 = this.last();
                if (s2.isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    s2 = new Block();
                    this.blocks.add(s2);
                }
                int n = Math.min(s2.buffer.length - s2.count, len2);
                System.arraycopy(b, off, s2.buffer, s2.count, n);
                s2.count += n;
                len2 -= n;
                off += n;
            }
        }
        if (len2 > 0) {
            this.overflow.write(b, off, len2);
        }
    }

    protected void doFlush() throws IOException {
        if (this.overflow == null) {
            this.switchToOverflow();
        }
        this.overflow.flush();
    }

    public void copy(InputStream in) throws IOException {
        int n;
        if (this.blocks != null) {
            while (true) {
                Block s2;
                if ((s2 = this.last()).isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    s2 = new Block();
                    this.blocks.add(s2);
                }
                if ((n = in.read(s2.buffer, s2.count, s2.buffer.length - s2.count)) < 1) {
                    return;
                }
                s2.count += n;
            }
        }
        byte[] tmp = new byte[8192];
        while ((n = in.read(tmp)) > 0) {
            this.overflow.write(tmp, 0, n);
        }
    }

    public long length() {
        return this.inCoreLength();
    }

    private long inCoreLength() {
        Block last2 = this.last();
        return ((long)this.blocks.size() - 1L) * 8192L + (long)last2.count;
    }

    public byte[] toByteArray() throws IOException {
        long len2 = this.length();
        if (Integer.MAX_VALUE < len2) {
            throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
        }
        byte[] out = new byte[(int)len2];
        int outPtr = 0;
        for (Block b : this.blocks) {
            System.arraycopy(b.buffer, 0, out, outPtr, b.count);
            outPtr += b.count;
        }
        return out;
    }

    public void writeTo(OutputStream os, ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        for (Block b : this.blocks) {
            os.write(b.buffer, 0, b.count);
            pm.update(b.count / 1024);
        }
    }

    public InputStream openInputStream() throws IOException {
        return new BlockInputStream();
    }

    public void reset() {
        if (this.overflow != null) {
            this.destroy();
        }
        if (this.inCoreLimit < 8192) {
            this.blocks = new ArrayList(1);
            this.blocks.add(new Block(this.inCoreLimit));
        } else {
            this.blocks = new ArrayList(this.inCoreLimit / 8192);
            this.blocks.add(new Block());
        }
    }

    protected abstract OutputStream overflow() throws IOException;

    private Block last() {
        return this.blocks.get(this.blocks.size() - 1);
    }

    private boolean reachedInCoreLimit() throws IOException {
        if (this.inCoreLength() < (long)this.inCoreLimit) {
            return false;
        }
        this.switchToOverflow();
        return true;
    }

    private void switchToOverflow() throws IOException {
        this.overflow = this.overflow();
        Block last2 = this.blocks.remove(this.blocks.size() - 1);
        for (Block b : this.blocks) {
            this.overflow.write(b.buffer, 0, b.count);
        }
        this.blocks = null;
        this.overflow = new SafeBufferedOutputStream(this.overflow, 8192);
        this.overflow.write(last2.buffer, 0, last2.count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.overflow != null) {
            try {
                this.overflow.close();
                Object var2_1 = null;
                this.overflow = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.overflow = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.blocks = null;
        if (this.overflow != null) {
            try {
                try {
                    this.overflow.close();
                }
                catch (IOException iOException) {
                    Object var3_2 = null;
                    this.overflow = null;
                }
                Object var3_1 = null;
                this.overflow = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.overflow = null;
                throw throwable;
            }
        }
    }

    static class Block {
        static final int SZ = 8192;
        final byte[] buffer;
        int count;

        Block() {
            this.buffer = new byte[8192];
        }

        Block(int sz) {
            this.buffer = new byte[sz];
        }

        boolean isFull() {
            return this.count == this.buffer.length;
        }
    }

    private class BlockInputStream
    extends InputStream {
        private byte[] singleByteBuffer;
        private int blockIndex;
        private Block block;
        private int blockPos;

        BlockInputStream() {
            this.block = (Block)TemporaryBuffer.this.blocks.get(this.blockIndex);
        }

        public int read() throws IOException {
            int n;
            if (this.singleByteBuffer == null) {
                this.singleByteBuffer = new byte[1];
            }
            return (n = this.read(this.singleByteBuffer)) == 1 ? this.singleByteBuffer[0] & 0xFF : -1;
        }

        public long skip(long cnt) throws IOException {
            long skipped = 0L;
            while (0L < cnt) {
                int n = (int)Math.min((long)(this.block.count - this.blockPos), cnt);
                if (0 < n) {
                    this.blockPos += n;
                    skipped += (long)n;
                    cnt -= (long)n;
                    continue;
                }
                if (this.nextBlock()) continue;
            }
            return skipped;
        }

        public int read(byte[] b, int off, int len2) throws IOException {
            if (len2 == 0) {
                return 0;
            }
            int copied = 0;
            while (0 < len2) {
                int c = Math.min(this.block.count - this.blockPos, len2);
                if (0 < c) {
                    System.arraycopy(this.block.buffer, this.blockPos, b, off, c);
                    this.blockPos += c;
                    off += c;
                    len2 -= c;
                    copied += c;
                    continue;
                }
                if (this.nextBlock()) continue;
            }
            return 0 < copied ? copied : -1;
        }

        private boolean nextBlock() {
            if (++this.blockIndex < TemporaryBuffer.this.blocks.size()) {
                this.block = (Block)TemporaryBuffer.this.blocks.get(this.blockIndex);
                this.blockPos = 0;
                return true;
            }
            return false;
        }
    }

    public static class Heap
    extends TemporaryBuffer {
        public Heap(int limit) {
            super(limit);
        }

        protected OutputStream overflow() throws IOException {
            throw new IOException(JGitText.get().inMemoryBufferLimitExceeded);
        }
    }

    public static class LocalFile
    extends TemporaryBuffer {
        private final File directory;
        private File onDiskFile;

        @Deprecated
        public LocalFile() {
            this(null, 0x100000);
        }

        @Deprecated
        public LocalFile(int inCoreLimit) {
            this(null, inCoreLimit);
        }

        public LocalFile(File directory) {
            this(directory, 0x100000);
        }

        public LocalFile(File directory, int inCoreLimit) {
            super(inCoreLimit);
            this.directory = directory;
        }

        protected OutputStream overflow() throws IOException {
            this.onDiskFile = File.createTempFile("jgit_", ".buf", this.directory);
            return new FileOutputStream(this.onDiskFile);
        }

        public long length() {
            if (this.onDiskFile == null) {
                return super.length();
            }
            return this.onDiskFile.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] toByteArray() throws IOException {
            if (this.onDiskFile == null) {
                return super.toByteArray();
            }
            long len2 = this.length();
            if (Integer.MAX_VALUE < len2) {
                throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
            }
            byte[] out = new byte[(int)len2];
            FileInputStream in = new FileInputStream(this.onDiskFile);
            try {
                IO.readFully(in, out, 0, (int)len2);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream os, ProgressMonitor pm) throws IOException {
            if (this.onDiskFile == null) {
                super.writeTo(os, pm);
                return;
            }
            if (pm == null) {
                pm = NullProgressMonitor.INSTANCE;
            }
            FileInputStream in = new FileInputStream(this.onDiskFile);
            try {
                int cnt;
                byte[] buf = new byte[8192];
                while ((cnt = in.read(buf)) >= 0) {
                    os.write(buf, 0, cnt);
                    pm.update(cnt / 1024);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                in.close();
                throw throwable;
            }
            in.close();
        }

        public InputStream openInputStream() throws IOException {
            if (this.onDiskFile == null) {
                return super.openInputStream();
            }
            return new FileInputStream(this.onDiskFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            super.destroy();
            if (this.onDiskFile != null) {
                try {
                    if (!this.onDiskFile.delete()) {
                        this.onDiskFile.deleteOnExit();
                    }
                    Object var2_1 = null;
                    this.onDiskFile = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.onDiskFile = null;
                    throw throwable;
                }
            }
        }
    }
}

