/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.diff.RawText;

public class AutoCRLFInputStream
extends InputStream {
    static final int BUFFER_SIZE = 8096;
    private final byte[] single = new byte[1];
    private final byte[] buf = new byte[8096];
    private final InputStream in;
    private int cnt;
    private int ptr;
    private boolean isBinary;
    private boolean detectBinary;
    private byte last;

    public AutoCRLFInputStream(InputStream in, boolean detectBinary) {
        this.in = in;
        this.detectBinary = detectBinary;
    }

    public int read() throws IOException {
        int read2 = this.read(this.single, 0, 1);
        return read2 == 1 ? this.single[0] & 0xFF : -1;
    }

    public int read(byte[] bs, int off, int len2) throws IOException {
        int n;
        if (len2 == 0) {
            return 0;
        }
        if (this.cnt == -1) {
            return -1;
        }
        int i = off;
        int end2 = off + len2;
        while (i < end2 && (this.ptr != this.cnt || this.fillBuffer())) {
            byte b = this.buf[this.ptr++];
            if (this.isBinary || b != 10) {
                bs[i++] = this.last = b;
                continue;
            }
            if (b == 10) {
                if (this.last == 13) {
                    bs[i++] = this.last = b;
                    continue;
                }
                int n2 = i++;
                this.last = (byte)13;
                bs[n2] = 13;
                --this.ptr;
                continue;
            }
            bs[i++] = this.last = b;
        }
        int n3 = n = i == off ? -1 : i - off;
        if (n > 0) {
            this.last = bs[i - 1];
        }
        return n;
    }

    public void close() throws IOException {
        this.in.close();
    }

    private boolean fillBuffer() throws IOException {
        this.cnt = this.in.read(this.buf, 0, this.buf.length);
        if (this.cnt < 1) {
            return false;
        }
        if (this.detectBinary) {
            this.isBinary = RawText.isBinary(this.buf, this.cnt);
            this.detectBinary = false;
        }
        this.ptr = 0;
        return true;
    }
}

