/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.diff.RawText;

public class AutoCRLFOutputStream
extends OutputStream {
    static final int BUFFER_SIZE = 8000;
    private final OutputStream out;
    private int buf = -1;
    private byte[] binbuf = new byte[8000];
    private byte[] onebytebuf = new byte[1];
    private int binbufcnt = 0;
    private boolean isBinary;

    public AutoCRLFOutputStream(OutputStream out) {
        this.out = out;
    }

    public void write(int b) throws IOException {
        this.onebytebuf[0] = (byte)b;
        this.write(this.onebytebuf, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        int overflow = this.buffer(b, 0, b.length);
        if (overflow > 0) {
            this.write(b, b.length - overflow, overflow);
        }
    }

    public void write(byte[] b, int startOff, int startLen) throws IOException {
        int overflow = this.buffer(b, startOff, startLen);
        if (overflow < 0) {
            return;
        }
        int off = startOff + startLen - overflow;
        int len2 = overflow;
        if (len2 == 0) {
            return;
        }
        int lastw = off;
        if (this.isBinary) {
            this.out.write(b, off, len2);
            return;
        }
        for (int i = off; i < off + len2; ++i) {
            byte c = b[i];
            if (c == 13) {
                this.buf = 13;
                continue;
            }
            if (c == 10) {
                if (this.buf != 13) {
                    if (lastw < i) {
                        this.out.write(b, lastw, i - lastw);
                    }
                    this.out.write(13);
                    lastw = i;
                }
                this.buf = -1;
                continue;
            }
            this.buf = -1;
        }
        if (lastw < off + len2) {
            this.out.write(b, lastw, off + len2 - lastw);
        }
        if (b[off + len2 - 1] == 13) {
            this.buf = 13;
        }
    }

    private int buffer(byte[] b, int off, int len2) throws IOException {
        if (this.binbufcnt > this.binbuf.length) {
            return len2;
        }
        int copy2 = Math.min(this.binbuf.length - this.binbufcnt, len2);
        System.arraycopy(b, off, this.binbuf, this.binbufcnt, copy2);
        this.binbufcnt += copy2;
        int remaining = len2 - copy2;
        if (remaining > 0) {
            this.decideMode();
        }
        return remaining;
    }

    private void decideMode() throws IOException {
        this.isBinary = RawText.isBinary(this.binbuf, this.binbufcnt);
        int cachedLen = this.binbufcnt;
        this.binbufcnt = this.binbuf.length + 1;
        this.write(this.binbuf, 0, cachedLen);
    }

    public void flush() throws IOException {
        if (this.binbufcnt <= this.binbuf.length) {
            this.decideMode();
        }
        this.buf = -1;
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

